/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.exchange;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tssoft.kege.exchange.ArchiveEntry;

public class ZipArchive {
    private static final Logger logger = LoggerFactory.getLogger(ZipArchive.class);
    private Cipher cipher;

    public void setCipher(Cipher cipher) {
        this.cipher = cipher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pack(OutputStream outputStream, Iterator<ArchiveEntry> entries) throws IOException {
        ZipOutputStream zipStream = new ZipOutputStream(outputStream);
        try {
            while (entries.hasNext()) {
                ArchiveEntry archiveEntry = entries.next();
                ZipEntry zipEntry = new ZipEntry(archiveEntry.getName());
                zipStream.putNextEntry(zipEntry);
                byte[] entryBytes = archiveEntry.getBytes();
                if (this.cipher != null) {
                    try {
                        entryBytes = this.cipher.doFinal(entryBytes);
                    }
                    catch (IllegalBlockSizeException ex) {
                        logger.error(null, (Throwable)ex);
                    }
                    catch (BadPaddingException ex) {
                        logger.error(null, (Throwable)ex);
                    }
                }
                zipStream.write(entryBytes, 0, entryBytes.length);
                zipStream.closeEntry();
            }
        }
        finally {
            zipStream.close();
        }
    }

    public Iterator<ArchiveEntry> unpack(InputStream inputStream) throws IOException {
        final ZipInputStream zipStream = new ZipInputStream(inputStream);
        return new Iterator<ArchiveEntry>(){
            private ZipEntry zipEntry;

            @Override
            public boolean hasNext() {
                try {
                    this.zipEntry = zipStream.getNextEntry();
                }
                catch (IOException ex) {
                    logger.error(null, (Throwable)ex);
                }
                return this.zipEntry != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ArchiveEntry next() {
                ArchiveEntry entry = null;
                byte[] buf = new byte[1024];
                try {
                    ByteArrayOutputStream bufferStream = new ByteArrayOutputStream();
                    try {
                        int length;
                        while ((length = zipStream.read(buf, 0, 1024)) > -1) {
                            bufferStream.write(buf, 0, length);
                        }
                        byte[] entryBytes = bufferStream.toByteArray();
                        if (ZipArchive.this.cipher != null) {
                            entryBytes = ZipArchive.this.cipher.doFinal(entryBytes);
                        }
                        entry = new ArchiveEntry(this.zipEntry.getName(), entryBytes);
                    }
                    finally {
                        zipStream.closeEntry();
                    }
                }
                catch (IOException ex) {
                    logger.error(null, (Throwable)ex);
                }
                catch (GeneralSecurityException ex) {
                    logger.error(null, (Throwable)ex);
                }
                return entry;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }
}

