/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.kim;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.codec.binary.Base64;
import ru.tssoft.kege.dao.FileStorageDao;
import ru.tssoft.kege.exchange.ArchiveEntry;
import ru.tssoft.kege.exchange.ExchangeException;
import ru.tssoft.kege.exchange.PackageCipher;
import ru.tssoft.kege.kim.KimFileIdGenerator;
import ru.tssoft.kege.kim.KimVariantExtractor;
import ru.tssoft.kege.kim.VariantDto;
import ru.tssoft.kege.model.ExamInfo;

public class KimPdfExtractor
extends KimVariantExtractor {
    private static final String PDF_DEFAULT_ERROR = "\u041f\u0440\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u0435 PDF \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430";
    private FileStorageDao storageDao;

    public KimPdfExtractor(FileStorageDao storageDao, PackageCipher cipher, ExamInfo examInfo) {
        super(null, cipher, examInfo);
        this.storageDao = storageDao;
    }

    @Override
    public void extract(ArchiveEntry archiveEntry) throws ExchangeException {
        if (!this.isExtractable(archiveEntry)) {
            return;
        }
        try {
            InputStream inputStream = this.getInputStream(archiveEntry);
            VariantDto variant = this.extractVariant(inputStream);
            this.validateExamMatch(variant);
            byte[] decodedPdf = Base64.decodeBase64((String)variant.getPdf());
            String fileId = KimFileIdGenerator.idByVariantCode(variant.getVariantCode());
            this.storageDao.storeFile(fileId, fileId, new ByteArrayInputStream(decodedPdf));
        }
        catch (KimVariantExtractor.VariantExamException e) {
            throw new ExchangeException(e.getMessage(), e.getMessage(), e);
        }
        catch (Throwable e) {
            throw new ExchangeException(PDF_DEFAULT_ERROR, e.getMessage(), e);
        }
    }
}

