/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.kim;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.tssoft.kege.admin.persistence.DataMapper;
import ru.tssoft.kege.exchange.ArchiveEntry;
import ru.tssoft.kege.exchange.ExchangeException;
import ru.tssoft.kege.exchange.PackageCipher;
import ru.tssoft.kege.exchange.XmlEntity;
import ru.tssoft.kege.exchange.XmlProcessor;
import ru.tssoft.kege.kim.KimEntryExtractor;
import ru.tssoft.kege.kim.VariantDto;
import ru.tssoft.kege.metadata.EntityMetadata;
import ru.tssoft.kege.metadata.MetadataManager;
import ru.tssoft.kege.metadata.ValidationException;
import ru.tssoft.kege.model.ExamInfo;
import ru.tssoft.kege.security.InternalEncryptCipher;
import ru.tssoft.kege.xml.BomHelper;
import ru.tssoft.kege.xml.XmlDomHelper;

public class KimVariantExtractor
implements KimEntryExtractor {
    private static final Logger logger = LoggerFactory.getLogger(KimVariantExtractor.class);
    private static final String VARIANT_DEFAULT_ERROR = "\u041f\u0440\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u0435 \u0432\u0430\u0440\u0438\u0430\u043d\u0442\u0430 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430";
    protected final DataSource dataSource;
    protected final PackageCipher cipher;
    protected ExamInfo examInfo;
    private final EntityMetadata<VariantDto> entityMetadata;

    public KimVariantExtractor(DataSource dataSource, PackageCipher cipher, ExamInfo examInfo) {
        this.dataSource = dataSource;
        this.cipher = cipher;
        this.examInfo = examInfo;
        this.entityMetadata = MetadataManager.getInstance().getMetadata(VariantDto.class);
    }

    @Override
    public boolean isExtractable(ArchiveEntry archiveEntry) {
        String entryName = archiveEntry.getName();
        XmlEntity xmlEntity = this.entityMetadata.getAnnotation(XmlEntity.class);
        return xmlEntity.wildcard() ? entryName.matches(xmlEntity.source()) : entryName.equals(xmlEntity.source());
    }

    @Override
    public void extract(ArchiveEntry archiveEntry) throws ExchangeException {
        if (!this.isExtractable(archiveEntry)) {
            return;
        }
        try {
            InputStream inputStream = this.getInputStream(archiveEntry);
            inputStream.reset();
            XmlDomHelper domHelper = new XmlDomHelper(inputStream);
            Node pdfNode = domHelper.getNode("/Variant/PDF");
            pdfNode.getParentNode().removeChild(pdfNode);
            NodeList items = domHelper.getNodeList("/Variant/Item");
            for (int i = 0; i < items.getLength(); ++i) {
                Node itemNode = items.item(i);
                itemNode.getParentNode().removeChild(itemNode);
            }
            inputStream = new ByteArrayInputStream(domHelper.toByteArray());
            VariantDto variant = this.extractVariant(inputStream);
            this.validateExamMatch(variant);
            byte[] sourceXml = variant.getXmlText();
            InternalEncryptCipher kimCipher = InternalEncryptCipher.getInstance();
            byte[] cryptedXml = kimCipher.process(sourceXml);
            variant.setXmlText(cryptedXml);
            DataMapper<VariantDto> dtoMapper = new DataMapper<VariantDto>(this.entityMetadata, this.dataSource);
            try {
                dtoMapper.create(variant);
            }
            catch (SQLException ex) {
                logger.error(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438 '%s' \u0432 \u0411\u0414 ", this.entityMetadata.getEntityName()), (Throwable)ex);
                throw ex;
            }
            catch (ValidationException ex) {
                logger.error(String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438 '%s' ", this.entityMetadata.getEntityName()), (Throwable)ex);
                throw ex;
            }
        }
        catch (VariantExamException e) {
            throw new ExchangeException(e.getMessage(), e.getMessage(), e);
        }
        catch (Throwable e) {
            throw new ExchangeException(VARIANT_DEFAULT_ERROR, e.getMessage(), e);
        }
    }

    protected InputStream getInputStream(ArchiveEntry archiveEntry) throws Exception {
        byte[] content = this.cipher.process(archiveEntry);
        content = BomHelper.removeBomAndTrim(content);
        return new ByteArrayInputStream(content);
    }

    protected VariantDto extractVariant(InputStream inputStream) throws Throwable {
        XmlProcessor<VariantDto> xmlProcessor = new XmlProcessor<VariantDto>();
        List<VariantDto> variants = xmlProcessor.unmarshal(this.entityMetadata, inputStream);
        return variants != null && !variants.isEmpty() ? variants.get(0) : null;
    }

    protected void validateExamMatch(VariantDto variant) throws VariantExamException {
        if (this.examInfo.getExamGlobalId() != variant.getExamGlobalId()) {
            throw new VariantExamException(String.format("\u0412\u0430\u0440\u0438\u0430\u043d\u0442 (%s) \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u0434\u043b\u044f \u0434\u0440\u0443\u0433\u043e\u0433\u043e \u044d\u043a\u0437\u0430\u043c\u0435\u043d\u0430: %i (\u043e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f %i)", variant.getVariantCode(), variant.getExamGlobalId(), this.examInfo.getExamGlobalId()));
        }
        if (this.examInfo.getRegion() != variant.getRegion()) {
            throw new VariantExamException(String.format("\u0412\u0430\u0440\u0438\u0430\u043d\u0442 (%s) \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u0434\u043b\u044f \u0434\u0440\u0443\u0433\u043e\u0433\u043e \u0440\u0435\u0433\u0438\u043e\u043d\u0430: %i (\u043e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f %i)", variant.getVariantCode(), variant.getRegion(), this.examInfo.getRegion()));
        }
        if (!DateUtils.isSameDay((Date)this.examInfo.getDate(), (Date)variant.getExamDate())) {
            throw new VariantExamException(String.format("\u0412\u0430\u0440\u0438\u0430\u043d\u0442 (%1$s) \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u0434\u043b\u044f \u0434\u0440\u0443\u0433\u043e\u0439 \u0434\u0430\u0442\u044b \u044d\u043a\u0437\u0430\u043c\u0435\u043d\u0430: %2$td.%2$tm.%2$tY (\u043e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f %3$td.%3$tm.%3$tY)", variant.getVariantCode(), variant.getExamDate(), this.examInfo.getDate()));
        }
    }

    class VariantExamException
    extends Exception {
        public VariantExamException(String message) {
            super(message);
        }
    }
}

