/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import ru.tssoft.kege.metadata.ColumnFormat;
import ru.tssoft.kege.metadata.ColumnType;
import ru.tssoft.kege.metadata.Deleted;
import ru.tssoft.kege.metadata.ValidationCheck;
import ru.tssoft.kege.metadata.ValidationException;

public class FieldColumn
implements ValidationCheck {
    private Field field;
    private Column column;
    private boolean required = false;
    private int maxLength;
    private GeneratedValue generatedValue;
    private ColumnFormat columnFormat;
    private List<Integer> deletedFlagValues;
    private final boolean persisted;

    public FieldColumn(Field field) {
        this.field = field;
        this.column = field.getAnnotation(Column.class);
        boolean bl = this.persisted = this.column != null;
        if (this.persisted) {
            this.maxLength = this.column.length();
        }
        if (field.isAnnotationPresent(Basic.class)) {
            Basic basic = field.getAnnotation(Basic.class);
            boolean bl2 = this.required = !basic.optional();
        }
        if (field.isAnnotationPresent(GeneratedValue.class)) {
            this.generatedValue = field.getAnnotation(GeneratedValue.class);
        }
        if (field.isAnnotationPresent(ColumnFormat.class)) {
            this.columnFormat = field.getAnnotation(ColumnFormat.class);
        }
        if (field.isAnnotationPresent(Deleted.class)) {
            this.deletedFlagValues = new ArrayList<Integer>();
            Deleted deleted = field.getAnnotation(Deleted.class);
            for (int i = 0; i < deleted.value().length; ++i) {
                this.deletedFlagValues.add(deleted.value()[i]);
            }
        }
    }

    public FieldColumn(Object owner, String fieldName) throws NoSuchFieldException {
        this(owner.getClass().getDeclaredField(fieldName));
    }

    @Override
    public void validate(Object entity) throws ValidationException {
        ValidationException validationCause;
        Object value;
        ValidationException validationException = new ValidationException(this.getFieldName());
        try {
            value = this.getValue(entity);
        }
        catch (ValidationException ex) {
            validationException.addCause(ex);
            throw validationException;
        }
        if (this.required && (value == null || value instanceof String && ((String)value).trim().isEmpty()) && this.generatedValue == null) {
            validationCause = new ValidationException(this.getFieldName(), "\u041f\u043e\u043b\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c \u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c");
            validationCause.setValue(value);
            validationException.addCause(validationCause);
        }
        if (value != null && this.field.getType().equals(String.class) && ((String)value).length() > this.maxLength) {
            validationCause = new ValidationException(this.getFieldName(), String.format("\u041f\u043e\u043b\u0435 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0434\u043b\u0438\u043d\u043d\u0435\u0435 %d \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432", this.maxLength));
            validationCause.setValue(value);
            validationException.addCause(validationCause);
        }
        if (!validationException.getCauses().isEmpty()) {
            validationException.setSourceColumn(this);
            throw validationException;
        }
    }

    public Object getValue(Object entity) throws ValidationException {
        try {
            this.field.setAccessible(true);
            return this.field.get(entity);
        }
        catch (IllegalAccessException ex) {
            ValidationException vex = new ValidationException(this.getFieldName(), "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u043b\u044f");
            vex.setSourceColumn(this);
            throw vex;
        }
    }

    public void setValue(Object entity, Object value) throws ValidationException {
        try {
            this.field.setAccessible(true);
            this.field.set(entity, value);
        }
        catch (IllegalAccessException ex) {
            ValidationException vex = new ValidationException(this.getFieldName(), "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0438\u0441\u0432\u043e\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u043b\u044f");
            vex.setSourceColumn(this);
            throw vex;
        }
    }

    public Class<?> getFieldType() {
        return this.field.getType();
    }

    public Class<?> getColumnType() {
        Class<Object> columnType = this.field.getType();
        if (this.field.isAnnotationPresent(ColumnType.class)) {
            columnType = this.field.getAnnotation(ColumnType.class).value();
        } else if (this.field.getType().equals(java.util.Date.class) && this.field.isAnnotationPresent(Temporal.class)) {
            TemporalType temporalType = this.field.getAnnotation(Temporal.class).value();
            if (temporalType.equals((Object)TemporalType.TIMESTAMP)) {
                columnType = Timestamp.class;
            } else if (temporalType.equals((Object)TemporalType.DATE)) {
                columnType = Date.class;
            } else if (temporalType.equals((Object)TemporalType.TIME)) {
                columnType = Time.class;
            }
        } else if (this.field.getType().isEnum() && this.field.isAnnotationPresent(Enumerated.class)) {
            EnumType enumType = this.field.getAnnotation(Enumerated.class).value();
            columnType = enumType.equals((Object)EnumType.ORDINAL) ? Integer.class : String.class;
        } else if (this.field.getType().equals(Short.TYPE)) {
            columnType = Short.class;
        } else if (this.field.getType().equals(Integer.TYPE)) {
            columnType = Integer.class;
        } else if (this.field.getType().equals(Boolean.TYPE)) {
            columnType = Boolean.class;
        }
        return columnType;
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public String getColumnName() {
        return this.persisted ? this.column.name().toUpperCase() : null;
    }

    public boolean isRequired() {
        return this.required;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public boolean isGenerated() {
        return this.generatedValue != null;
    }

    public GeneratedValue getGeneratedValue() {
        return this.generatedValue;
    }

    public ColumnFormat getColumnFormat() {
        return this.columnFormat;
    }

    public boolean isDeleted(Object entity) throws ValidationException {
        Integer flagValue;
        if (this.deletedFlagValues == null) {
            return false;
        }
        Object deletedValue = this.getValue(entity);
        Integer n = flagValue = deletedValue != null ? Integer.valueOf(deletedValue.toString()) : null;
        return this.deletedFlagValues.isEmpty() ? !new Integer(0).equals(flagValue) : flagValue != null && this.deletedFlagValues.contains(flagValue);
    }

    public List<ValidationCheck> getValidationChecks() {
        return Arrays.asList(this);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.field.getAnnotation(annotationClass);
    }

    public <T extends Annotation> boolean isAnnotated(Class<T> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    public boolean isPersisted() {
        return this.persisted;
    }
}

