/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.metadata;

import java.util.Arrays;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import javax.persistence.Query;
import ru.tssoft.kege.admin.persistence.QueryBuilder;
import ru.tssoft.kege.metadata.FieldColumn;
import ru.tssoft.kege.metadata.FieldColumnValue;
import ru.tssoft.kege.metadata.UnsupportedTypeConversion;
import ru.tssoft.kege.metadata.ValidationCheck;
import ru.tssoft.kege.metadata.ValidationException;

public class UniqueConstraintCheck
implements ValidationCheck {
    private String tableName;
    private FieldColumn[] columns;

    public UniqueConstraintCheck(String tableName, FieldColumn[] columns) {
        this.tableName = tableName;
        this.columns = columns;
    }

    @Override
    public void validate(Object entity) throws ValidationException {
        QueryBuilder builder = new QueryBuilder();
        builder.nativeCode(String.format("select count(*) from %s ", this.tableName));
        builder.where(Arrays.asList(this.columns));
        ValidationException vex = new ValidationException(this.tableName);
        try {
            EntityManager em = Persistence.createEntityManagerFactory((String)"applicationPU").createEntityManager();
            Query nativeQuery = em.createNativeQuery(builder.toString());
            for (FieldColumn fieldColumn : this.columns) {
                nativeQuery.setParameter(fieldColumn.getFieldName(), new FieldColumnValue(fieldColumn).getColumnValue(fieldColumn.getValue(entity)));
            }
            Integer count = (Integer)nativeQuery.getSingleResult();
            if (count != 0) {
                for (FieldColumn fieldColumn : this.columns) {
                    vex.addCause(new ValidationException(fieldColumn.getFieldName(), "\u0423\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u043f\u0438\u0441\u044c \u0441 \u0442\u0430\u043a\u0438\u043c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435\u043c \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u044f"));
                }
            }
        }
        catch (UnsupportedTypeConversion ex) {
            vex.addCause(new ValidationException(this.tableName, "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043f\u043e\u043b\u044f \u043d\u0430 \u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u044c"));
        }
        if (!vex.getCauses().isEmpty()) {
            throw vex;
        }
    }

    public FieldColumn[] getColumns() {
        return this.columns;
    }
}

