/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tssoft.kege.exchange.ArchiveEntry;
import ru.tssoft.kege.exchange.PackageCipher;
import ru.tssoft.kege.kim.MismatchedKimKeyException;
import ru.tssoft.kege.security.RbdCertificateHelper;

public class CertificateDecryptCipher
implements PackageCipher {
    private static final Logger logger = LoggerFactory.getLogger(CertificateDecryptCipher.class);
    protected Cipher decryptCipher;

    public void loadKey(InputStream keyStoreStream) throws Exception {
        RbdCertificateHelper certificateHelper;
        try {
            certificateHelper = new RbdCertificateHelper(keyStoreStream);
        }
        catch (Exception ex) {
            throw new Exception("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043a\u043b\u044e\u0447\u0430", ex);
        }
        PrivateKey privateKey = certificateHelper.getPrivateKey();
        this.decryptCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        this.decryptCipher.init(2, privateKey);
    }

    @Override
    public byte[] process(ArchiveEntry entry) throws Exception {
        int l;
        if (entry == null) {
            return new byte[0];
        }
        ByteArrayInputStream encodedStream = new ByteArrayInputStream(entry.getBytes());
        byte[] keyLengthBytes = new byte[4];
        encodedStream.read(keyLengthBytes);
        int keyLength = this.toInt32(keyLengthBytes);
        logger.debug("\u0414\u043b\u0438\u043d\u0430 \u043a\u043b\u044e\u0447\u0430: {}", (Object)keyLength);
        byte[] ivLengthBytes = new byte[4];
        encodedStream.read(ivLengthBytes);
        int ivLength = this.toInt32(ivLengthBytes);
        logger.debug("\u0414\u043b\u0438\u043d\u0430 \u0432\u0435\u043a\u0442\u043e\u0440\u0430: {}", (Object)ivLength);
        byte[] encryptedKey = new byte[keyLength];
        encodedStream.read(encryptedKey);
        byte[] keyBytes = null;
        try {
            keyBytes = this.decryptCipher.doFinal(encryptedKey);
        }
        catch (BadPaddingException ex) {
            throw new MismatchedKimKeyException(ex);
        }
        byte[] ivBytes = new byte[ivLength];
        encodedStream.read(ivBytes);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        Cipher aesCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        aesCipher.init(2, (Key)key, iv);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        CipherInputStream decryptedStream = new CipherInputStream(encodedStream, aesCipher);
        byte[] buffer = new byte[aesCipher.getBlockSize()];
        while ((l = decryptedStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, l);
        }
        decryptedStream.close();
        return outputStream.toByteArray();
    }

    private int toInt32(byte[] bytes) throws Exception {
        if (bytes.length != 4) {
            throw new IllegalArgumentException();
        }
        return 0xFF & bytes[0] | (0xFF & bytes[1]) << 8 | (0xFF & bytes[2]) << 16 | (0xFF & bytes[3]) << 24;
    }
}

