/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.security;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class InternalCipher {
    private static final String CIPHER_KEY_FILENAME = "cipher.key.filename";
    private Cipher cipher;
    private byte[] cipherBytes;

    public InternalCipher(int mode) throws Exception {
        String keyFileName = System.getProperty(CIPHER_KEY_FILENAME);
        CipherBytesProvider cipherBytesProvider = StringUtils.isEmpty((CharSequence)keyFileName) ? new MacAddressBytesProvider() : new KeyFileBytesProvider(keyFileName);
        byte[] keyBytes = cipherBytesProvider.getKeyBytes();
        SecretKeySpec key = new SecretKeySpec(keyBytes, "DESede");
        byte[] ivBytes = cipherBytesProvider.getInitialVectorBytes();
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        this.cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
        this.cipher.init(mode, (Key)key, iv);
        this.cipherBytes = new byte[keyBytes.length + ivBytes.length];
        ByteBuffer buffer = ByteBuffer.wrap(this.cipherBytes);
        buffer.put(keyBytes);
        buffer.put(ivBytes);
    }

    public synchronized byte[] process(byte[] data) throws Exception {
        return this.cipher.doFinal(data);
    }

    public byte[] toByteArray() {
        return this.cipherBytes;
    }

    private class KeyFileBytesProvider
    implements CipherBytesProvider {
        private static final int INITIAL_VECTOR_LENGTH = 8;
        private byte[] keyBytes;
        private byte[] inititialVectorBytes;

        public KeyFileBytesProvider(String fileName) throws Exception {
            FileInputStream is = new FileInputStream(fileName);
            byte[] fileBytes = IOUtils.toByteArray((InputStream)is);
            is.close();
            this.keyBytes = ArrayUtils.subarray((byte[])fileBytes, (int)0, (int)(fileBytes.length - 8));
            this.inititialVectorBytes = ArrayUtils.subarray((byte[])fileBytes, (int)(fileBytes.length - 8), (int)fileBytes.length);
        }

        @Override
        public byte[] getKeyBytes() throws Exception {
            return this.keyBytes;
        }

        @Override
        public byte[] getInitialVectorBytes() {
            return this.inititialVectorBytes;
        }
    }

    private class MacAddressBytesProvider
    implements CipherBytesProvider {
        private MacAddressBytesProvider() {
        }

        @Override
        public byte[] getKeyBytes() throws Exception {
            ArrayList<String> macAddresses = new ArrayList<String>();
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface net = networkInterfaces.nextElement();
                byte[] macBytes = net.getHardwareAddress();
                if (net.isLoopback() || macBytes == null) continue;
                StringBuilder macBuilder = new StringBuilder();
                for (byte b : macBytes) {
                    macBuilder.append(Integer.toHexString(b));
                }
                macAddresses.add(macBuilder.toString());
            }
            Collections.sort(macAddresses, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o2.length() - o1.length();
                }
            });
            String macAddr = (String)macAddresses.iterator().next();
            MessageDigest md = MessageDigest.getInstance("md5");
            byte[] digestOfPassword = md.digest(macAddr.getBytes("utf-8"));
            byte[] keyBytes = Arrays.copyOf(digestOfPassword, 24);
            int j = 0;
            int k = 16;
            while (j < 8) {
                keyBytes[k++] = keyBytes[j++];
            }
            return keyBytes;
        }

        @Override
        public byte[] getInitialVectorBytes() {
            return new byte[]{42, 18, 68, 99, 31, 0, 111, 29};
        }
    }

    private static interface CipherBytesProvider {
        public byte[] getKeyBytes() throws Exception;

        public byte[] getInitialVectorBytes();
    }
}

