/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.servlet;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyFilter
implements Filter {
    private static final String HEADER_NAME = "x-forwarded-for";
    private static final String REDIRECT_PAGE = "checkproxy.html";
    private static final Logger logger = LoggerFactory.getLogger(ProxyFilter.class);
    private List<String> ignoredUrlList;

    public void init(FilterConfig filterConfig) throws ServletException {
        String ignoredUrls = filterConfig.getInitParameter("ignoredUrls");
        if (StringUtils.isNotEmpty((CharSequence)ignoredUrls)) {
            this.ignoredUrlList = Arrays.asList(ignoredUrls.split(","));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequestWrapper requestWrapper;
        String header;
        String url = ((HttpServletRequest)request).getRequestURI();
        boolean isIgnore = url.endsWith(REDIRECT_PAGE);
        if (this.ignoredUrlList != null) {
            Iterator<String> iterator = this.ignoredUrlList.iterator();
            while (!isIgnore && iterator.hasNext()) {
                String ignoredUrl = iterator.next();
                isIgnore = url.startsWith(ignoredUrl);
            }
        }
        if (!isIgnore && StringUtils.isNotEmpty((CharSequence)(header = (requestWrapper = new HttpServletRequestWrapper((HttpServletRequest)request)).getHeader(HEADER_NAME)))) {
            String contextPath = ((HttpServletRequest)request).getContextPath();
            if (!contextPath.endsWith("/")) {
                contextPath = contextPath + "/";
            }
            String redirect = contextPath + REDIRECT_PAGE;
            logger.info(String.format("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d http header '%s' \u0434\u043b\u044f IP = %s, \u0440\u0435\u0434\u0438\u0440\u0435\u043a\u0442 \u043d\u0430 '%s'", HEADER_NAME, request.getRemoteAddr(), redirect));
            ((HttpServletResponse)response).sendRedirect(redirect);
            return;
        }
        filterChain.doFilter(request, response);
    }

    public void destroy() {
    }
}

