/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.batik.apps.svgbrowser.HistoryBrowser;
import org.apache.batik.apps.svgbrowser.HistoryBrowserInterface;
import org.apache.batik.util.gui.DropDownComponent;
import org.apache.batik.util.resources.ResourceManager;

public class DropDownHistoryModel
implements DropDownComponent.ScrollablePopupMenuModel {
    private static final String RESOURCES = "org.apache.batik.apps.svgbrowser.resources.DropDownHistoryModelMessages";
    private static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.apps.svgbrowser.resources.DropDownHistoryModelMessages", Locale.getDefault());
    private static ResourceManager resources = new ResourceManager(bundle);
    protected ArrayList items = new ArrayList();
    protected HistoryBrowserInterface historyBrowserInterface;
    protected DropDownComponent.ScrollablePopupMenu parent;

    public DropDownHistoryModel(DropDownComponent.ScrollablePopupMenu parent, HistoryBrowserInterface historyBrowserInterface) {
        this.parent = parent;
        this.historyBrowserInterface = historyBrowserInterface;
        historyBrowserInterface.getHistoryBrowser().addListener(new HistoryBrowser.HistoryBrowserAdapter(){

            public void historyReset(HistoryBrowser.HistoryBrowserEvent event) {
                DropDownHistoryModel.this.clearAllScrollablePopupMenuItems("");
            }
        });
    }

    public String getFooterText() {
        return "";
    }

    public DropDownComponent.ScrollablePopupMenuItem createItem(String itemName) {
        return new DropDownComponent.DefaultScrollablePopupMenuItem(this.parent, itemName);
    }

    protected void addItem(DropDownComponent.ScrollablePopupMenuItem item, String details) {
        int oldSize = this.items.size();
        this.items.add(0, item);
        this.parent.add(item, 0, oldSize, this.items.size());
        this.parent.fireItemsWereAdded(new DropDownComponent.ScrollablePopupMenuEvent(this.parent, 1, 1, details));
    }

    protected void removeItem(DropDownComponent.ScrollablePopupMenuItem item, String details) {
        int oldSize = this.items.size();
        ((AbstractCollection)this.items).remove(item);
        this.parent.remove(item, oldSize, this.items.size());
        this.parent.fireItemsWereRemoved(new DropDownComponent.ScrollablePopupMenuEvent(this.parent, 2, 1, details));
    }

    protected boolean removeLastScrollablePopupMenuItem(String details) {
        int i = this.items.size() - 1;
        if (i >= 0) {
            DropDownComponent.ScrollablePopupMenuItem item = (DropDownComponent.ScrollablePopupMenuItem)this.items.get(i);
            this.removeItem(item, details);
            return true;
        }
        return false;
    }

    protected boolean removeFirstScrollablePopupMenuItem(String details) {
        int i = 0;
        if (i < this.items.size()) {
            DropDownComponent.ScrollablePopupMenuItem item = (DropDownComponent.ScrollablePopupMenuItem)this.items.get(i);
            this.removeItem(item, details);
            return true;
        }
        return false;
    }

    protected void clearAllScrollablePopupMenuItems(String details) {
        while (this.removeLastScrollablePopupMenuItem(details)) {
        }
    }

    public void processItemClicked() {
    }

    public void processBeforeShowed() {
        this.historyBrowserInterface.performCurrentCompoundCommand();
    }

    public void processAfterShowed() {
    }

    static /* synthetic */ ResourceManager access$000() {
        return resources;
    }

    public static class RedoPopUpMenuModel
    extends DropDownHistoryModel {
        protected static String REDO_FOOTER_TEXT = DropDownHistoryModel.access$000().getString("RedoModel.footerText");
        protected static String REDO_TOOLTIP_PREFIX = DropDownHistoryModel.access$000().getString("RedoModel.tooltipPrefix");

        public RedoPopUpMenuModel(DropDownComponent.ScrollablePopupMenu parent, HistoryBrowserInterface historyBrowserInterface) {
            super(parent, historyBrowserInterface);
            this.init();
        }

        private void init() {
            this.historyBrowserInterface.getHistoryBrowser().addListener(new HistoryBrowser.HistoryBrowserAdapter(this){
                private final /* synthetic */ RedoPopUpMenuModel this$0;
                {
                    this.this$0 = this$0;
                }

                public void executePerformed(HistoryBrowser.HistoryBrowserEvent event) {
                    HistoryBrowser.CommandNamesInfo info = (HistoryBrowser.CommandNamesInfo)event.getSource();
                    String details = RedoPopUpMenuModel.REDO_TOOLTIP_PREFIX + info.getLastRedoableCommandName();
                    this.this$0.clearAllScrollablePopupMenuItems(details);
                }

                public void undoPerformed(HistoryBrowser.HistoryBrowserEvent event) {
                    HistoryBrowser.CommandNamesInfo info = (HistoryBrowser.CommandNamesInfo)event.getSource();
                    String details = RedoPopUpMenuModel.REDO_TOOLTIP_PREFIX + info.getLastRedoableCommandName();
                    this.this$0.addItem(this.this$0.createItem(info.getCommandName()), details);
                }

                public void redoPerformed(HistoryBrowser.HistoryBrowserEvent event) {
                    HistoryBrowser.CommandNamesInfo info = (HistoryBrowser.CommandNamesInfo)event.getSource();
                    String details = RedoPopUpMenuModel.REDO_TOOLTIP_PREFIX + info.getLastRedoableCommandName();
                    this.this$0.removeFirstScrollablePopupMenuItem(details);
                }

                public void doCompoundEdit(HistoryBrowser.HistoryBrowserEvent event) {
                    if (this.this$0.parent.isEnabled()) {
                        this.this$0.parent.setEnabled(false);
                    }
                }

                public void compoundEditPerformed(HistoryBrowser.HistoryBrowserEvent event) {
                }
            });
        }

        public String getFooterText() {
            return REDO_FOOTER_TEXT;
        }

        public void processItemClicked() {
            this.historyBrowserInterface.getHistoryBrowser().compoundRedo(this.parent.getSelectedItemsCount());
        }
    }

    public static class UndoPopUpMenuModel
    extends DropDownHistoryModel {
        protected static String UNDO_FOOTER_TEXT = DropDownHistoryModel.access$000().getString("UndoModel.footerText");
        protected static String UNDO_TOOLTIP_PREFIX = DropDownHistoryModel.access$000().getString("UndoModel.tooltipPrefix");

        public UndoPopUpMenuModel(DropDownComponent.ScrollablePopupMenu parent, HistoryBrowserInterface historyBrowserInterface) {
            super(parent, historyBrowserInterface);
            this.init();
        }

        private void init() {
            this.historyBrowserInterface.getHistoryBrowser().addListener(new HistoryBrowser.HistoryBrowserAdapter(this){
                private final /* synthetic */ UndoPopUpMenuModel this$0;
                {
                    this.this$0 = this$0;
                }

                public void executePerformed(HistoryBrowser.HistoryBrowserEvent event) {
                    HistoryBrowser.CommandNamesInfo info = (HistoryBrowser.CommandNamesInfo)event.getSource();
                    String details = UndoPopUpMenuModel.UNDO_TOOLTIP_PREFIX + info.getLastUndoableCommandName();
                    this.this$0.addItem(this.this$0.createItem(info.getCommandName()), details);
                }

                public void undoPerformed(HistoryBrowser.HistoryBrowserEvent event) {
                    HistoryBrowser.CommandNamesInfo info = (HistoryBrowser.CommandNamesInfo)event.getSource();
                    String details = UndoPopUpMenuModel.UNDO_TOOLTIP_PREFIX + info.getLastUndoableCommandName();
                    this.this$0.removeFirstScrollablePopupMenuItem(details);
                }

                public void redoPerformed(HistoryBrowser.HistoryBrowserEvent event) {
                    HistoryBrowser.CommandNamesInfo info = (HistoryBrowser.CommandNamesInfo)event.getSource();
                    String details = UndoPopUpMenuModel.UNDO_TOOLTIP_PREFIX + info.getLastUndoableCommandName();
                    this.this$0.addItem(this.this$0.createItem(info.getCommandName()), details);
                }

                public void doCompoundEdit(HistoryBrowser.HistoryBrowserEvent event) {
                    if (!this.this$0.parent.isEnabled()) {
                        this.this$0.parent.setEnabled(true);
                    }
                }

                public void compoundEditPerformed(HistoryBrowser.HistoryBrowserEvent event) {
                }
            });
        }

        public String getFooterText() {
            return UNDO_FOOTER_TEXT;
        }

        public void processItemClicked() {
            this.historyBrowserInterface.getHistoryBrowser().compoundUndo(this.parent.getSelectedItemsCount());
        }
    }
}

