/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.fop;

import java.awt.geom.Point2D;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.BarcodeException;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.BarcodeUtil;
import org.krysalis.barcode4j.fop.BarcodeObj;
import org.krysalis.barcode4j.fop.VariableUtil;
import org.krysalis.barcode4j.tools.ConfigurationUtil;
import org.krysalis.barcode4j.tools.MessageUtil;
import org.krysalis.barcode4j.tools.UnitConv;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class BarcodeElement
extends BarcodeObj {
    public BarcodeElement(FONode parent) {
        super(parent);
    }

    public void processNode(String elementName, Locator locator, Attributes attlist, PropertyList propertyList) throws FOPException {
        super.processNode(elementName, locator, attlist, propertyList);
        this.init();
    }

    private void init() {
        this.createBasicDocument();
    }

    public Point2D getDimension(Point2D view) {
        Configuration cfg = ConfigurationUtil.buildConfiguration(this.doc);
        try {
            String msg = ConfigurationUtil.getMessage(cfg);
            msg = MessageUtil.unescapeUnicode(msg);
            int orientation = cfg.getAttributeAsInteger("orientation", 0);
            orientation = BarcodeDimension.normalizeOrientation(orientation);
            BarcodeGenerator bargen = BarcodeUtil.getInstance().createBarcodeGenerator(cfg);
            String expandedMsg = VariableUtil.getExpandedMessage(null, msg);
            BarcodeDimension bardim = bargen.calcDimensions(expandedMsg);
            float w = (float)UnitConv.mm2pt(bardim.getWidthPlusQuiet(orientation));
            float h = (float)UnitConv.mm2pt(bardim.getHeightPlusQuiet(orientation));
            return new Point2D.Float(w, h);
        }
        catch (ConfigurationException ce) {
            ce.printStackTrace();
        }
        catch (BarcodeException be) {
            be.printStackTrace();
        }
        return null;
    }
}

