/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.tomcat;

import java.io.File;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.commons.dbcp.BasicDataSourceFactory;

public class CustomDatasourceFactory
extends BasicDataSourceFactory {
    private static String bootPassword = CustomDatasourceFactory.generateBootPassword();

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            File home = new File(System.getenv("KEGE_HOME"), "app/database");
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append("jdbc:derby:");
            urlBuilder.append(home.getAbsolutePath());
            String password = this.getBootPassword(ref);
            if (!"".equals(password)) {
                urlBuilder.append(";dataEncryption=true;bootPassword=");
                urlBuilder.append(this.getBootPassword(ref));
            }
            this.replace(ref, "url", urlBuilder.toString());
            this.replace(ref, "username", "APP");
            this.replace(ref, "password", "APP");
        }
        return super.getObjectInstance(obj, name, nameCtx, environment);
    }

    private void replace(Reference ref, String refType, String value) throws Exception {
        int idx = this.find(ref, refType);
        if (idx != -1) {
            ref.remove(idx);
        }
        ref.add(new StringRefAddr(refType, value));
    }

    private int find(Reference ref, String addrType) throws Exception {
        Enumeration<RefAddr> enu = ref.getAll();
        int i = 0;
        while (enu.hasMoreElements()) {
            RefAddr addr = enu.nextElement();
            if (addr.getType().compareTo(addrType) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String getBootPassword(Reference ref) {
        RefAddr refAddr = ref.get("bootPassword");
        if (refAddr == null) {
            return bootPassword;
        }
        return refAddr.getContent().toString();
    }

    private static String generateBootPassword() {
        String password = "iN5s30RfJ72x";
        ArrayList<String> macs = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface ni = networkInterfaces.nextElement();
                byte[] macBytes = ni.getHardwareAddress();
                if (macBytes == null) continue;
                StringBuilder sb = new StringBuilder();
                for (byte b : macBytes) {
                    sb.append(Integer.toHexString(b));
                }
                String mac = sb.toString();
                if (mac.length() < 8 || macs.contains(mac)) continue;
                macs.add(mac);
            }
            if (macs.size() > 0) {
                Collections.sort(macs, Collections.reverseOrder());
                password = (String)macs.get(0);
            }
            return password;
        }
        catch (SocketException ex) {
            return password;
        }
    }
}

