/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.tomcat;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

public class LocalRequestFilterValve
extends ValveBase {
    private String deny;
    private List<String> denied;

    public void invoke(Request request, Response response) throws IOException, ServletException {
        boolean matched = true;
        if (this.denied != null && !this.denied.isEmpty()) {
            matched = this.denied.contains(request.getServletPath());
        }
        if (matched && !this.isLocalAddress(InetAddress.getByName(request.getRemoteAddr()))) {
            response.sendError(403);
            return;
        }
        this.getNext().invoke(request, response);
    }

    private boolean isLocalAddress(InetAddress addr) {
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }

    public String getDeny() {
        return this.deny;
    }

    public void setDeny(String deny) {
        this.deny = deny;
        this.denied = Arrays.asList(deny.split(","));
    }
}

