/*
 * Decompiled with CFR 0.152.
 */
package ru.tssoft.kege.tomcat;

import java.io.Console;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatLifecycleListener
implements LifecycleListener {
    private static final Logger logger = LoggerFactory.getLogger(TomcatLifecycleListener.class);
    private static final String KEGE_HOME = "KEGE_HOME";
    protected static Charset consoleCharset;

    public TomcatLifecycleListener() {
        Constructor<?> ctor = null;
        Constructor<?>[] ctors = Console.class.getDeclaredConstructors();
        for (int i = 0; i < ctors.length && (ctor = ctors[i]).getGenericParameterTypes().length != 0; ++i) {
        }
        try {
            ctor.setAccessible(true);
            Console c = (Console)ctor.newInstance(new Object[0]);
            Field f = c.getClass().getDeclaredField("cs");
            f.setAccessible(true);
            Object charset = f.get(c);
            consoleCharset = Charset.forName(String.valueOf(charset));
        }
        catch (Exception ex) {
            logger.debug("", (Throwable)ex);
            consoleCharset = Charset.defaultCharset();
        }
    }

    public void lifecycleEvent(LifecycleEvent le) {
        if ("before_init".equals(le.getType())) {
            try {
                this.logSystemInfo();
            }
            catch (Exception ex) {
                logger.error("", (Throwable)ex);
            }
            System.err.println(new String("\u041f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435, \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0437\u0430\u043f\u0443\u0441\u043a \u0441\u0438\u0441\u0442\u0435\u043c\u044b...".getBytes(consoleCharset)));
        } else if ("after_start".equals(le.getType())) {
            System.err.println(new String("\u0421\u0438\u0441\u0442\u0435\u043c\u0430 \u0433\u043e\u0442\u043e\u0432\u0430 \u043a \u0440\u0430\u0431\u043e\u0442\u0435".getBytes(consoleCharset)));
        }
    }

    private void logSystemInfo() throws Exception {
        logger.debug("{}={}", (Object)KEGE_HOME, (Object)System.getenv(KEGE_HOME));
        Properties properties = System.getProperties();
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = (String)propertyNames.nextElement();
            logger.debug("{}={}", (Object)key, (Object)properties.getProperty(key));
        }
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface net = networkInterfaces.nextElement();
            byte[] macBytes = net.getHardwareAddress();
            if (net.isLoopback() || macBytes == null) continue;
            StringBuilder macBuilder = new StringBuilder();
            for (byte b : macBytes) {
                macBuilder.append(Integer.toHexString(b));
            }
            StringBuilder ipBuilder = new StringBuilder();
            Enumeration<InetAddress> inetAddresses = net.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress addr = inetAddresses.nextElement();
                ipBuilder.append(addr.getHostAddress());
                if (!inetAddresses.hasMoreElements()) continue;
                ipBuilder.append(", ");
            }
            logger.debug("[{}] {} {}", new Object[]{macBuilder.toString(), net.toString(), ipBuilder.toString()});
        }
    }
}

