<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>

<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Неверная версия браузера</title>
        <style>
            .error-box {
                border: 2px solid #C04141;
                margin: 0 auto;
                width: 960px;
                height: 230px;
            }
            
            .success-box {
                border: 2px solid #298724;
                margin: 0 auto;
                width: 960px;
                padding: 10px;
            }
            
        </style>
    </head>
    <body>
        <div>
        <c:choose>
            <c:when test="${isValidBrowser}">
                <p class="success-box">Ваш браузер <c:out value="${currentBrowser}"/> подходит для работы с системой КЕГЭ.</p>
            </c:when>
            <c:otherwise>
                <div class="error-box">
                    <p style="background-color: #CC2F2C; color: white; font-weight: bold; padding: 4px; margin-top: 0px;">ВНИМАНИЕ!!!</p>
                    <div style="padding: 10px; height: 220px;">
                        <p>Вы используете неподдерживаемую версию браузера (<c:out value="${currentBrowser}"/>).<br/>
                            Поддерживаются браузеры версий не ниже следующих:
                            <ul>
                                <c:forEach items="${validBrowsers}" var="validBrowser">
                                    <li><c:out value="${validBrowser.key.name}"/>&nbsp;<c:out value="${validBrowser.value}"/></li>
                                </c:forEach>
                            </ul>
                        </p>  
                    </div>
                </div>
            </c:otherwise>
        </c:choose>
        </div>


    </body>
</html>
