<%@page contentType="text/html" pageEncoding="UTF-8" session="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>АРМ &laquo;Участник КЕГЭ&raquo;</title>
        
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/main.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/exam/end.css' />" />
        <!--[if lt IE 9]>
            <%@ include file="/css/iebuttons.css.jspf" %>
            <%@ include file="/css/iestyles/master.css.jspf" %>
        <![endif]-->
        <style type="text/css">
            .qn {
                text-align: right;
                vertical-align: baseline;
            }
            .instruction {
                margin-top: 0px;
            }
        </style>

    </head>
    <body>

<noscript>
    <style type="text/css">
        .pagecontent {display:none;}
    </style>
    <div class="noscriptmsg">
        <%@include file="../noscript.jspf" %>
    </div>
</noscript>        
        <%@ include file="../header.jspf" %>

        <div class="pagecontent box-shadow paper-list"> 
    
        <br/>
        <table id="main-container-empty" class="pull main-container-empty" cellpadding="0" cellspacing="0" border="0">
            <c:choose>
                    <c:when test="${isTestMode}">
                        <tr>
                            <td style="text-align: center;"><%@include file="../testmodetitle.jspf" %></td>
                        </tr>
                    </c:when>
                    <c:otherwise>

                    </c:otherwise>
            </c:choose>            
            <tr>
                <td><h1 class="status-left-side">Поздравляем. Вы закончили экзамен.</h1></td>
            </tr>
        </table>
        <br/>
        <c:choose>
            <c:when test="${not pollAnswered}">        
                <table id="main-container-empty" class="pull main-container-empty" cellpadding="0" cellspacing="0" border="0">
                    <tr>
                        <td><h2>Уважаемый Участник, будем признательны, если Вы заполните 
                                приведённую ниже анкету оценки качества программного комплекса КЕГЭ.</h2></td>
                    </tr>
                </table>
                <br/>
                <form action="<c:url value='/end/poll.action' />" method="POST">
                    <table cellpadding="0" cellspacing="10" border="0" style="margin:0 auto;">
                        <tr>
                            <td class="qn" style="width:25px"><p class="normal">1.</p></td>
                            <td><p class="normal">Оцените удобство использования системы:</p></td>
                        </tr>
                        <tr>
                            <td>&nbsp;</td>
                            <td>
                                <input id="q11" type="radio" name="Usability" value="1"/>
                                <label for="q11">Использование системы максимально удобно и не требует доработки</label>
                                <br/>
                                <input id="q12" type="radio" name="Usability" value="2"/>
                                <label for="q12">Отдельные элементы системы требуют повышения удобства использования</label>
                                <br/>
                                <input id="q13" type="radio" name="Usability" value="3"/>
                                <label for="q13">Пользоваться системой неудобно, требуются значительные доработки</label>
                            </td>
                        </tr>
                        <tr>
                            <td class="qn" style="width:25px"><p class="normal">2.</p></td>
                            <td><p class="normal">Оцените простоту (понятность) использования системы:</p></td>
                        </tr>
                        <tr>
                            <td>&nbsp;</td>
                            <td>
                                <input id="q21" type="radio" name="Clarity" value="1"/>
                                <label for="q21">Система интуитивно понятна, обращение к инструкциям не требуется</label>
                                <br/>
                                <input id="q22" type="radio" name="Clarity" value="2"/>
                                <label for="q22">Отдельные функции системы не очевидны, требуется обращение к инструкциям</label>
                                <br/>
                                <input id="q23" type="radio" name="Clarity" value="3"/>
                                <label for="q23">Система достаточно сложная, требуется внимательное изучение инструкций</label>
                            </td>
                        </tr>
                        <tr>
                            <td class="qn" style="width:25px"><p class="normal">3.</p></td>
                            <td><p class="normal">Оцените качество отображения заданий КИМ:</p></td>
                        </tr>
                        <tr>
                            <td>&nbsp;</td>
                            <td>
                                <input id="q31" type="radio" name="Kim" value="1"/>
                                <label for="q31">Задания отображаются хорошо, доработок не требуется</label>
                                <br/>
                                <input id="q32" type="radio" name="Kim" value="2"/>
                                <label for="q32">Необходимо улучшить читаемость заданий КИМ</label>
                            </td>
                        </tr>
                        <tr>
                            <td class="qn" style="width:25px"><p class="normal">4.</p></td>
                            <td><p class="normal">Оцените качество инструкции по использованию системы:</p></td>
                        </tr>
                        <tr>
                            <td>&nbsp;</td>
                            <td>
                                <input id="q41" type="radio" name="Manual" value="1"/>
                                <label for="q41">Не пользовался инструкцией</label>
                                <br/>
                                <input id="q42" type="radio" name="Manual" value="2"/>
                                <label for="q42">Инструкция не требует доработки</label>
                                <br/>
                                <input id="q43" type="radio" name="Manual" value="3"/>
                                <label for="q43">Инструкция требует сокращения, необходимо оставить только ключевые моменты</label>
                                <br/>
                                <input id="q44" type="radio" name="Manual" value="4"/>
                                <label for="q44">Инструкция требует расширения, необходимо более детально описать порядок работы с системой</label>
                            </td>
                        </tr>
                        <tr>
                            <td class="qn" style="width:25px"><p class="normal">5.</p></td>
                            <td><p class="normal">Выберите разделы системы, доработка которых по Вашему 
                                    мнению наиболее критична (можно выбрать несколько ответов):</p></td>
                        </tr>
                        <tr>
                            <td>&nbsp;</td>
                            <td>
                                <input id="q51" type="checkbox" name="Subsystem" value="1"/>
                                <label for="q51">Страница проверки персональных данных</label>
                                <br/>
                                <input id="q52" type="checkbox" name="Subsystem" value="2"/>
                                <label for="q52">Раздел отображения заданий КИМ</label>
                                <br/>
                                <input id="q53" type="checkbox" name="Subsystem" value="3"/>
                                <label for="q53">Раздел ввода ответов на часть A</label>
                                <br/>
                                <input id="q54" type="checkbox" name="Subsystem" value="4"/>
                                <label for="q54">Раздел ввода ответов на часть B</label>
                                <br/>
                                <input id="q55" type="checkbox" name="Subsystem" value="5"/>
                                <label for="q55">Раздел ввода ответов на часть C</label>
                                <br/>
                                <input id="q56" type="checkbox" name="Subsystem" value="6"/>
                                <label for="q56">Страница проверки ответов</label>
                                <br/>
                                <input id="q57" type="checkbox" name="Subsystem" value="7"/>
                                <label for="q57">Страница сверки ответов с бумажным бланком</label>
                                <br/>
                                <input id="q58" type="checkbox" name="Subsystem" value="8"/>
                                <label for="q58">Форма бумажного бланка КЕГЭ</label>
                            </td>
                        </tr>
                        <tr>
                            <td class="qn">&nbsp;</td>
                            <td>
                                <input type="submit" class="button button-green" style="float: right; padding: 5px 13px;" value="Отправить" />
                            </td>
                        </tr>
                    </table>
                </form>
            </c:when>
            <c:otherwise>
                <table id="main-container-empty" class="pull main-container-empty" cellpadding="0" cellspacing="0" border="0">
                    <tr>
                        <td><h2>Спасибо за участие в анкетировании.</h2></td>
                    </tr>
                </table>
            </c:otherwise>
        </c:choose>
</div>                
    </body>
</html>
