<%@ page contentType="text/html" pageEncoding="UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>АРМ &laquo;Участник КЕГЭ&raquo;</title>

        <script type="text/javascript" src="<c:url value='/script/jquery-1.7.1.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery-ui-1.8.16.custom.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/common.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery.form.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery.sendformajax.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/modernizr-1.7.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery.cookie.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery.mousewheel.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery.mscroller.js' />"></script>
        <c:forEach var="url" items="${libraries}">
            <script src="<c:url value='/script/' />${url}" type="text/javascript"></script>
        </c:forEach>
        
        <script type="text/javascript">${markupHeader.script}</script>

        <%-- 
        Надо подумать как избежать вот такой неприятности: библиотеки, которые подключаются руками, 
        могут присутствовать и в markupHeader.libraries. Ничего страшного, конечно, когда 2 одинаковые библиотеки 
        подключаются, но все же неприятно 
        --%>
        <style type="text/css">${markupHeader.style}</style>
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/jquery-ui-1.8.16.custom.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/main.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/exam/exam.css' />" />
        <!--[if lt IE 9]>
            <%@ include file="/css/iebuttons.css.jspf" %>
            <%@ include file="/css/iestyles/master.css.jspf" %>
        <![endif]-->
       
        <script type="text/javascript">
                var task = {};
            <%-- DOM-ready --%>
                $(function() {
                    showError();
                    
                    pingServer();
                    
                    init();
                    
                    task = new Task('#stem');
                    
                    applyScrollBar();
                    
                    bindListEvents();
                    bindAnswerEvents();
                    
                    loadTasksTreeState();
                    saveTasksTreeState();
                    
                    totalRecalculate();
                    task.setMaxHeight();
                    setMaxContentHeight();
                    $(window).bind('resize', task.setMaxHeight);
                    //bindFileDrop();
                    $('#stem').mCustomScrollbar("update");
                    updateTimeLeft();

                    var fontZoomControl = new FontZoomControl('#font-zoom-control', '#stem');
                    $(fontZoomControl.buttonZoomIn).bind('click', fontZoomControl.ZoomIn);
                    $(fontZoomControl.buttonZoomOut).bind('click', fontZoomControl.ZoomOut);

                    

                    setInterval(updateTimeLeft, 60000);
                    <c:choose>
                        <c:when test="${saveTaskCSuccessfull == true}">
                            showInfoMessage('Ответ принят.');
                        </c:when>
                        <c:when test="${saveTaskCSuccessfull == false}">
                            showErrorMessage('Ошибочный идентификатор задания. Ответ не сохранен. Обратитесь к организатору в аудитории.');
                        </c:when>
                    </c:choose>
                        
                    <c:if test="${!empty saveTaskCFileId}">
                        $("#file-id").val("<c:out value="${saveTaskCFileId}" />");
                        $('select[name="encoding"]').val("<c:out value="${saveTaskCFileEncoding}" />");
                        submitFormFile(true);
                    </c:if>

                    bindTagEvent();

                });  
  
                var showError = function(){
                    <c:if test="${!empty errorMessage}">
                            showErrorMessage('<c:out value="${errorMessage}"/>');
                    </c:if>
                }
  
                function pingServer() {
                    $.post('<c:url value="/pingParticipant.action"/>');
                    setTimeout(pingServer, 3000);
                }                
            
                function init() {
                    jQuery.ajaxSetup( {async: false, cache: false} );
                }
                
                function Task(selector) {
                    
                    var firstLoad = true;
                    
                    var task = $(selector);
                    
                    var defaultMinHeight = 70;

                    var that = this;
                    
                    var getFreeHeight = function() {
                        var topAreaHeight = task.offset().top;
                        var bottomAreaHeight = $('.answer-container').outerHeight();
                        return $(window).height() - (topAreaHeight + bottomAreaHeight);
                    }
                    
                    this.taskChanged = true;
                    var defaultHeight = 0;
                    this.setMaxHeight = function() {
                        /*if(that.taskChanged) {
                            defaultHeight = task.height() + 10;
                            that.taskChanged = false;
                        } */
                        var maxHeight = getFreeHeight();
                        //var height = maxHeight > defaultHeight? defaultHeight : maxHeight;
                        task.height(maxHeight - 80);
                    }
                }
                

                
                function setMaxContentHeight() {
                    var offset = 20;
                    setMaxHeight('#left-bar', 'height', offset);
                    setMaxHeight('#right-bar', 'height', offset + 20);
                    setMaxHeight('#right-bar-table', 'height', offset + 30);
                }
                
                

                function applyScrollBar() {
                    var scrollOptions = {
                            scrollInertia:100,
                            advanced:{
                                updateOnBrowserResize:true, 
                                updateOnContentResize:true, 
                                autoExpandHorizontalScroll:false 
                              }
                    };
                    
                    var $leftbar = $('#left-bar');
                    var $stem = $('#stem');
                    var $instructionContainer = $('#instruction-container');
                    
                    
                    $leftbar.mCustomScrollbar(scrollOptions);
                    $stem.mCustomScrollbar(scrollOptions);
                    $instructionContainer.mCustomScrollbar(scrollOptions);
                    
                    $(window).resize();

                }
                
                function applyDialogScroll() {
                    var scrollOptions = {
                            scrollInertia:100,
                            advanced:{
                                updateOnBrowserResize:true, 
                                updateOnContentResize:true, 
                                autoExpandHorizontalScroll:false 
                              }
                    };
                   $('#dialog-confirm:not(.applied)').addClass('applied').mCustomScrollbar(scrollOptions);
                }
                
//                function applySourceCodeScroll() {
//                    var scrollOptions = {
//                            scrollInertia:100,
//                            advanced:{
//                                updateOnBrowserResize:true, 
//                                updateOnContentResize:true, 
//                                autoExpandHorizontalScroll:false 
//                              }
//                    };
//                    var textCode = $('.text-code');
//                    if(textCode && textCode.html() != '') {
//                        textCode.height(70);
//                        textCode.mCustomScrollbar(scrollOptions);
//                    }
//                }

                function updateTimeLeft() {
                    $.ajax({
                        url: 'exam/lefttime.json',
                        type: 'POST',
                        success: function(timeLeftInfo) {
                            if (timeLeftInfo.timeLeft <= 0){
                                allowClosePage();
                                window.location.reload(true);
                            }
                            
                            var timerContainer = $('#time-left');
                            timerContainer.attr('currenttime', timeLeftInfo.timeLeft);
                            timerContainer.text(timeLeftInfo.timeLeftString);
                
                            if(timeLeftInfo.timeLeft == 10) {
                                showInfoMessage("Внимание!!! Через 10 минут экзамен будет автоматически завершён. Если вы не внесли в систему все имеющиеся ответы - сделайте это сейчас. Рекомендуем проверить правильность всех внесенных ответов");
                            }
                        },
                        error: function () {
                            allowClosePage();
                            window.location.reload(true);
                        }
                    });
                }

                function selectFirstItem() {
                    selectItemById($('.item').first().attr('id'));
                }

                function loadExerciseQuestion(data) {
                    $("#file-changed").val('');
                    $.ajax({
                        url: 'exam/task.json',
                        type: 'GET',
                        contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
                        data: { taskId: data.id },
                        success: function(taskMarkup) {
                            <%-- Меняем заголовок задания --%>
                            $('#label-hidden').val('<h1>Задание&nbsp;' + taskMarkup.label + '</h1>');
                            <%-- Текст задания --%>
                            $('#stem-hidden').val(taskMarkup.stem);
                            
                            <%-- Хинт задания --%>
                            if (taskMarkup.hints.length > 0) {
                                var hintHtml = '';
                                $.each(taskMarkup.hints, function(index, item) {
                                    hintHtml += '<div class="text-content-normal text-hint info-box">' + item + '</div>';
                                });
                                $('#hint').html(hintHtml);
                                $('#tr-hint').show();
                            } else {
                                $('#tr-hint').hide();
                                $('#hint').html('');
                            }
                            
                            <%-- Блок ответов --%>
                            $('#reminder-hidden').val(taskMarkup.remainder);
                            <%-- Текущий ответ --%>
                            $('#answer-hidden').val(taskMarkup.answer);
                            <%-- Запоминаем часть --%>
                            $('#task-part').val(taskMarkup.part);
                            if(taskMarkup.part == 'A') {
                                $('.answer-block-title').show();
                            } else {
                                $('.answer-block-title').hide();
                            }
                            <%-- Выводим список прикреплённых файлов --%>
                            $('#attachments').html();
                            
                            if(taskMarkup.answer)
                                $('.task-title-check-icon').removeClass('hidden');
                            else 
                                $('.task-title-check-icon').removeClass('hidden').addClass('hidden');
                            <%-- Запоминаем язык программирования --%>
                            $('#file-id').val(null);
                            $('#file-changed').val(null);
                            <%-- Теперь вместо языка ответа используем язык участника (он же и будет являться языком ответа) --%>
                            $('#file-lang').val(taskMarkup.langId);
                            $('#file-lang-name').val(taskMarkup.langName);
                            $('#file-lang-ext').val(taskMarkup.fileNameExt);
                            <%-- Запоминаем кодировку --%>
                            $('#file-encoding').val(taskMarkup.answerEncoding ? taskMarkup.answerEncoding : "no");
                        },
                        error: function (jqXHR) {
                            if (jqXHR.status == 403){
                                allowClosePage();
                                window.location.reload(true);
                            } else{
                                throw 'Потеря связи с сервером при выборе задания! Повторите попытку.';
                            }
                        }
                    });
                }
            
                function tryToSaveAnswer(onSuccessSave) {
                    var answerObj = itemGetAnswer();

                    if (answerObj.form == undefined){
                        if (answerObj.value == null) {
                            showErrorMessage('Необходимо выбрать вариант ответа.');
                            return false;
                        }
                    }
                    else {
                        if (!$('#file-id').val()) {
                            showErrorMessage('Необходимо выбрать файл для загрузки.');
                            return false;
                        }

                        var lang = answerObj.language;
                        if (lang == '0') {
                            showErrorMessage('Необходимо выбрать язык программирования.');
                            return false;
                        }

                        var encoding = answerObj.encoding;
                        if (encoding == 'no') {
                            showErrorMessage('Необходимо выбрать кодировку файла.');
                            return false;
                        }

                    }

                    try {
                        var taskId = $("#accept-answer").attr('task-id');
                        saveAnswer(taskId, answerObj, false, 'Ответ принят.', onSuccessSave);
                        $('.task-title-check-icon').removeClass('hidden');
                        totalRecalculate();
                        return true;
                    }
                    catch (e) { alert(e); }
                }
            
                function saveAnswer(taskId, answerObj, isDelete, message, onSuccessSave) {
                    if (answerObj.form == undefined || isDelete){
            <%-- Сохранение ответа --%>
                        $.ajax({
                            url: 'exam/save.json',
                            type: 'POST',
                            contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
                            data: { taskId: taskId, answer: answerObj.value, description: answerObj.description },
                            success: function(response) {
                                if (!response || (response == '""' && $("#file-id").val()))
                                {
                                    if (isDelete == false){
                                        markAcceptedItem(taskId);
                                    }
                                    else {
                                        $item = $('#test-item-rem');
                                        if ($item.hasClass('program')){
                                            $('form.answer', $item).get(0).reset();
                                        }
                                        $("#file-id").val(null);
                                        $("#file-changed").val(null);
                                        if(!isDelete) {
                                            $("#file-lang").val(0);
                                        }
                                        $("#file-encoding").val('no');
                                    }
                                    $("#answer-hidden").val(answerObj.value);
                                    showInfoMessage(message, onSuccessSave);
                                }
                                else if (response != '""') {
                                    showErrorMessage(response);
                                }
                            },
                            error: function (jqXHR) {
                                if (jqXHR.status == 403 ){
                                    allowClosePage();
                                    window.location.reload(true);
                                }
                                else{
                                    throw 'Потеря связи с сервером при сохранении ответа! Ответ не сохранен. Повторите попытку.';
                                }
                            }
                        });
                    }
                    else {
                        updateTimeLeft();
                        var fileForm = $(answerObj.form);
                        if (fileForm.find("input[name='taskid']").val() == undefined){
                            fileForm.append('<input type="hidden" name="taskid" value="' + taskId + '"/>');
                        }
                        
                        var fileId = $("#file-id").val();
                        var lang = $("#file-lang").val();
                        var encoding = fileForm.find('select[name="encoding"] option:selected').val();

                        $.ajax({
                            url: 'exam/saveC.json',
                            type: 'POST',
                            contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
                            data: { taskId: taskId, fileId: fileId, language: lang, encoding: encoding },
                            success: function(response) {
                                if (response == "true" || response == true)
                                {
                                    $("#file-changed").val('');
                                    $("#file-lang").val(answerObj.language);
                                    $("#file-encoding").val(answerObj.encoding);

                                    markAcceptedItem(taskId);
                                    showInfoMessage(message, onSuccessSave);
                                }
                                else {
                                    showErrorMessage('Ошибочный идентификатор задания. Ответ не сохранен. Обратитесь к организатору в аудитории.');
                                }
                            },
                            error: function (jqXHR) {
                                if (jqXHR.status == 403 ){
                                    allowClosePage();
                                    window.location.reload(true);
                                }
                                else{
                                    throw 'Потеря связи с сервером при сохранении ответа! Ответ не сохранен. Повторите попытку.';
                                }
                            }
                        });
                    }
                }
          
                function showHistory(id) {
                    $.ajax({
                        url: 'exam/history.json',
                        type: 'GET',
                        contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
                        data: { taskId: id },
                        success: function(answers) {
                            $('#answer-history').empty();
                            $('#answer-history').html('<tr><th>Время</th><th>Ответ</th></tr>');
                            $.each(answers, function(index, value) {
                                text = '<span style="color: red">[ответ удален]</span>';
                                if(value.text)
                                {
                                    var textContainer = $('<pre class="text-code" id="textContainer"></pre>');
                                    textContainer.text(value.text);
                                    text = $('<div>').append(textContainer).html();
                                }
                                $('#answer-history').append('<tr><td class="data">' + value.createDate 
                                    + '</td><td class="value">' + text + '</td></tr>');
                            });
                        
                            $('#answer-history-container').dialog({ 
                                title: 'История изменений ответа',
                                width: 550,
                                height: 500,
                                modal: true,
                                buttons: [{
                                        'class': 'button button-light-grey',
                                        text: "Закрыть",
                                        click: function() { $(this).dialog("close"); return false; }
                                    }]
                            });
                        },
                        error: function (jqXHR) {
                            if (jqXHR.status == 403 ){
                                allowClosePage();
                                window.location.reload(true);
                            }else{
                                throw 'Потеря связи с сервером при сохранении ответа! Ответ не сохранен. Повторите попытку.';
                            }
                        }
                    });
                }
          
                function totalRecalculate() {
                    var exerciseCount = $('.item').length;
                    var acceptedCount = $('.has-answer').length;
                    var result = acceptedCount + ' из ' + exerciseCount  

                    $('#total').html(result);
                }

                function bindAnswerEvents() {

                    $(document).on('click', '#show-source', function() {
                        showDMessage('Ответ', $('.source-code').html(), 640, 470);
                        applyDialogScroll();
                        return false;
                    });
                
            <%-- Сохранение ответа --%>
                    $(document).on('click', '.accept-answer', function() {
                        tryToSaveAnswer();
                    });
                    

            <%-- Удаление ответа --%>
                    $(document).on('click', '.clear-answer', function() {
                        var taskId = $(this).attr('task-id');
                        var answerObj = {};
                         
                        try { 
                            <%-- Сохраняем значение языка программирования --%>
                            var lang = $("#file-lang").val();
                            
                            saveAnswer(taskId, answerObj, true, 'Ответ удален.'); 
                            itemResetAnswer();
                            
                            <%-- Восстанавливаем значение языка программирования --%>
                            $("select[name='language']", "form.answer").val(lang);
                            
            <%-- отмечаем, что ответ по заданию очищен --%>
                            clearAcceptedItem(taskId); 
                            totalRecalculate();
                            $('.task-title-check-icon').removeClass('hidden').addClass('hidden');
                            $('#show-source').hide();
                            //$("#file-changed").val(null);
                        }
                        catch (e) { alert(e); }
                    });

            <%-- Показываем историю --%>
                    $(document).on('click', '.history-answer', function() {
                        showHistory($(this).attr('task-id'));
                    });

                    $(document).on('click', '.right-arrow', function() {
                        nextItem($(this));
                    });

                    $(document).on('click', '.left-arrow', function() {
                        prevItem($(this));
                    });
                }
                
            <%-- Привязка событий для списка заданий --%>
                function bindListEvents() {
                    $(document).on('click', '.item', function() {
   
                        var data = {
                            id: $(this).attr('id'),
                            label: $(this).attr('label'),
                            part: $(this).attr('part')
                        };
                        var sender = this;
                        if(isAnswerChanged()){
                            
                            message = "<p> Вы изменили ответ, но не сохранили его. Сохранить изменения?</p>";
                            $(message).dialog({ 
                                title: 'Предупреждение',
                                width: 500,
                                height: 120,
                                modal: true,
                                buttons: [
                                    {
                                        text: "Да",
                                        'class': 'button button-green',
                                        click: function() {
                                            $(this).dialog("close"); 
                                            
                                            <%-- Этот код работает криво - 
                                                содержимое колбека вызывается не в нужный момент (после закрытия диалогового окна "Ответ принят"),
                                                а до открытия этого окна.
                                                Причина неизвестна.
                                            --%>
                                            tryToSaveAnswer(function() {
                                                LoadAndShowData(data, sender);
                                            });
                                        }
                                    },
                                    {
                                        text: "Нет",
                                        'class': 'button button-grey',
                                        click: function() {
                                            $(this).dialog("close"); 
                                            LoadAndShowData(data, sender);
                                        }
                                    },
                                    {
                                        text: "Отмена",
                                        'class': 'button button-grey',
                                        click: function() {
                                            $(this).dialog("close"); 
                                        }
                                    }
                                ]
                            });

                        }
                        else{
                            LoadAndShowData(data, sender);
                               var part = $(this).attr('part');
                               var source = $('.text-code:visible');
                                if(part == 'C' && source.html() && source.html().length > 0) {
                                    $('#show-source').show(); 
                                }
                                else {
                                    $('#show-source').hide();
                                }
                        }
                        //applySourceCodeScroll();
                    });
                    
                    function LoadAndShowData(data, item)
                    {
                        
                        try
                        {
            <%--  Загрузка данных --%>
                            loadExerciseQuestion(data);
            <%-- loadExerciseAnswers(data); --%>

            <%-- Отображение данных --%>
                            $('#text-container').show();
                            $('#accept-answer').attr("task-id", data.id);
                            $('.clear-answer').attr("task-id", data.id);
                            $('#history-answer').attr("task-id", data.id);
                            $('.left-arrow').attr("task-id", data.id);
                            $('.right-arrow').attr("task-id", data.id);
                        
                            var $taskContentArea = $('#stem .mCSB_container');
                        
                            $('#label').html($("#label-hidden").val());
                            //setHint();
                            $taskContentArea.html($("#stem-hidden").val());
                            setMaxContentHeight();
                            
                            $('#stem').mCustomScrollbar("update");
  
                            
                            $('#reminder').html($("#reminder-hidden").val());
                            //applySourceCodeScroll();
                            var value = $("#answer-hidden").val();
                            var descr = undefined;
                            var form = undefined;
                            var lang = $("#file-lang").val();
                            var enc = $("#file-encoding").val();
                            var answerObj = AnswerObject(value, descr, form, lang, enc);
                            if (answerObj.value.length > 0)
                            {
                                itemSetAnswer(answerObj);
                            }
                            $('form.answer').css('font-size', '0.8em');
                            itemInit(function() {
                                if ($('input.answer-file', 'form.answer').length > 0) {
                                    var isEncoding = $(this).attr('class') == 'answer-enc';
                                    <%-- Если это НЕ перекодирование уже загруженного файла - 
                                        проверяем валидность расширения --%>
                                    var fileName = $('input.answer-file', 'form.answer').val();
                                    var fileExt = fileName.split('.').pop();
                                    var permittedFileLang = $("#file-lang-name").val();
                                    var permittedFileExt = $("#file-lang-ext").val();
                                    permittedFileExtsArray = permittedFileExt.split(',');
                                    if (!isEncoding && $.inArray(fileExt, permittedFileExtsArray) < 0) {
                                        $("#wrongfileext-lang").html(permittedFileLang);
                                        $("#wrongfileext-ext").html(permittedFileExt);
                                        $('#wrongfileext').dialog({ 
                                            title: 'Внимание!!!',
                                            width: 400,
                                            height: 150,
                                            modal: true,
                                            resizable: false,
                                            buttons: [{
                                                    text: "Закрыть",
                                                    'class': "button button-grey",
                                                    click: function() {
                                                        $(this).dialog("close"); 
                                                        return false; 
                                                    }
                                                }]
                                        });
                                        $('input.answer-file', 'form.answer').val(null);

                                        return;
                                    }
    
                                    submitFormFile(isEncoding);
                                } 
                            });
                            $('.item').removeClass('selected').removeClass('hover').removeClass('unselected').addClass('unselected');
                            $(item).removeClass('unselected').addClass('selected');
                            
                            <%-- Дисаблим контрол с языками программирования, 
                                выбираем язык, привязанный к участнику --%>
                            var answerLang = $('#file-lang').val();
                            var answerLangSelect = $('select.answer-lang', 'form.answer');
                            answerLangSelect.attr("disabled", "disabled");
                            answerLangSelect.after("<input type='hidden' name='language' />");
                            answerLangSelect.val(answerLang);
                            answerLangSelect.next().val(answerLang);
                            
                            <%-- Сохраняем состояние дерева в cookie --%>
                            saveTasksTreeState();
                        }
                        catch (e)
                        {
                            alert(e);
                        }
                        
                        task.taskChanged = true;
                        task.setMaxHeight();

                        if(data.id) {
                            var $buttonTag = $('#button-tag');
                            //var isSetTagAction = $buttonTag.attr('set-tag');
                            if(taskHasTag(data.id)) {
                                setAction($buttonTag, 'remove-tag');
                            }
                            else {
                                setAction($buttonTag, 'set-tag')
                            }
                        }
                        <%-- Вызываем MathJax для формул --%>
                        MathJax.Hub.Queue(['Typeset', MathJax.Hub]); 
                    }
                
                    $(document).on('mouseover', '.unselected', function() {
                        $('.unselected').removeClass('hover');
                        $(this).addClass('hover');
                    });
                
                    $(document).on('mouseleave', '.item', function() {
                        $('.item').removeClass('hover');
                    });
                
                    $(document).on('click', '#exercise .header', function() {
                        var isMinus = $(this).hasClass('minus');
                        setPartState($(this), isMinus);
                        $(window).resize(); <%--Перерасчет высоты скроллов--%>
                        <%-- Сохраняем состояние дерева в cookie --%>
                        saveTasksTreeState();
                    });
                }
                
                function setPartState(partElement, isMinus) {
                    var part = $(partElement).attr('part');

                    if (isMinus) {
                        $(partElement).removeClass('minus').addClass('plus');
                        $('#exercise .item[part="' + part + '"]').parent().hide();
                    }
                    else {
                        $(partElement).removeClass('plus').addClass('minus');
                        $('#exercise .item[part="' + part + '"]').parent().show();
                    }
                }
                
                function submitFormFile(isEncoding, onlyPreview){
                    if (!onlyPreview) {
                        $("#file-changed").val("1");
                    }
                    
                    var fileForm = $('form.answer');
                    var encoding = fileForm.find('select[name="encoding"] option:selected').val();
                    if (encoding == 'no' && isEncoding){
                        return;
                    }
                    
                    <%-- Отправка файла после выбора --%>
                    if (!isEncoding) {
                        allowClosePage();
                        var url = "<c:url value='/exam/uploadCAnswerFile.action' />";
                        fileForm.attr('enctype', 'multipart/form-data');
                        fileForm.attr('method', 'POST');
                        fileForm.attr('action', url);
                        
                        fileForm.submit();
                    }
                    
                    <%-- Отправка файла после смены кодировки --%>
                    else {
                        <%-- Если файл существует --%>
                        var fileId = $("#file-id").val();
                        if (fileId) {
    
                            var url = "<c:url value='/exam/previewCAnswerFile.json' />";
                            $.ajax({
                                url: url,
                                data: { fileId: fileId, encoding: encoding },
                                type: 'POST',
                                dataType: 'json',
                                success: function (response) {
                                    var data = response;
                                    var value = data.fileText;
                                    var descr = undefined;
                                    var form = undefined;
                                    var lang = fileForm.find('select[name="language"] option:selected').val();
                                    var enc = data.encoding;
                                    var answerObj = AnswerObject(value, descr, form, lang, enc);
                                    itemSetAnswer(answerObj);
                                    $('#show-source').show();
                                }, 
                                error: function() {
                                    showErrorMessage("Ошибка при загрузке файла! Данные из файла не прочитаны. Повторите попытку. ");
                                }
                            });
                        }
                    }
                    task.setMaxHeight();
                    
                }
            
                function clearAcceptedItem(id) {
                    $('.item[id="' + id + '"]').removeClass('has-answer');
                    $('.text-caption .check-icon').removeClass('visible').addClass('hidden');
                }
            
                function markAcceptedItem(id) {
                    $('.item[id="' + id + '"]').removeClass('has-answer').addClass('has-answer');
                    $('.text-caption .check-icon').removeClass('hidden').addClass('visible');
                }

                function selectItemById(id) {
                    $('.item[id="' + id + '"]').click();
                }
            
                function getItemById(id) {
                    return $('.item[id="' + id + '"]');
                }

                function getItemByIndex(index) {
                    return $('.item[index="' + index + '"]').length == 0 ? null : $('.item[index="' + index + '"]');
                }

                function nextItem(element) {
                    var item = getItemById($(element).attr('task-id'));
                    var index = parseInt($(item).attr('index')) + 1;
                    var next_item = getItemByIndex(index);


                    if (next_item != null) {
                        $(next_item).click();
                    }
                }

                function prevItem(element) {
                    var item = getItemById($(element).attr('task-id'));
                    var index = parseInt($(item).attr('index')) - 1;
                    var next_item = getItemByIndex(index);

                    if (next_item != null) {
                        $(next_item).click();
                    }
                }
            
                function finish() {
                    var exerciseCount = $('.item').length;
                    var acceptedCount = $('.has-answer').length;
                
                    if (exerciseCount != acceptedCount) {
                        $('<p id="end-exam-dialog">Вы не ответили на ' + (exerciseCount - acceptedCount) + ' ' + declination('заданий', 'задание', 'задания', (exerciseCount - acceptedCount)) + ' из ' + exerciseCount + '. Вы уверены, что хотите завершить экзамен?</p>').dialog({ 
                            title: 'Предупреждение',
                            width: 500,
                            height: 200,
                            modal: true,
                            buttons: [{
                                text: "Да, завершить экзамен",
                                    'class': "button button-green dialog-button",
                                    click: function() {
                                        $(this).dialog("close"); 
                                        allowClosePage();
                                        window.location = 'protocol.html';
                                    }
                            },
                            {    text: "Продолжить экзамен",
                                    'class': "button button-grey dialog-button",
                                    click: function() {
                                    $(this).dialog("close"); 
                                    return false;
                                }
                            }]
                        });
                        
                        var buttonClose = '<div style="float: right; margin-right: 10px;" class="button button-green button-close">Продолжить экзамен</div>';
                        var buttonNext = '<div style="float: right;" class="button button-grey button-next">Да, завершить экзамен</div>';
                        
                        $('.ui-dialog-buttonset').html(buttonNext);
                        $('.ui-dialog-buttonset').append(buttonClose);

                        $('.button-close').live('click', function() {
                           $(this).parents('.ui-dialog').find('#end-exam-dialog').dialog('close');
                        });
                        
                        $('.button-next').live('click', function() {
                           $(this).parents('.ui-dialog').find('#end-exam-dialog').dialog('close');
                           allowClosePage();
                           window.location = 'protocol.html'; 
                        });
                    }
                    else {
                        allowClosePage();
                        window.location = 'protocol.html?paper=0';
                    }
                }
            
                function docGeneral()
                {
                    $('#instruction-container').dialog({ 
                        title: 'Инструкция по выполнению работы',
                        width: 800,
                        height: 500,
                        modal: true,
                        buttons: [{
                                'class': 'button button-light-grey',
                                text: "Закрыть",
                                click: function() { $(this).dialog("close"); return false; }
                            }]
                    });
                    
                    var buttonClose = '<div style="float: right;" class="button button-light-grey button-close">Закрыть</div>';
                    $('.ui-dialog-buttonset').html(buttonClose);
                    
                    $('.button-close').live('click', function() {
                       $(this).parents('.ui-dialog').find('#instruction-container').dialog('close');
                    });
                    
                }
            
                function isAnswerChanged()
                {
                    part = $("#task-part").val();
                    if(part=="A" || part == "А"){
                        oldAnswerIndex = $("#answer-hidden").val();
                        answerIndex = $("#reminder").find("input.answer:checked").val();
                        return (oldAnswerIndex && answerIndex && (oldAnswerIndex != answerIndex))
                            || (!oldAnswerIndex && answerIndex);
                    }
                    else if(part=="B" || part == "В"){
                        answerText = $("#reminder").find("input.answer").val();
                        oldAnswerText = $("#answer-hidden").val();
                        return ((oldAnswerText && answerText && (oldAnswerText != answerText)))
                            || (oldAnswerText && !answerText)
                            || (!oldAnswerText && answerText);
                    }
                    else if(part=="C" || part == "С"){
                        oldLang = $("#file-lang").val();
                        lang =  $("select[name='language']").val();
                        langChanged = ((oldLang && lang) && (oldLang != lang))
                            || (oldLang && !lang)
                            || (!oldLang && lang);
                    
                        oldEncoding = $("#file-encoding").val();
                        encoding = $("select[name='encoding']").val();
                        encodingChanged = ((oldEncoding && encoding) && (oldEncoding != encoding))
                            || (oldEncoding && !encoding)
                            || (!oldEncoding && encoding);
                    
                        fileChanged = $("#file-changed").val();
                        if(fileChanged || langChanged || encodingChanged){
                            return true;
                        }
                    }
                    return false;
                }


                function saveTasksTreeState() {
                    var state = {
                        parts: [],
                        selectedTaskId: null
                    };
                    
                    var parts = $(".header[part]", "#exercise");
                    parts.each(function() {
                        state.parts.push({
                            name: $(this).attr('part'),
                            state: $(this).hasClass('plus') ? 'plus' : 'minus'
                        });
                    });
                    
                    var selectedTask = $(".item.selected", "#exercise");
                    var selectedTaskId = selectedTask ? selectedTask.attr("id") : null;
                    state.selectedTaskId = selectedTaskId;
                    state.token = $.cookie('KEGETOKEN');
                    
                    $.cookie("kege_war_taskstreestate", JSON.stringify(state));
                }

                function loadTasksTreeState() {
                    var stateString = $.cookie("kege_war_taskstreestate");
                    
                    
                    if (!stateString) {
                        selectFirstTask();
                        return;
                    }
                    var state = JSON.parse(stateString);
                    
                    var stateTokenIsValid = $.cookie('KEGETOKEN') == state.token;
                    if(!stateTokenIsValid) {
                        selectFirstTask();
                        return; 
                    }
                    if (!state) {
                        selectFirstTask();
                        return;
                    }
                        
                    if (state.parts) {
                        for (var i = 0; i < state.parts.length; i++) {
                            var part = state.parts[i];
                            var partElement = $(".header[part=" + part.name + "]", "#exercise");
                            if (partElement) {
                                var isMinus = part.state != 'minus';
                                setPartState(partElement, isMinus);
                            }
                        }
                    }

                    var taskSelected = false;
                    if (state.selectedTaskId) {
                        var taskElement = $(".item[id='" + state.selectedTaskId + "']");
                        if (taskElement) {
                            var taskElementId = taskElement.attr('id');
                            if(taskElementId) {
                                selectItemById(taskElementId);
                                taskSelected = true;
                            }
                        }
                    }
                    
                    if (!taskSelected) {
                        selectFirstTask();
                    }
                }
                
                function selectFirstTask() {
                    selectItemById($('.item').first().attr('id'));
                }
                
                function allowClosePage(){
                    var b = $("body");
                    b.removeAttr('onbeforeunload');
                    b.removeAttr('onunload');
                }

                function FontZoomControl(controlId, targetId) {
                    var control = $(controlId);
                    var target = $(targetId);
                    var context = this;
                    var disabledButtonClass = 'zoom-button-disabled';

                    this.buttonZoomIn = control.find('.button-zoom-in');
                    this.buttonZoomOut = control.find('.button-zoom-out');

                    var currentFontSize = 0;

                    function restoreFontSize() {
                        var savedFontSize = $.cookie('fontSize');
                        if(savedFontSize) {
                            currentFontSize = $.cookie('fontSize');
                            applyFontSize();
                        }
                        else {
                            currentFontSize = getFontSize();
                        }
                    }

                    function init() {
                        restoreFontSize();
                    }

                    function getFontSize() {
                        return parseFloat(target.css('font-size'));
                    }

                    function applyFontSize() {
                        try {
                            target.css('font-size', currentFontSize + 'px');
                            $.cookie('fontSize', currentFontSize);
                        }
                        catch(e) {
                            showMessage("Ошибка", "Не удалось изменить размер шрифта");
                        }
                    }

                    function disableButton(button) {
                        button.addClass(disabledButtonClass);
                        button.disabled = true;
                    }

                    function enableButton(button) {
                        button.removeClass(disabledButtonClass);
                        button.disabled = false;
                    }

                    this.ZoomIn = function() {
                        if(currentFontSize < 60) {
                            ++currentFontSize;
                            applyFontSize();
                            if(context.buttonZoomOut.disabled && currentFontSize > 12) {
                                enableButton(context.buttonZoomOut);
                            }
                        }
                        else {
                            disableButton(context.buttonZoomIn);
                        }
                    };

                    this.ZoomOut = function() {
                        if(currentFontSize > 12) {
                            --currentFontSize;
                            applyFontSize();
                            if(context.buttonZoomIn.disabled && currentFontSize < 60) {
                                enableButton(context.buttonZoomIn);
                            }
                        }
                        else {
                            disableButton(context.buttonZoomOut);
                        }
                    };

                    init();
                }

                function taskHasTag(taskId) {
                    return !$('#' + taskId).find('.tagged-task-icon').hasClass('hidden');
                }


                function setAction(button, actionName) {
                    button.attr('data-action', actionName);
                    if(actionName == 'set-tag')
                        button.find('.button').text('Установить метку');
                    else
                        button.find('.button').text('Удалить метку');
                }

                function bindTagEvent() {
                    var $buttonTag = $('#button-tag');
                    

                    function tagTask(taskId) {
                        $('#' + taskId).find('.tagged-task-icon').removeClass('hidden').addClass('visible');
                    }

                    function removeTaskTag(taskId) {
                         $('#' + taskId).find('.tagged-task-icon').removeClass('visible').addClass('hidden');
                    }

                    $buttonTag.bind('click', function() {
                        var currentTaskId = $('.item.selected').attr('id');
                        var isSetTagAction = $buttonTag.attr('data-action') == 'set-tag';
                        if(isSetTagAction) {
                                $.ajax({
                                type: 'POST',
                                url: '<c:url value="/setTaskTag.action" />',
                                data: { taskId: currentTaskId },
                                success: function() {
                                    setAction($buttonTag, 'remove-tag');
                                    tagTask(currentTaskId);
                                },
                                error: function(e) {
                                }
                            });
                        }
                        else {
                            $.ajax({
                                type: 'POST',
                                url: '<c:url value="/removeTaskTag.action" />',
                                data: { taskId: currentTaskId },
                                success: function() {
                                    setAction($buttonTag, 'set-tag');
                                    removeTaskTag(currentTaskId);
                                },
                                error: function(e) {
                                }
                            });
                        }
                    });

                }
                
                function downloadAttachment(taskId, attachmentId) {
                    var url = '<c:url value="/attachment/"/>' 
                        + taskId + '/' + attachmentId + '.binary';
                    $('#download-frame').attr('src', url);
                }
        </script>
        <%@ include file="../checkinternet-api.jspf" %>
        <%@ include file="../checkjs-api.jspf" %>
    </head>
    <body
        onbeforeunload="return 'Сдача экзамена не закончена, Вы уверены, что хотите выйти из системы? '" 
        onunload="return 'Сдача экзамена не закончена, Вы уверены, что хотите выйти из системы?'"
        >

<noscript>
    <style type="text/css">
        .pagecontent {display:none;}
    </style>
    <div class="noscriptmsg">
        <%@include file="../noscript.jspf" %>
    </div>
</noscript>        
<div class="pagecontent"> 
    
        <%-- Служебные поля --%>

        <input id="task-id" type="hidden" />
        <input id="task-part" type="hidden" />
        <input id="task-count" type="hidden" />
        <input id="accepted-count" type="hidden" />

        <input id="label-hidden" type="hidden" />
        <input id="hint-hidden" type="hidden" />
        <input id="stem-hidden" type="hidden" />
        <input id="reminder-hidden" type="hidden" />
        <input id="answer-hidden" type="hidden" />
        
        <input id="file-id" type="hidden" />
        <input id="file-changed" type="hidden" />
        <input id="file-encoding" type="hidden" />
        <input id="file-lang" type="hidden" />
        <input id="file-lang-name" type="hidden" />
        <input id="file-lang-ext" type="hidden" />



        <%-- История изменений --%>

        <div style="display: none;">

            <div id="answer-history-container">
                <table id="answer-history" class="answer-history" cellpadding="0" cellspacing="0" border="0">
                    <tr>
                        <td class="data">&nbsp;</td>
                        <td class="value">&nbsp;</td>
                    </tr>
                </table>
            </div>
        </div>

        <%-- Верхняя строка состояния с информацией о количестве экзаменов и временем --%>

        <%-- То, что реально отображается --%>

        <div id="fixed-div">
            <table class="toppanel" cellpadding="0" cellspacing="0" border="0">
                <tr>
                    <td>
                        <c:choose>
                            <c:when test="${isTestMode}">
                                <%@include file="../testmodetitle.jspf" %>
                            </c:when>
                            <c:otherwise>
                                <div class="scopename toppanel-block-lane">
                                    <strong>ПРОВЕДЕНИЕ ЕГЭ ПО ИНФОРМАТИКЕ И ИКТ В КОМПЬЮТЕРНОЙ ФОРМЕ</strong>
                                </div>                                
                            </c:otherwise>
                        </c:choose>
                    </td>                   
                    <td class="right-cell">
                        <div title="<c:out value="${fullName}"/>" id="fullname-wrapper"><strong>ФИО:</strong> <c:out value="${fullName}"/></div>
                    </td>
                </tr>             
                <tr>
                    <td>
                        <table class="counter-wrapper">
                            <tr>
                                <td class="uppercase-label">
                                    <strong>Выполнено заданий:</strong>
                                </td>
                                <td>
                                    <span id="total"></span>
                                </td>
                                <td class="uppercase-label time-left-label-wrapper">
                                    <strong id="time-left-label">До&nbsp;конца&nbsp;экзамена осталось:</strong>
                                </td>
                                <td>
                                    <span id="time-left" currenttime="${timeLeft}"></span>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td class="right-align right-cell">
                        <a title="Краткая инструкция по работе с программным комплексом" class="normal instruction" href="<c:url value='/manual_index.htm' />#step_3" target="_blank" ></a>
                        <%--
                        <a title="Краткая инструкция по работе с программным комплексом" class="normal instruction" href="#" onclick="underConstruction();" ></a>
                        --%>
                        <div class="button button-light-grey" id="end-exam" onclick="finish()">Завершить экзамен</div>
                    </td>
                </tr>
            </table>
        </div>
        <%-- Контейнер основной части. Слева - список заданий, справа - текст задания и ответы на них --%>

        <%-- Контейнер списка заданий --%>

        <table class="main-container" cellpadding="0" cellspacing="0" border="0">
            <tr>
                <td class="left">
                    <div id="left-bar">
                            <table id="exercise" class="exercise" cellpadding="0" cellspacing="0" border="0">
                            <c:set var="lastPart" value="" scope="page" />
                            <c:set var="isSelected" value="" scope="page" />
                            <c:set var="index" value="${1}" scope="page" />
                            <c:forEach var="item" items="${tasks}">
                                <c:if test="${item.getPart() != lastPart}">
                                    <tr><td class="header minus" part="${item.getPart()}"><p><b class="minus-sign" style="width: 20px; float: right; clear: both;">&nbsp;</b><b class="plus-sign" style="width: 20px; float: right; clear: both;">&nbsp;</b>Часть&nbsp;${item.getPart()}</p></td></tr>
                                </c:if>
                                <c:if test="${!partCOnly or (partCOnly and not (item.getPart() eq 'A') and not (item.getPart() eq 'B')) }">
                                <tr>
                                    <td index="<c:out value="${index}"/>" class="${item.isHasAnswer() ? 'has-answer' : ''} item ${fn:length(lastPart) == 0 ? 'selected' : 'unselected'}" label="${item.getLabel()}" part="${item.getPart()}" id="${item.getId().toString()}">
                                        <div class="b-task-number">
                                            <table cellpadding="0" cellspacing="0" border="0" style="width: 100%;">
                                               <tr>
                                                   <td>
                                                       <div class="check-icon">&nbsp;</div>
                                                   </td>
                                                   <td class="task-label">
                                                       <p>${item.getLabel()}</p>
                                                   </td>
                                                   <td style="width:50px;">
                                                        <div class="tagged-task-icon ${item.isTagged() ? 'visible' : 'hidden'}"></div>
                                                   </td>
                                               </tr>
                                           </table>
                                        </div>
                                    </td>
                                </tr>
                                </c:if>
                                <c:set var="lastPart" value="${item.getPart()}" />
                                <c:set var="index" value="${index + 1}" />
                            </c:forEach>    
                        </table>      
                    </div>

                    <%-- Контейнер текста заданий и ответов --%>

                </td>
                <td class="right">
                    <div id="right-bar" class="box-shadow">
                        <table id="right-bar-table" style="width: 100%;">
                            <tr>
                                <td style="vertical-align: top;">
                                    <%-- Текст задания --%>
                                    <table id="text-container" class="text-container" style="display: none;" cellpadding="0" cellspacing="0" border="0">
                                        <tr id="tr-caption">
                                            <td class="text-caption">
                                                <div id="label">&nbsp;</div>
                                                <div class="task-title-check-icon hidden"></div>
                                                <ul class="nav">
                                                    <li class="normal arrow">←</li>
                                                    <li class="left-arrow" task-id="" class="normal prev">
                                                        <a class="navigation" href="#">Предыдущее</a>
                                                    </li>
                                                    <li style="color: lightgrey;">&nbsp;|&nbsp;</li>
                                                    <li class="right-arrow" task-id="" class="normal next">
                                                        <a class="navigation" href="#">Следующее</a>
                                                    </li>
                                                    <li class="normal arrow">
                                                        →
                                                    </li>
                                                </ul>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="vertical-align: middle;">
                                                <a id="task-instruction" href="#" onclick="docGeneral(); return false;">Инструкция по выполнению работы</a>
                                                <div id="font-zoom-control">
                                                    <ul title="Изменить размер шрифта в задании КИМ" class="horizontal-list">
                                                        <li title="Увеличить размер шрифта в задании КИМ" class="button-zoom-in"></li>
                                                        <li title="Уменьшить размер шрифта в задании КИМ" class="button-zoom-out"></li>
                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr id="tr-hint">
                                            <td id="hint">&nbsp;</td>
                                        </tr>
                                        <%--tr id="tr-attachments">
                                            <td id="attachments" class="text-content-normal normal content"><p>&nbsp;</p></td>
                                        </tr--%>
                                        <tr>
                                            <td>
                                                <div id="stem" class="text-content normal content" answertype="any">
                                                    <div id="testcontent">wefwefwefw</div>
                                                </div>                                                    
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <h3 class="answer-block-title">Варианты ответа:</h3>
                                </td>
                            </tr>
                            <tr>
                                <td style="vertical-align: bottom;">
                                    <%-- Ответ --%>
                                    <table class="answer-container" cellpadding="0" cellspacing="0" border="0">
                                        <%--<tr><td id="answer-help" class="answer-help">Тут будет располагаться подсказка</td></tr>--%>
                                        <tr>
                                            <td>
                                                <div id="reminder" class="answer-body">
                                                </div>
                                                <div>
                                                    <strong>
                                                        <a id="show-source" style="position: relative; top: -5px; font-size: 1.1em;" href="#">Просмотр ответа в новом окне</a>
                                                    </strong>
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="answer-footer">
                                                <ul class="nav-bottom right-align" style="position: relative; top: 10px; padding-left: 0;">
                                                    <li class="normal arrow">←</li>
                                                    <li class="left-arrow" task-id="" class="normal prev">
                                                        <a class="navigation" href="#">Предыдущее</a>
                                                    </li>
                                                    <li style="color: lightgrey;">&nbsp;|&nbsp;</li>
                                                    <li class="right-arrow" task-id="" class="normal next">
                                                        <a class="navigation" href="#">Следующее</a>
                                                    </li>
                                                    <li class="normal arrow">
                                                        →
                                                    </li>
                                                </ul>
                                                <ul class="answer-buttons nav-bottom left-align" style="padding: 0px;">
                                                    <li id="accept-answer" task-id="" class="accept-answer answer-button">
                                                        <p class="button button-green">Принять ответ</p>
                                                    </li>
                                                    <li id="clear-answer" task-id="" class="clear-answer answer-button">
                                                        <p class="button button-grey">Удалить ответ</p>
                                                    </li>
                                                    <li id="history-answer" task-id="" class="history-answer answer-button">
                                                        <p class="history-icon"></p>
                                                    </li>
                                                    <li id="button-tag" data-action="set-tag">
                                                        <p class="button button-orange">Поставить метку</p>
                                                    </li>
                                                </ul>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>

                    </div>
                </td>
            </tr>
        </table>
        
        <div style="display: none;">

            <%--Инструкция--%>
            <div id="instruction-container">
                ${markupHeader.instruction}
            </div>
            
            <%-- Диалог о неверном расширении файла ответа в части C --%>
            <div id="wrongfileext">
                Для языка программирования 
                <span id="wrongfileext-lang"></span> 
                допустимо загружать только файлы с текстами программ, имеющие расширение 
                <span id="wrongfileext-ext"></span>.
            </div>
            
        </div>
        <br /><br />
</div> 
            <iframe id="download-frame" src="" width="1" height="1" style="display: none"></iframe>
    </body>
</html>
