<%@ page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>АРМ &laquo;Участник КЕГЭ&raquo;</title>

        <script type="text/javascript" src="<c:url value='/script/jquery-1.7.1.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery-ui-1.8.16.custom.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/common.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery.form.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquote2.js' />"></script>

        <link rel="stylesheet" type="text/css" href="<c:url value='/css/jquery-ui-1.8.16.custom.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/main.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/exam/personal.css' />" />	
        
        <!--[if lt IE 9]>
            <%@ include file="/css/exam/ie-header.css.jspf" %>
            <%@ include file="/css/exam/personal.css.jspf" %>
            <%@ include file="/css/iebuttons.css.jspf" %>
        <![endif]-->

        <script type="text/javascript">

            <%-- DOM-ready --%>
                $(function() {
                    $("#personalInfoCorrect").click(function() { participantCheckboxCheckChanged(); });
                    $("#accept").click(function() { participantCheckboxCheckChanged(); });
                    $("#kimMatched").click(function() { participantCheckboxCheckChanged(); });

                    renderKimId('<c:out value="${participantCheck.kimId}"/>', '<c:out value="${participantCheck.variantCode}"/>');
                    pingServer();
                    showError();
                    validateModel();
                    listenVariantCode();
                    //highlightKimError($('#mcm'));
                });               

                function pingServer() {
                    $.post('<c:url value="/pingParticipant.action"/>');
                    setTimeout(pingServer, 3000);
                }
            
                 <%-- Подсвечивает красным текст --%>
                function highlightKimError(element) {
                    if($('.b-error-msg').text() != '') {
                        element.css('color', 'red');
                    }
                }


            <%-- Показывает в модальном окне сообщение об ошибке --%>
                function showError() {

                    var message = $('#error-message').val();

                    if (message.length != 0)
                    {
                        showErrorMessage(message);
                    }
                }

                function validateModel()
                {
                    $.each($('.etalon'), function(i, etalon){
                        //console.info(etalon);
                        validatePopupEtalon(etalon);
                        validateEtalon(etalon);
                    });
                    $('.etalon').keyup(function() {
                        validatePopupEtalon(this);
                    });


                    $.each($('.cbetalon'), function(i, etalon){
                        validatePopupCbEtalon(etalon);
                        validateCbEtalon(etalon);
                    });
                    $('.cbetalon').change(function() {
                        validatePopupCbEtalon(this);
                    });
                    
                    validateDocumentType();
                    validateSex();
                }

                function validatePopupEtalon(element){
                    var parent = $(element).parent().parent();
                    var readonlyInput =  parent.find(".readonly");
                    if (readonlyInput.val() != $(element).val()) {
                        $(element).addClass('modified');
                    }
                    else {
                        $(element).removeClass('modified'); 
                    }
                }

                function validatePopupCbEtalon(element){
                    var parent = $(element).parent().parent();
                    var readonlyInput =  parent.find(".readonly");
                    if (readonlyInput.val() != $(element).find('option:selected').text()) {
                        $(element).addClass('modified'); 
                    }
                    else {
                        $(element).removeClass('modified'); 
                    }
                }

                function validateEtalon(element){
                    var parent = $(element).parent().parent();
                    var readonlyInput =  parent.find(".readonly");
                    var readonlyPersonal = $("#"+$(element).attr('name').replace("participant","").toLowerCase()+"");
                    if (readonlyInput.val() != $(element).val()) {
                        readonlyPersonal.removeClass('readonly').addClass('modified'); 
                    }
                    else {
                        readonlyPersonal.removeClass('modified').addClass('readonly'); 
                    }
                }

                function validateCbEtalon(element){
                    var parent = $(element).parent().parent();
                    var readonlyInput =  parent.find(".readonly");
                    var readonlyPersonal = $("#"+$(element).attr('name').replace("participant","").toLowerCase()+"");
                    if (readonlyInput.val() != $(element).find('option:selected').text()) {
                        readonlyPersonal.removeClass('readonly').addClass('modified'); 
                    }
                    else {
                        readonlyPersonal.removeClass('modified').addClass('readonly'); 
                    }
                }
                
                function validateDocumentType(){
                    currentVal = '<c:out value="${participantCheck.getDocumentTypeName()}"/>';
                    etalonVal = '<c:out value="${participantCheck.getParticipantEtalon().getDocumentTypeName()}"/>';;
                    if(etalonVal != currentVal){
                        $("#documenttypename").addClass('modified');
                    }
                }
                function validateSex(){
                    currentVal = '<c:out value="${participantCheck.getSex()}"/>';
                    etalonVal = '<c:out value="${participantCheck.getParticipantEtalon().getSex()}"/>';;
                    if(etalonVal != currentVal){
                        $("#sexName").addClass('modified');
                    }
                }

            <%--Вызывает модальное окно "Изменение персональных данных"--%>
                function showEditPersonal(){
                    allowClosePage();
                    $('#editpersonal').dialog({ 
                        title: 'ИЗМЕНЕНИЕ ПЕРСОНАЛЬНЫХ ДАННЫХ',
                        width: 670,
                        minWidth: 670,
                        height: 460,
                        modal: true,
                        buttons: [{
                                text: "Отмена",
                                'class': "button button-grey",
                                click: function() {
                                    denyClosePage();
                                    $.each($('.etalon'), function(i, etalon){
                                        var parent = $(etalon).parent().parent();
                                        var readonlyInput =  parent.find(".readonly");
                                        var readonlyPersonal = $("#"+$(etalon).attr('name').replace("participant","").toLowerCase()+"");
                                        $(etalon).val(readonlyPersonal.val());
                                        if (readonlyInput.val()!=$(etalon).val())
                                        {
                                            $(etalon).addClass('modified'); 
                                        }
                                        else
                                        {
                                            $(etalon).removeClass('modified'); 
                                        }
                                    });
                                    $.each($('.cbetalon'), function(i, etalon){
                                        var parent = $(etalon).parent().parent();
                                        var readonlyInput =  parent.find(".readonly");
                                        var readonlyPersonal = $("#"+$(etalon).attr('name').replace("participant","").toLowerCase()+"");
                                        $(etalon).val(readonlyPersonal.val());
                                        if (readonlyInput.val()!=$(etalon).find('option:selected').text())
                                        {
                                            $(etalon).addClass('modified'); 
                                        }
                                        else
                                        {
                                            $(etalon).removeClass('modified'); 
                                        }
                                    });
                                    $(this).dialog("close"); 
                                    return false; 
                                }
                            },
                            {
                                text: "Сохранить",
                                'class': "button button-green",
                                click: function() {
                                    var options = {
                                        dataType: 'text',
                                        contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
                                        success: function(validation){
                                            if (validation!=""){
                                                denyClosePage();
                                                $("#edit-error").html(validation);
                                                $("#edit-error").show();
                                            }
                                            else{
                                                $("#edit-error").hide();
                                                allowClosePage();
                                                window.location = 'personal.html';                       
                                            }
                                        }
                                    };
                                    $("#editpersonal-form").ajaxSubmit(options);
                                }
                            }]
                    });
                }

                function showDeleteEditPersonal(){
                    showConfirmMessage("Вы действительно хотите удалить изменения персональных данных?", 
                    deleteEditPersonal);
                }

                function deleteEditPersonal(){
                    allowClosePage();
                    $.ajax({
                        url: 'deleteEditPersonal.json',
                        type: 'POST',
                        contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
                        data: { participantId: $("#participantId").val() },
                        success: function(response) {
                            if (response == true){
                                window.location='personal.html';
                            }
                        }
                    });
                }
                
                function startExam(){
                    allowClosePage();
                    $("#personal-form").submit();
                }
                
                function allowClosePage() {
                    var b = $("body");
                    b.removeAttr('onbeforeunload');
                    b.removeAttr('onunload');
                }
                
                function denyClosePage() {
                    var b = $("body");
                    b.attr('onbeforeunload', 'return "Сдача экзамена не закончена, Вы уверены, что хотите выйти из системы?"');
                    b.attr('onunload', 'return "Сдача экзамена не закончена, Вы уверены, что хотите выйти из системы?"');
                }

                function participantCheckboxCheckChanged() {
                    var allchecked = $("#personalInfoCorrect").is(":checked")
                            && $("#accept").is(":checked")
                            && $("#kimMatched").is(":checked");
                    
                    $.ajax({
                        url: 'checkboxeschecked.action',
                        type: 'POST',
                        data: { participantid: $("#participantId").val(), allchecked: allchecked }
                    });
                }
                function renderKimId(kim, variantCode) {
                    var content = $('#kim_id_template').jqote({
                        kimNumber: kim,
                        variantCode: variantCode
                    }, '*'); 
                    $("#kim_id_placeholder").html(content);
                }
                
                function listenVariantCode() {
                    $.ajax({
                        url: '<c:url value="getvariantcode.json"/>',
                        type: 'POST',
                        data: { participantId: $("#participantId").val() },
                        success: function(data) {
                            var kimId = '<c:out value="${participantCheck.kimId}"/>';
                            renderKimId('<c:out value="${participantCheck.kimId}"/>', data);
                            setTimeout(listenVariantCode, 3000);
                            if(kimId && data)
                                $('.info-section:hidden').show();
                        },
                        error: function() {
                            setTimeout(listenVariantCode, 3000);
                        }
                    });
                }                      
                
        </script>
        <%@ include file="../checkinternet-api.jspf" %>
        <%@ include file="../checkjs-api.jspf" %>
        
<script type="text/html" id="kim_id_template">
<![CDATA[
<td>
    <label>Номер КИМ:</label>
</td>
<td style="width: 35.5%">
    <input id="mcm" name="kim" type="text" readonly="readonly" 
           value="<*= this.kimNumber *>" />
</td>
<td>
    <span class="b-error-msg" style="color: red"><* if (this.kimNumber == '' || this.variantCode == '') { *> КИМ не распечатан. Обратитесь к организатору  <*}*></span>
</td>
]]>
</script> 

   </head>
<body 
    onbeforeunload="return 'Сдача экзамена не закончена, Вы уверены, что хотите выйти из системы? '" 
    onunload="return 'Сдача экзамена не закончена, Вы уверены, что хотите выйти из системы?'"
    >
    
<noscript>
    <style type="text/css">
        .pagecontent {display:none;}
    </style>
    <div class="noscriptmsg">
        <%@include file="../noscript.jspf" %>
    </div>
</noscript>    
<div class="pagecontent">    
    
    <%-- Скрытое служебные поля --%>

    <%-- Сообщение об ошибке --%>

    <input id="error-message" type="hidden" value="${errorMessage}" />
    
    <form id="personal-form" action="personal.html" method="post" accept-charset="UTF-8">
        <%-- Верхняя строка состояния --%>
        <div class="toppanel">
            <div class="toppanel-left-block">
                <table>
                    <tr>
                        <td>
                            <c:choose>
                                    <c:when test="${isTestMode}">
                                            <%@include file="../testmodetitle.jspf" %>
                                    </c:when>
                                    <c:otherwise>
                                        <div class="scopename toppanel-block-lane">
                                            <strong>ПРОВЕДЕНИЕ ЕГЭ ПО ИНФОРМАТИКЕ И ИКТ В КОМПЬЮТЕРНОЙ ФОРМЕ</strong>
                                        </div>
                                    </c:otherwise>
                            </c:choose>
                            
                            
                            
                        </td>
                    </tr>
                </table>
                <h1 class="page-title toppanel-block-lane">
                    ПРОВЕРКА КОРРЕКТНОСТИ ДАННЫХ РЕГИСТРАЦИИ
                </h1>
            </div>

            <table class="toppanel-right-block">
                <tr>
                    <td>
                        <a class="instruction" href="<c:url value='/manual_index.htm' />#step_2" target="_blank" title="Краткая инструкция"></a>
                        <%-- 
                        <a class="instruction" href="#" onclick="underConstruction();" title="Краткая инструкция по работе с программным комплексом"></a>
                        --%>
                    </td>
                </tr>
            </table>
        </div>

        <div id="content-wrapper">
            <div class="main-block-right">
                <div class="section-set-wrapper  box-shadow">
                     <div class="info-section">
                        <div class="triangle-left">
                            <div class="section-name">
                                <span class="uppercase">
                                    данные автоматизированного распределения
                                </span>
                            </div>
                        </div>
                        <table class="input-wrapper">
                            <tbody>
                                <tr>
                                    <td>
                                        <label>Предмет:</label> 
                                    </td>
                                    <td>
                                        <input type="text" readonly="readonly" value="${participantCheck.getSubjectName()}" />
                                    </td>
                                    <td class="td-right-align label-fixed-width">
                                        <label>Дата:</label>
                                    </td>
                                    <td class="fixed-width">
                                        <input type="text" readonly="readonly" value="${participantCheck.getExamDate()}" />
                                     </td>
                                </tr>
                                <tr>
                                    <td  style="vertical-align: top;">
                                        <label>Наименование пунка проведения ЕГЭ:</label> 
                                    </td>
                                    <td colspan="3">
                                        <textarea rows="2" style="width: 100%; padding: 4px; font-size: 1em; resize: vertical;" readonly="readonly">${participantCheck.getStationName()}</textarea>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label>Аудитория:</label>
                                    </td>
                                    <td>
                                        <input type="text" readonly="readonly" value="${participantCheck.getAuditoriumName()}" />
                                    </td>
                                    <td class="td-right-align label-fixed-width">
                                        <label>Место:</label>
                                    </td>
                                    <td class="fixed-width">
                                        <input type="text" readonly="readonly" value="${participantCheck.getSeatRow()}:${participantCheck.getSeatCol()}" />
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <hr>
                    </div>
                    <div class="info-section">
                        <div class="triangle-left">
                           <div class="section-name">
                                <span class="uppercase">
                                    персональные данные участника егэ
                                </span>
                            </div>
                        </div>
                        <table class="input-wrapper">
                            <tbody>
                                <tr>
                                    <td class="left-col">
                                        <label>Регистрационный номер:</label> 
                                    </td>
                                    <td colspan="5">
                                        <input class="full-width" id="regNum" type="text" readonly="readonly" value="${participantCheck.getRegNum()}" />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label>Фамилия:</label> 
                                    </td>
                                    <td colspan="5">
                                        <input class="full-width" id="surname" type="text" readonly="readonly" value="${participantCheck.getSurname()}" />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label>Имя:</label>
                                    </td>
                                    <td colspan="5" class="full-width">
                                       <input id="name" type="text" readonly="readonly" value="${participantCheck.getName()}" />
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label>Отчество:</label>
                                    </td>
                                    <td colspan="5">
                                        <input id="secondname" type="text" readonly="readonly" value="${participantCheck.getSecondName()}" />
                                    </td>
                                </tr>
                               <tr>
                                    <td>
                                        <label>Документ:</label>
                                    </td>
                                    <td>
                                         <input id="documentcode" type="hidden" value="${participantCheck.getDocumentTypeCode()}" />
                                         <input id="documenttypename" type="text" readonly="readonly" value="${participantCheck.getDocumentTypeName()}" /> 
                                    </td>

                                    <td class="td-right-align label-fixed-width">
                                        <label>Серия:</label>
                                    </td>
                                    <td class="fixed-width">
                                        <input id="documentseries" style="width: 65px;" type="text" readonly="readonly" value="${participantCheck.getDocumentSeries()}" />
                                    </td>
                                    <td class="td-right-align label-fixed-width">
                                        <label>Номер:</label>
                                    </td>
                                    <td class="fixed-width">
                                        <input id="documentnumber" type="text" readonly="readonly" value="${participantCheck.getDocumentNumber()}" />
                                    </td>
                                </tr> 
                                <tr>
                                    <td>
                                        <label>Код образовательного учреждения:</label>
                                    </td>
                                    <td>
                                        <input type="text" readonly="readonly" value="${participantCheck.getSchoolRegistrationCode()}" />
                                    </td>
                                    <td class="td-right-align label-fixed-width">
                                        <label>Класс:</label>
                                    </td>
                                    <td>
                                        <input class="fixed-width" type="text" readonly="readonly" value="${participantCheck.getStudyClass()}" />
                                    </td>
                                    <td class="td-right-align label-fixed-width">
                                        <label>Пол:</label>
                                    </td>
                                    <td>
                                        <input id="sex" type="hidden" value="${participantCheck.getSexShort()}" />
                                        <input id="sexName" type="text" readonly="readonly" value="${participantCheck.getSex()}" />
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div> 
                    <div class="personal-data-controls">
                        <a class="button button-green" href="javascript:showEditPersonal();" onclick="showEditPersonal();">Изменить персональные данные</a>
                        <a class="button button-red" id="delete-modified" href="#" onclick="showDeleteEditPersonal();">Удалить изменения</a>
                    </div>
                    <div style="clear: both;"></div>
                    <div class="info-section" style="padding-bottom: 10px; <c:if test='${empty participantCheck.variantCode || empty participantCheck.kimId}'>display:none;</c:if>">
                        <hr>
                        <div class="triangle-left">
                           <div class="section-name">
                                <span class="uppercase">
                                    данные о ким
                                </span>
                            </div>
                        </div>
                        <table class="input-wrapper">
                            <tbody>
                                <tr id="kim_id_placeholder" style="width: 100%">
                                </tr>
                            </tbody>
                        </table>
                    </div>    
                </div>
                <div class="section-set-wrapper  box-shadow">
                    <div class="info-section">
                        <div class="triangle-left">
                            <div class="section-name">
                                <span class="uppercase">
                                    подтверждение корректности данных
                                </span>
                            </div>
                        </div>
                        <h3 style="color: #317C02" class="section-title">Раздел заполняется участником</h3>
                        <ol class="info-box" style="list-style-type: decimal;list-style-position:inside;">
                            <li>Внимательно проверьте персональные данные и подтвердите, что они корректны, 
                                либо внесите необходимые коррекции (нажмите кнопку <strong>«Изменить персональные данные»</strong>).</li>
                            <li>Подтвердите, что вы ознакомлены с порядком проведения ЕГЭ.</li>
                            <li>Получите у организатора бумажный КИМ и проверьте, что его номер совпадает с указанным выше. 
                                Подтвердите совпадение или обратитесь к организатору.</li>
                            <li>Дождитесь, когда организатор проверит ваши данные и введет код активации экзамена.</li>
                        </ol>
                    </div>
                    <div class="info-section">
                        <table  class="personal-data-checks" style="width: 100%;">
                            <tr>
                                <td>
                                    <input type="checkbox" id="personalInfoCorrect" name="personalInfoCorrect" ${personalInfoCorrect != null ? "checked='checked'" : "" } />
                                    <label for="personalInfoCorrect">Персональные данные корректны</label>
                                </td>
                                <td>
                                    <input type="checkbox" id="accept" name="accept" ${accept != null ? "checked='checked'" : "" } />
                                <label for="accept">С порядком проведения ЕГЭ ознакомлен</label>
                                </td>
                                <td>
                                    <input type="checkbox" id="kimMatched" name="kimMatched" ${kimMatched != null ? "checked='checked'" : "" } />
                                    <label for="kimMatched">Номер КИМ совпадает с выданным</label>
                                </td>

                            </tr>
                        </table>
                    </div>
                </div>
                
                <div class="section-set-wrapper  box-shadow">
                    <div class="info-section">
                        <div class="triangle-left">
                            <div class="section-name">
                                <span class="uppercase">
                                    подтверждение личности участника егэ
                                </span>
                            </div>
                        </div>
                        
                        <h3 style="margin-bottom: 10px; color: #C36800;" class="section-title">Раздел заполняется организатором</h3>
                        <table class="input-wrapper">
                            <tbody>
                                <tr>
                                    <td>
                                        <label class="normal">Выберите организатора:</label>
                                    </td>
                                    <td colspan="2">
                                        <select id="organizator-select" name="organizator" >
                                            <option value=""></option>
                                            <c:forEach items="${organizators}" var="organizator">
                                                <option value="${organizator.workerId}">${organizator.fullName}</option>
                                            </c:forEach>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <td>&nbsp;</td>
                                    <td colspan="2">
                                        <input type="checkbox" id="correct" name="correct" ${correct != null ? "checked='checked'" : "" } />
                                        <label class="normal" for="correct">Личность участника и правильность рассадки подтверждаю</label>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label>Введите код активации экзамена</label>
                                    </td>
                                    <td>
                                        <input id="password" name="activationKey" type="password" />
                                    </td>
                                    <td>
                                        <div class="button button-green big-button" onclick="startExam();" />
                                            Начать экзамен
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
            </div>
        </div>
        </form>
        <div id="editpersonal" class="ui-dialog-corner" style="display: none;">
            <form id="editpersonal-form" action="editpersonal.json" method="post" accept-charset="UTF-8">
                <input type="hidden" id="participantId" name="participantId" value="${participantCheck.getParticipantId()}">
                <table class="part-personal-edit">
                    <tr>
                        <td colspan="3">
                            <div class="info-box" style="fonxt-size: 1em;">
                                В столбце "НОВЫЕ ДАННЫЕ" введите правильные данные и нажмите кнопку "Сохранить".
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td></td>
                        <td class="center" style="width: 50%;"><p>ТЕКУЩИЕ ДАННЫЕ:</p></td>
                        <td class="center" style="width: 50%;"><p>НОВЫЕ ДАННЫЕ:</p></td>
                    </tr>
                    <tr>

                        <td class="level1 right small"><p>Фамилия:</p></td>
                        <td class="level1"><input class="nice-text-input readonly" style="width: 96%;" type="text" readonly="readonly" value="${participantCheck.getParticipantEtalon().getSurname()}" /></td>
                        <td class="level2"><input name="participantSurname" class="nice-text-input etalon" style="width: 96%;" size="80" type="text" value="${participantCheck.getSurname()}" /></td>
                    </tr>
                    <tr>
                        <td class="level1 right small"><p>Имя:</p></td>
                        <td class="level1"><input class="nice-text-input readonly" style="width: 96%;" type="text" readonly="readonly" value="${participantCheck.getParticipantEtalon().getName()}" /></td>
                        <td class="level2"><input name="participantName" class="nice-text-input etalon" style="width: 96%;" size="80" type="text" value="${participantCheck.getName()}" /></td>
                    </tr>
                    <tr>
                        <td class="level1 right small"><p>Отчество:</p></td>
                        <td class="level1"><input class="nice-text-input  readonly" style="width: 96%;" type="text" readonly="readonly" value="${participantCheck.getParticipantEtalon().getSecondName()}" /></td>
                        <td class="level2"><input name="participantSecondName" class="nice-text-input etalon" style="width: 96%;" size="80" type="text" value="${participantCheck.getSecondName()}" /></td>
                    </tr>
                    <tr>
                        <td class="level1 right small"><p>Документ:</p></td>
                        <td class="level1"><input class="nice-text-input  readonly" style="width: 96%;" type="text" readonly="readonly" value="${participantCheck.getParticipantEtalon().getDocumentTypeName()}" /></td>
                        <td class="level2">
                            <select id="participant-document-select" name="participantDocumentCode" class="nice-text-input cbetalon" style="width: 99%;">
                                <c:forEach items="${documentTypes}" var="documentType">
                                    <option value="${documentType.key}" ${documentType.key eq participantCheck.getDocumentTypeCode() ? 'selected' : ''}>${documentType.value}</option>
                                </c:forEach>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td class="level1 right small"><p>Серия:</p></td>
                        <td class="level1"><input class="nice-text-input readonly" style="width: 96%;" type="text" readonly="readonly" value="${participantCheck.getParticipantEtalon().getDocumentSeries()}" /></td>
                        <td class="level2"><input name="participantDocumentSeries" class="nice-text-input etalon" style="width: 96%;" type="text" value="${participantCheck.getDocumentSeries()}" /></td>
                    </tr>
                    <tr>
                        <td class="level1 right small"><p>Номер:</p></td>
                        <td class="level1"><input class="nice-text-input readonly" style="width: 96%;" type="text" readonly="readonly" value="${participantCheck.getParticipantEtalon().getDocumentNumber()}" /></td>
                        <td class="level2"><input name="participantDocumentNumber" class="nice-text-input etalon" style="width: 96%;" type="text" value="${participantCheck.getDocumentNumber()}" /></td>
                    </tr>
                    <tr>
                        <td class="level1 right small"><p>Пол:</p></td>
                        <td class="level1"><input class="nice-text-input readonly" style="width: 96%;" type="text" readonly="readonly" value="${participantCheck.getParticipantEtalon().getSex()}" /></td>
                        <td class="level2">
                            <select id="participant-sex-select" name="participantSex" class="nice-text-input cbetalon" style="width: 99%;">
                                <c:forEach items="${sexs}" var="sex">
                                    <option value="${sex.key}" ${sex.key == participantCheck.getSexShort() ? 'selected' : ''}>${sex.value}</option>
                                </c:forEach>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="3" class="level1">
                            <p id="edit-error" style="display: none; color: red;"></p>
                        </td>
                    </tr>
                </table>
            </form>
                        
    </body>
    
</div>
                        
</html>
