<%@page import="ru.tssoft.kege.model.ParticipantExamStatus"%>
<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>АРМ &laquo;Участник КЕГЭ&raquo;</title>

        <script type="text/javascript" src="<c:url value='/script/jquery-1.7.1.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery-ui-1.8.16.custom.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/common.js' />"></script>

        <style type="text/css">${markupHeader.style}</style>
                <link rel="stylesheet" type="text/css" href="<c:url value='/css/jquery-ui-1.8.16.custom.css' />" />	
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/main.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/exam/protocol.css' />" />
        <!--[if lt IE 9]>
            <%@ include file="/css/iebuttons.css.jspf" %>
            <%@ include file="/css/iestyles/master.css.jspf" %>
        <![endif]-->
        <script type="text/javascript">
            
            <%-- DOM-ready --%>
            $(function() {
                init();
            <c:if test="${paper == 0}">showInstructions();</c:if>
                
            <c:if test="${!empty error}">
                $("#error-message-text").html('<c:out value="${error}" escapeXml="false"/>');
                $('#error-message-dialog').dialog({ 
                    title: 'Ошибка', 
                    width: 500,
                    height: 160,
                    modal: true,
                    resizable: false
                });
            </c:if>    
            });
                
                <%--
                // ===========================
                // Служебные функции
                // ===========================
                --%>
            
                function showInstructions() {
                    showInfoMessage(
                    'Внимательно просмотрите протокол сдачи экзамена.<br /><br /> ' +
                        'Проверьте, что ответы на задания корректны, а затем нажмите кнопку <b>"Подтверждаю, что ответы на все задания корректны"</b>.<br /><br />' +
                        'Чтобы изменить ответы на задания, нажмите кнопку <b>"Вернуться к сдаче экзамена".</b>');
                }
            
                function init()
                {
                    jQuery.ajaxSetup( {
                        async: false,
                        cache: false
                    });
                    removeRadioButtonsInAnswers();
                    
                    updateTimeLeft();
                    setInterval(updateTimeLeft, 60000);
                    
                    <%-- Обновляем статус участника (для отображения кнопки "Завершить экзамен") --%>
                    <c:if test="${(paper eq '1') && not checkBlankStatus}">
                        waitForCheckBlank();
                        setInterval(waitForCheckBlank, 3000);
                    </c:if>
                        
                    var report = new Report('#report-container');
                    report.partC.addStyle('td', {key: 'text-align', val: 'left'});
                    report.partC.addStyle('td', {key: 'vertical-align', val: 'top'});
                    report.partB.setColumnView();
                }
                
                function Report(reportSelector) {
                    var $report = $(reportSelector);
                    var firstPagePartC = $report.find('tr:contains("части C")').nextAll('tr');
                    var otherPagesPartC = firstPagePartC.parents('table:first').nextAll('table').find('tr');
                    
                    this.partC = $.merge(firstPagePartC, otherPagesPartC);
                    
                    var partBrowCount = 36;

                    this.partB = $report.find('tr:contains("части B")').nextAll('tr').slice(0, partBrowCount - 1); 

                    this.partC.addStyle = function(selector, cssStyle) {
                        $(this).each(function() {
                            if(selector)
                                var $current = $(this).find(selector);
                            else
                                var $current = $(this);
                            $current.css(cssStyle.key, cssStyle.val);
                        });  
                    }
                    
                    this.partB.setColumnView = function() {
                        $(createPartBMarkup(parseData(this))).insertBefore($(this).eq(0));
                        $(this).remove();
                    }
                    
                    function createPartBMarkup(taskData) {
                        if(taskData.length > 0) {
                            
                            var hasAnswer = function(answer) {
                                return answer != 'нет ответа';
                            }

                            var getAnswerClass = function(answer) {
                                if(hasAnswer(answer)) {
                                   return ''; 
                                }
                                return 'no-answer';
                            }

                            var markup = '<tr><td colspan="51"><table style="width: 550px; table-layout: fixed;">';
                            
                            for(var i = 0; i <= taskData.length / 2; ++i) {
                                markup += '<tr>';
                                    markup += '<td class="task-label">' + taskData[i].task +'</td>';
                                    markup += '<td class="task-answer ' + getAnswerClass(taskData[i].answer) + '">' + taskData[i].answer +'</td>';
                                    markup += '<td class="task-label">' + taskData[i + 8].task +'</td>';
                                    markup += '<td class="task-answer ' + getAnswerClass(taskData[i + 8].answer) + '">' + taskData[i + 8].answer +'</td>';
                                markup += '</tr>'
                            }
                                return markup + '</td></tr></table>';
                            }
                    }
                    
                    function parseData(rows) {
                        var data = [];
                        rows.each(function() {
                            var cells = $(this).find('td');
                            if(!isEmptyRow(this)) {
                                data.push({task: cells.eq(1).find('span').text(), answer: cells.eq(3).find('span').text()})
                            }
                        });
                        return data;
                    }

                    function isEmptyRow(row) {
                        return $(row).find('td').length < 2;    
                    }
                }
                
                function removeRadioButtonsInAnswers()
                {
                    $.each($(".control"), function(){
                        div = $(this);
                        index = div.find("input").val();
                        div.empty();
                    });
                }
            
                function paper() {
                    allowClosePage();
                    $("#paper-form").submit();
                }
            
                function end() {
                    
                    var answersValid = $("#answers-valid").is(":checked");
                    if (!answersValid) {
                        $("#error-message-text").html('Для завершения экзамена установите признак «Соответствие номера КИМ и ответов в бланке и в программном комплексе подтверждаю» и нажмите кнопку «Завершить экзамен».');
                        $('#error-message-dialog').dialog({ 
                            title: 'Завершение экзамена', 
                            width: 500,
                            height: 150,
                            modal: true,
                            resizable: false
                        });
                        return;
                    }
                    
                    var content = 
                        '<div id="dialog-confirm" class="ui-dialog-content ui-widget-content"> ' +
                        '<table><tr><td style="vertical-align: top;">' +
                        '<span class="ui-icon ui-icon-alert" style="float:left; margin:0 7px 0 0;"></span>' +
                        '</td><td>' +
                        'Вы уверены, что хотите завершить экзамен?' +
                        '</td></tr></table>' +
                        '</div>';

                    $(content).dialog({ 
                        title: "Предупреждение",
                        width: 400,
                        modal: true,
                        buttons: [
                            {
                               'class': 'button button-green',
                                text: 'Да',
                                click: function() {
                                    allowClosePage();
                    
                                    $(this).dialog('close');
                                    $("#end-form").submit();
                                }
                            },
                            {
                                'class': 'button button-grey',
                                text: 'Нет',
                                click: function() {
                                    $(this).dialog('close');
                                    return false;
                                }
                            }
                        ]
                    });
                }
                
                function updateTimeLeft() {
                    $.ajax({
                        url: 'exam/lefttime.json',
                        type: 'POST',
                        success: function(timeLeftInfo) {
                            //if (timeLeftInfo.timeLeft <= 0){
                            //    window.location.reload(true);
                            //}
                            
                            var timerContainer = $('#time-left');
                            timerContainer.attr('currenttime', timeLeftInfo.timeLeft);
                            timerContainer.text(timeLeftInfo.timeLeftString);
                
                            if(timeLeftInfo.timeLeft == 10) {
                                showInfoMessage("Внимание!!! Через 10 минут экзамен будет автоматически завершён. Если вы не внесли в систему все имеющиеся ответы - сделайте это сейчас. Рекомендуем проверить правильность всех внесенных ответов");
                            }
                        },
                        error: function () {
                            throw 'Потеря связи с сервером при сохранении ответа! Ответ не сохранен. Повторите попытку.';
                        }
                    });
                }
            
                function changePartC(){
                    allowClosePage();

                    var asBlank = $("#asBlank").val();
                    var form = $("#change-part-c-form");
                    $("[name='asblank']", form).val(asBlank);
                    form.submit();
                }
                
                function allowClosePage(){
                    var b = $("body");
                    b.removeAttr('onbeforeunload');
                    b.removeAttr('onunload');
                }
            
                function changeViewMode(asBlank) {
                    allowClosePage();

                    var form = $("#changemode-form");
                    $("[name='asblank']", form).val(asBlank);
                    form.submit();
                }
                
                function backToExam() {
                    allowClosePage();
                    $("#backexam-form").submit();
                }
            
                function waitForCheckBlank() {
                    $.ajax({
                        url: '<c:out value="examstatus.json" />',
                        type: 'POST',
                        success: function(status) {
                            var checkBlank = (status === '<%= ParticipantExamStatus.CheckBlank %>');
                            $(".end-exam").css("visibility", checkBlank ? "visible" : "hidden");
                        },
                        error: function () {
                            // Нужно ли выбрасывать исключение?
                            //throw 'Потеря связи с сервером! Обновите страницу!';
                        }
                    });
                }
            </script>
            <%@ include file="../checkinternet-api.jspf" %>
            <%@ include file="../checkjs-api.jspf" %>
        </head>

<body
    onbeforeunload="return 'Сдача экзамена не закончена, Вы уверены, что хотите выйти из системы? '" 
    onunload="return 'Сдача экзамена не закончена, Вы уверены, что хотите выйти из системы?'"
    >

<noscript>
    <style type="text/css">
        .pagecontent {display:none;}
    </style>
    <div class="noscriptmsg">
        <%@include file="../noscript.jspf" %>
    </div>
</noscript>

<div class="pagecontent">
             <input id="asBlank" type="hidden" value="<c:out value="${asBlank}"/>">
       <div id="fixed-div">
            <table class="toppanel" cellpadding="0" cellspacing="0" border="0">
                <tr>
                    <td colspan="2">
                        <table style="width: 100%;">
                            <tr>
                                <c:choose>
                                    <c:when test="${isTestMode}">
                                        <td><%@include file="../testmodetitle.jspf" %></td>
                                    </c:when>
                                    <c:otherwise>
                                        <td class="scopename" style="white-space: nowrap;">
                                            <strong>ПРОВЕДЕНИЕ ЕГЭ ПО ИНФОРМАТИКЕ И ИКТ В КОМПЬЮТЕРНОЙ ФОРМЕ</strong>
                                        </td>                                       
                                    </c:otherwise>
                                </c:choose>                                

                                <td>
                                    <div id="document-info-wrapper">
                                        <strong>ДОКУМЕНТ:</strong>
                                        <span id="document"><c:out value="${document}"></c:out></span>
                                    </div>
                                </td>
                                <td class="right-cell">
                                    <div title="<c:out value="${fio}"/>" id="fullname-wrapper"><strong>ФИО:</strong> <c:out value="${fio}"/></div>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td>
                        <table class="counter-wrapper" style="width: 100%;">
                            <tr>
                                <td class="uppercase-label time-left-label-wrapper">
                                    <strong id="time-left-label">До&nbsp;конца&nbsp;экзамена осталось:</strong>
                                </td>
                                <td>
                                    <span id="time-left" currenttime="${timeLeft}"></span>
                                </td>
                                <td class="uppercase page-title" style="white-space: nowrap; color: white; text-align: left;" colspan="2">
                                    <c:if test="${paper == 1}">
                                        сверка ответов в программном комплексе и в бланке
                                    </c:if>
                                    <c:if test="${paper == 0}">
                                        протокол сдачи экзамена
                                    </c:if>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <c:if test="${paper == 1}">
                        <td class="top c2 last-check-items">
                            <a title="Краткая инструкция по работе с программным комплексом" class="normal instruction" href="<c:url value='/manual_index.htm' />#step_6" target="_blank" ></a>
                            <div class="button button-green no-shadow" onclick="changePartC()"><strong>Изменить ответы части С</strong></div>
                        </td>
                    </c:if>
                    <c:if test="${paper == 0}">
                        <td class="right-align right-cell">
                            <div id="button-accept-answers" class="button button-green no-shadow" onclick="paper()">Подтверждаю, что все ответы верные</div>
                            <a title="Краткая инструкция по работе с программным комплексом" class="normal instruction" href="<c:url value='/manual_index.htm' />#step_5" target="_blank" ></a>
                            <%--
                            <a title="Краткая инструкция по работе с программным комплексом" class="normal instruction" href="#" onclick="underConstruction();" ></a>
                            --%>
                            <div class="button button-light-grey" id="end-exam" onclick="backToExam()">Вернуться к вводу ответов</div>
                        </td>
                    </c:if>
                </tr>
            </table>
        </div>

        <%-- Контейнер основной части --%>
        <div id="content-block">
             <table id="main-container" class="main-container" cellpadding="0" cellspacing="0" border="0">
                 <%--<tr>
                     <td class="level1 part-container"><br /></td>
                     <td class="level1 exercise-container">&nbsp;</td>
                 </tr>--%>
                     <%-- Часть --%>
                 <tr>
                     <td>
                         <c:if test="${paper == 1}">
                             <div class="answers-valid-parent box-shadow">
                                 <ol>
                                     <li>
                                         Получите у организатора в аудитории распечатанный бланк КЕГЭ.
                                     </li>
                                     <li>
                                         Сверьте ответы в программном комплексе, отображаемые на данной форме, и в бланке.
                                         <br />
                                         Можно переключить режим отображения ответов в форме бумажного бланка.
                                     </li>
                                     <li>
                                         В случае выявления расхождения обратитесь к организатору в аудитории.
                                         <br />
                                         В случае выявления ошибочно загруженных ответов на задания части C, если время экзамена еще не вышло, можно вернуться к вводу ответов и загрузить правильные тексты программ. Для возможности вернуться к вводу ответов на часть C (кнопка «Изменить ответы часть C») обратитесь к организатору в аудитории.
                                     </li>
                                     <li>
                                         В случае совпадения ответов отметьте признак «Соответствие номера КИМ и ответов в бланке и в программном комплексе подтверждаю» и нажмите кнопку «Завершить экзамен», подпишите все страницы бланка и передайте их организатору.
                                     </li>
                                 </ol>

                                 <table id="answers-valid-table">
                                     <tr>
                                         <td style="width: 1px;">
                                             <c:choose>
                                                 <c:when test="${asBlank == true}">
                                                     <div onclick="changeViewMode(false);" class="button button-grey button-nowrap">Отобразить ответы в форме протокола</div>
                                                 </c:when>
                                                 <c:otherwise>
                                                     <div onclick="changeViewMode(true);" class="button button-grey button-nowrap">Отобразить ответы в форме бланка</div>
                                                 </c:otherwise>
                                             </c:choose>
                                         </td>
                                         <td>
                                             <div class="end-exam" id="answers-valid-container"  <c:if test="${not checkBlankStatus}">style="visibility:hidden;"</c:if> >
                                                 <input id="answers-valid" type="checkbox" />
                                                 <label for="answers-valid">Соответствие номера КИМ и ответов в бланке и в программном комплексе подтверждаю</label>
                                             </div>
                                         </td>
                                         <td style="width: 1px;">
                                             <div <c:if test="${not checkBlankStatus}">style="visibility:hidden;"</c:if> onclick="end();" class="end-exam button button-green button-nowrap">Завершить экзамен</div>
                                         </td>
                                     </tr>
                                 </table>
                             </div>
                             </c:if>
                             <c:choose>
                             <c:when test="${asBlank == true}">

                                 <%-- Отображение ответов в форме бланка --%>
                                 <div id="report-container" style="margin-top: 227px;">
                                     ${protocolBlank}
                                 </div>
                             </c:when>
                             <c:otherwise>
                                 <c:if test="${protocol.size() > 0}">
                                 <div id="right-bar" class="box-shadow">

                                     <c:set var="index" value="${0}" scope="page" />
                                     <c:set var="currentType" value="" scope="page" />

                                     <table class="task-answer-container" cellspacing="0" style="800px;">
                                     <c:forEach var="item" items="${protocol}">
                                         <tr>
                                             <td class="level1 exercise-container">
                                                 <div class="exercise-container-spacer"></div>

                                                 <table class="text-container" cellpadding="0" cellspacing="0" border="0">
                                                         <tr><td class="caption-col">
                                                             <div class="task-arrow-wrapper">
                                                                 <c:if test="${item.getPart() != currentType}">
                                                                     <table class="part-arrow-container" cellpadding="0" cellspacing="0" border="0">
                                                                         <tr>
                                                                             <td>
                                                                                 <div class="task-arrow">Часть&nbsp;&laquo;<c:out value="${item.getPart()}"/>&raquo;</div>
                                                                             </td>
                                                                         </tr>
                                                                     </table>                  
                                                                 </c:if>
                                                                 <c:if test="${item.getPart() == currentType}">&nbsp;</c:if>

                                                             </div>
                                                         <h1 class="task-title <c:if test="${item.getAnswerText() != null}">check-icon</c:if>">Задание&nbsp;${item.getLabel()}</h1></td></tr>    
                                                         <tr><td class="text-col normal">${item.getStem()}</td></tr>
                                                         <c:if test="${item.getPart() == 'A' || item.getPart() == 'А'}">
                                                             <tr><td class="text-col normal">${item.getRemainder()}</td> </tr>
                                                         </c:if>
                                                 </table>
                                             </td>
                                             <td class="level1 answer-container">
                                                 <table class="text-container" cellpadding="0" cellspacing="0" border="0">
                                                     <tr><td class="caption-col"><h1>Ответ</h1></td></tr>
                                                     <tr>
                                                         <c:choose>
                                                             <c:when test="${item.getAnswerText() == null}">
                                                                 <td style="color: red; text-transform: uppercase;" class="text-col normal">Нет&nbsp;ответа</td>
                                                             </c:when>
                                                             <c:when test="${item.getAnswerText() != null && item.getAnswerIndex() != null 
                                                                             && item.getPart() != 'C' && item.getPart() != 'С'}">
                                                                     <td class="text-col normal">
                                                                         <table>
                                                                             <tr>
                                                                                 ${item.getAnswerIndex()}.
                                                                             </tr>
                                                                         </table>
                                                                     </td>
                                                             </c:when>
                                                             <c:when test="${item.getAnswerText() != null && item.getPart() != 'C' && item.getPart() != 'С'}">
                                                                 <td class="text-col normal">
                                                                     <pre class="text-code normal" >${item.getAnswerTextHtmlEscaped()}</pre>
                                                                 </td>
                                                             </c:when>
                                                             <c:when test="${item.getAnswerText() != null && (item.getPart() == 'C' || item.getPart() == 'С')}">
                                                                 <td class="text-col normal">
                                                                     Контрольная сумма: ${item.getAnswerChecksum()}
                                                                     </br>
                                                                     Язык программирования: ${item.getAnswerLangText()}
                                                                     <div class="sourcecode-container">
                                                                         <pre class="text-code normal" >${item.getAnswerTextHtmlEscaped()}</pre>
                                                                     </div>
                                                                 </td>
                                                             </c:when>
                                                         </c:choose>
                                                     </tr>
                                                 </table>
                                             </td>
                                         </tr>
                                         <c:set var="index" value="${index + 1}" />
                                         <c:set var="currentType" value="${item.getPart()}" scope="page" />
                                     </c:forEach>    
                                     </table>

                                 </div>
                             </c:if>
                             </c:otherwise>
                         </c:choose>
                         <%--<div style="color: red; font-size: 25px;">
                             <c:out value="${protocol.size()}"></c:out>
                         </div>--%>
                            <c:if test="${protocol.size() == 0}">
                                <div id="empty-block">
                                    <table id="main-container-empty" class="main-container-empty" cellpadding="0" cellspacing="0" border="0">
                                        <tr>
                                            <td><h1 class="status-left-side">Нет выполненных заданий</h1></td>
                                        </tr>
                                    </table>
                                </div>
                            </c:if>
                         </td>
                     </tr>
             </table>
         </div>                    
    <div style="display:none">
        <form id="backexam-form" action="backexam.action" method="post" accept-charset="UTF-8"></form>
        <form id="end-form" action="end.action" method="post" accept-charset="UTF-8"></form>
        <form id="paper-form" action="paper.action" method="post" accept-charset="UTF-8"></form>
        <form id="change-part-c-form" action="checkProtocol.html" method="post" accept-charset="UTF-8">
            <input name="asblank" type="hidden" />
        </form>
        <form id="changemode-form" action="checkProtocol.html" method="get" accept-charset="UTF-8">
            <input name="asblank" type="hidden" />
        </form>

        <div id="error-message-dialog" class="dialog-container">
            <p id="error-message-text"></p>
            <hr class="light-grey">
            <div id="dialog-button-close" class="button button-green button-close" onclick="$(this).parents('#error-message-dialog').dialog('close')">Закрыть</div>
        </div>
    </div>
</div>
        
    </body>
</html>
