<%@ page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>АРМ &laquo;УЧАСТНИК КЕГЭ&raquo;</title>
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/jquery-ui-1.8.16.custom.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/main.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/exam/start.css' />" />
        <script type="text/javascript" src="<c:url value='/script/jquery-1.7.1.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery-ui-1.8.16.custom.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/common.js' />"></script>
        <!--[if lt IE 9]>
            <%@ include file="/css/iebuttons.css.jspf" %>
            <%@ include file="/css/iestyles/master.css.jspf" %>
        <![endif]-->
        <script type="text/javascript">

            $(document).ready(function() {
                pingServer();
                showError();
                bindOnEnterEvents();
                //bindRegnumInputEvents();
                setRegNum();
            });
            
            function pingServer() {
                $.post('<c:url value="/pingParticipant.action"/>');
                setTimeout(pingServer, 3000);
            }
            
            function showError()
            {
                var errorMessage = '<c:out value="${errorMessage}" escapeXml="false"/>';
                if(errorMessage.length!=0)
                {
                    showErrorMessage(errorMessage);
                }
            }
            
            function submitForm(){
                <c:choose>
                    <c:when test="${isConfirm}">$("#form").attr("action", "confirm.html")</c:when>
                    <c:otherwise> $("#form").attr("action", "start.html")</c:otherwise>
                </c:choose>
                <c:if test="${not isConfirm}">
                    if ($("#regnum").val().length != 12) {
                        $('#regnum-invalid-format-container').dialog({ 
                            title: 'Вход в систему', 
                            width: 500,
                            height: 160,
                            modal: true,
                            resizable: false,
                            buttons: [
                                {
                                    'class': 'button button-light-grey dialog-button',
                                    text: "Закрыть",
                                    click: function() { 
                                        $(this).dialog("close"); return false; 
                                    }
                                }
                            ]
                        });
                        return;
                    }
                </c:if>
                $("#form").submit();
            }
            
            function bindOnEnterEvents() {
                $('#enter-button').bind('click', function() {
                    var regNum = new String();
                    $('.regnum-part').each(function() {
                        regNum += $(this).val();
                    });
                    $('#regnum').val(regNum);
                    submitForm();
                });
            }
            
            function bindRegnumInputEvents() {
                $('.regnum-part').bind('keyup', function() {
                    if($(this).val().length == 4) {
                        var next = $(this).next();
                        next.focus();
                        var range = next.createTextRange();
                        range.moveStart('character', 0);
                    }
                });
            }
            
            function setRegNum() {
                var regNum = $('#regnum').val();
                if(regNum) {
                    $('#regnum-1').val(regNum.substr(0, 4));
                    $('#regnum-2').val(regNum.substr(4, 4));
                    $('#regnum-3').val(regNum.substr(8, 4));
                }
            }
            
            var showRegnumHelp = function() {
                $('#show-regnum-help').dialog({ width: 1080, resizable: false });
            }
            
        </script>
        <%@ include file="../checkinternet-api.jspf" %>
        <%@ include file="../checkjs-api.jspf" %>
    </head>
    <body>

<noscript>
    <style type="text/css">
        .pagecontent {display:none;}
    </style>
    <div class="noscriptmsg">
        <%@include file="../noscript.jspf" %>
    </div>
</noscript>

<div class="pagecontent">
        
        <%@ include file="../header.jspf" %>
        
        <form id="form" 
              <c:choose>
                  <c:when test="${isConfirm}">action="confirm.html"</c:when>
                  <c:otherwise>action="start.html"</c:otherwise>
              </c:choose>
              method="post" 
              accept-charset="UTF-8">
            <div id="wrapper">
                <table class="start box-shadow" cellpadding="0" cellspacing="0" border="0">
                <tr>
                    <td id="header-caption" class="header outer">
                        <h1 class="status-left-side">АРМ «УЧАСТНИК КЕГЭ» Вход в систему</h1>
                        <hr class="light-grey">
                    </td>
                </tr>
                <tr>
                    <td class="first-row outer">
                        <table class="exam">
                            <tr>
                                <td class="field"><p class="normal"><strong>Предмет:</strong></p></td>
                                <td><p class="normal">Информатика и ИКТ в комп. форме</p></td>
                            </tr>
                            <tr>
                                <td class="field"><p class="normal"><strong>Дата:</strong></p></td>
                                <td><p class="normal"><c:out value="${examDate}"/></p></td>
                            </tr>
                            <tr>
                                <td class="field"><p class="normal"><strong>Аудитория:</strong></p></td>
                                <td><p class="normal"><c:out value="${auditoriumName}"/></p></td>
                            </tr>
                            <tr>
                                <td class="field"><p class="normal">Введите Ваш персональный <strong>регистрационный номер</strong>, <a class="skyblue" href="#" onclick="showRegnumHelp();">указанный на пропуске</a></p></td>
                                <td id="reg-num-cell"><p class="normal">
                                        <c:choose>
                                            <c:when test="${isConfirm}">
                                                <input id="regnum-1" type="text" readonly="readonly"/>
                                                <input id="regnum-2" type="text" readonly="readonly"/>
                                                <input id="regnum-3" type="text" readonly="readonly"/>
                                                <input id="regnum" type="hidden" readonly="readonly" value="${regNum}">
                                            </c:when>
                                            <c:otherwise>
                                                <input data-part="1" class="regnum-part" maxlength="4" type="text" name="regnum-1" id="regnum-1" />
                                                <input data-part="2" class="regnum-part" maxlength="4" type="text" name="regnum-2" id="regnum-2" />
                                                <input data-part="3" class="regnum-part" maxlength="4" type="text" name="regnum-3" id="regnum-3" />
                                                <input type="hidden" name="regnum" id="regnum" />  
                                            </c:otherwise>
                                        </c:choose>
                                      
                                    </p>
                                </td>
                            </tr>
                            
                            <c:if test="${isConfirm}">
                                <input type="hidden" name="participant" value="<c:out value="${participantId}"/>"/>
                                <tr>
                                    <td class="field"><p class="normal">Номер рабочего места:</p></td>
                                    <td><p class="normal"><c:out value="${placeNumber}"/></p></td>
                                </tr>
                                <tr>
                                    <td class="field"><p class="normal">Участник:</p></td>
                                    <td><p class="normal"><c:out value="${fio}"/></p></td>
                                </tr>
                                <tr>
                                    <td>Для продолжения экзамена организатор должен ввести код активации экзамена</td>
                                </tr>
                                    <tr>
                                    <td class="field"><p class="normal">Выберите организатора:</p></td>
                                    <td>
                                        <select id="organizator-select" name="organizator" >
                                            <option value=""></option>
                                            <c:forEach items="${organizators}" var="organizator">
                                                <option value="${organizator.workerId}">${organizator.fullName}</option>
                                            </c:forEach>
                                        </select>                                        
                                    </td>
                                </tr>
                                <tr>
                                    <td class="field"><p class="normal">Введите код активации экзамена:</p></td>
                                    <td><p class="normal"><input id="password" name="activationKey" type="password" /></p></td>
                                </tr>
                            
                            </c:if>
                                
                        </table>
                    </td>
                </tr>
                <tr>
                    <td class="auth-buttons outer">
                        <div id="enter-button" class="button button-green">Войти в систему</div>
                    </td>
                </tr>
            </table>
            </div>
        </form>
                            
        <div id="regnum-invalid-format-container" style="display: none;">
            Неверный формат регистрационного номера
        </div>
        <div id="show-regnum-help" style="display: none;"><img src="<c:url value='/images/regnum_help.png'/>"/></div>
<div>                 
    </body>
</html>
