function showMessage(title, message, width, onDialogClose)
{
    if (width == undefined) {
        width = 400;
    }
    
	
    var content = 
    '<div id="dialog-confirm" class="ui-dialog-content ui-widget-content"> ' +
    '<table><tr><td style="vertical-align: top;">' +
    '<span class="ui-icon ui-icon-alert" style="float:left; margin:0 7px 0 0;"></span>' +
    '</td><td>' +
    message +
    '</td></tr>' +
    '</table>' +
    '</div>';

    $(content).dialog({ 
        title: title,
        width: width,
        modal: true,
        buttons: [{
            text: "Закрыть",
            'class': 'button button-light-grey button-close',
            click: function() {
                //$(this).dialog("close");
                //console.info($(this));
                if (onDialogClose) {
                    //onDialogClose();
                    onDialogClose.call(this);
                }
                return false;
            }
        }]
    });
    
    var buttonClose = '<div style="float: right;" class="button button-light-grey button-close">Закрыть</div>';
    $('.ui-dialog-buttonset').html(buttonClose);
    
    $('.button-close').live('click', function() {
       $(this).parents('.ui-dialog').find('#dialog-confirm').dialog('close');
    });
}

function showDMessage(title, message, width, height, onDialogClose)
{
    if (width == undefined) {
        width = 400;
    }
    
    if (height == undefined) {
        height = 'auto';
    }
	
    var content = 
    '<div id="dialog-confirm" class="ui-dialog-content ui-widget-content"> ' +
    '<table><tr><td style="vertical-align: top;">' +
    '</td><td>' +
    message +
    '</td></tr>' +
    '</table>' +
    '</div>';

    $(content).dialog({ 
        title: title,
        width: width,
        height: height,
        modal: true,
        buttons: [{
            text: "Закрыть",
            'class': 'button button-light-grey button-close',
            click: function() {
                //$(this).dialog("close");
                //console.info($(this));
                if (onDialogClose) {
                    //onDialogClose();
                    onDialogClose.call(this);
                }
                return false;
            }
        }]
    });
    
    var buttonClose = '<div style="float: right;" class="button button-light-grey button-close">Закрыть</div>';
    $('.ui-dialog-buttonset').html(buttonClose);
    
    $('.button-close').live('click', function() {
       $(this).parents('.ui-dialog').find('#dialog-confirm').dialog('close');
    });
}

function showErrorMessage(message, onDialogClose) {
    if (message.length != 0) {
        showMessage('Предупреждение', message, null, onDialogClose);
        return true;
    }
    else {
        return false;
    }
}

function showInfoMessage(message, onDialogClose) {
    if (message.length != 0) {
        showMessage('Сообщение', message, null, onDialogClose);
        return true;
    }
    else {
        return false;
    }
}

function showConfirm(title, message, callback, width)
{
    if (width == undefined) {
        width = 400;
    }
	
    var content = 
    '<div id="dialog-confirm" class="ui-dialog-content ui-widget-content"> ' +
    '<table><tr><td style="vertical-align: top;">' +
    '<span class="ui-icon ui-icon-alert" style="float:left; margin:0 7px 0 0;"></span>' +
    '</td><td>' +
    message +
    '</td></tr></table>' +
    '</div>';

    $(content).dialog({ 
        title: title,
        width: width,
        modal: true,
        resizable: false,
        buttons: [{
            text: "Отмена",
            'class': "button button-grey",
            click: function() {
                $(this).dialog("close");
                return false;
        }
        },
        {
            text: "OK",
            'class': "button button-green",
            click: function() {
                callback();
                return false;
            }
        }
        ]
    });
}

function showConfirmMessage(message, callback){
    if (message.length != 0) {
        showConfirm('Подтверждение действия', message, callback);
        return true;
    }
    else {
        return false;
    }
}

function setMaxHeight(element, cssProperty , offset) {
    if(offset == undefined || offset == null) {
        offset = 15;
    }
    if(typeof element == 'string') {
        element = $(element);
    }
    $(window).bind('resize', function() {
        var topOffset = element.offset().top;
        var h = $(window).height() - topOffset - offset;
        //if(maxheight != undefined && maxheight > 0 && maxheight < h) 
        //    element.css('height', 'auto');
        element.height(h);
    });
    $(window).resize();
}

function declination(a, b, c, s) {
    var words = [a, b, c];
    var index = s % 100;

    if (index >=11 && index <= 14) {
        index = 0;
    }
    else {
        index = (index %= 10) < 5 ? (index > 2 ? 2 : index): 0;
    }

    return(words[index]);
}

function underConstruction() {
    var dialog = $('#under-construction-box');
    if (!dialog) {
        
    }
    $('body').append('<div id="under-construction-box" style="display: none"><div>'
            + 'Материалы в процессе разработки</div></div>');
    $('#under-construction-box').dialog({ 
        title: 'Сообщение', 
        width: 350,
        height: 150,
        modal: true,
        resizable: false
    });
} 