﻿/**
* jQuery SendFormAjax Plugin
*
* © TS Soft, 2012
* ts-soft.ru
*
* Requires: jquery.form
*/
;(function ($) {

    /* Usage:

        $(document).sendformajax({
            form: form,
            fileObjectsContainer: form,
            onSuccess: function (responseText) {
                alert(responseText);
            }
        });

        $(document).sendformajax({
            fileObjectsContainer: document,
            url: '/MyUrl',
            data: [{ name: 'mydata', value: 'myvalue'}],
            onSuccess: function (responseText) { 
                alert(responseText);
            }
        });

    */

    $.fn.sendformajax = function (options) {

        var defaultOptions = {
            form: undefined,
            fileObjectsContainer: undefined,
            data: undefined,
            url: undefined,
            onSuccess: undefined,
            onErrors: undefined
        };
        options = $.extend(true, defaultOptions, options);

        if (false){//Modernizr.draganddrop && !$.browser.msie) {
            
            var formData = new Array();
            var form = $(options.form);
            if (form && form.serializeArray) {
                formData = form.serializeArray();

                var i = 1;
                $("input[type='file']", form).each(function () {
                    for (var j = 0; j < this.files.length; j++) {
                        if (this.files[j] != undefined) {
                            var name = "";
                            if (this.files.length == 1){
                                name = "file";
                            }
                            else {
                                name = "file" + i;
                            }
                            formData[formData.length] = {name: name, value: this.files[j]};
                            i++;
                        }
                    }
                });
            }

            var fileObjectsContainer = $(options.fileObjectsContainer);
            if (fileObjectsContainer && fileObjectsContainer.getFileObjects) {
                var fileObjects = fileObjectsContainer.getFileObjects();
                if (fileObjects) {
                    for (var j = 0; j < fileObjects.length; j++) {
                        var file = fileObjects[j];
                        if (file) {
                            formData[formData.length] = {name: 'file' + i, value: file};
                            i++;
                        }
                    }
                }
            }

            if (options.data) {
                for (var j = 0; j < options.data.length; j++) {
                    formData[formData.length] = options.data[j];
                }
            }

            var settings = {
                type: 'POST',
                url: (options.url != undefined) ? options.url : $(options.form).attr("action"),
                success: options.onSuccess,
                error: function(jqXHR, textStatus, errorThrown){
                    options.onErrors(jqXHR);
                }
            };
            ajaxSend(settings, formData);
        }
        else if (options.form) {
            // TODO: add options.data to options.form
            
            var sendOptions = {
                url: (options.url != undefined) ? options.url : $(options.form).attr("action"),
                type: 'POST',
                dataType: (options.dataType != undefined) ? options.dataType : 'text',//dataType: 'json',
                success: options.onSuccess,
                error: options.onErrors
            };
            $(options.form).ajaxSubmit(sendOptions);
        }

        return this;
    
    
        function ajaxSend(settings, data) {
            var canReadFormData = !!(window.FormData);
            var canSendBinaryString = (
		        (window.XMLHttpRequest && window.XMLHttpRequest.prototype.sendAsBinary)
		        || (window.ArrayBuffer && window.BlobBuilder)
	        );
            var canSendFormData = !!(window.FormData);
            if (canSendFormData) {
                var formdata = new FormData();
                for (var i = 0; i < data.length; i++) {
                    formdata.append(data[i].name, data[i].value);
                }

                settings.processData = false;
                settings.contentType = null;
                settings.__beforeSend = settings.beforeSend;
                settings.beforeSend = function (xhr, s) {
                    s.data = formdata;
                    if (s.__beforeSend) return s.__beforeSend.call(this, xhr, s);
                }
            }
            if (canSendBinaryString) {
                settings.___beforeSend = settings.beforeSend;
                settings.beforeSend = function (xhr, s) {
                    xhr.send = xhr.sendAsBinary;
                    if (s.___beforeSend) return s.___beforeSend.call(this, xhr, s);
                }
            }
            $.ajax(settings);
        };
    };

})(jQuery);
