<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Проверка готовности аудитории к проведению экзамена</title>

        <link rel="stylesheet" type="text/css" href="<c:url value='/css/jquery-ui-1.8.16.custom.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/main.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/header.css' />" />

        <script src="<c:url value='/script/jquery-1.7.1.min.js' />" type="text/javascript"></script>
        <script src="<c:url value='/script/jquery-ui-1.8.16.custom.min.js' />" type="text/javascript"></script>
        <script src="<c:url value='/script/common.js' />" type="text/javascript"></script>        
        
       <!--[if lt IE 9]>
            <%@ include file="/css/iebuttons.css.jspf" %>
            <%@ include file="/css/ie-examheader.css.jspf" %>
            <%@ include file="/css/exam.css.jspf" %>
       <![endif]-->


        <%@ include file="../checkinternet-api.jspf" %>
        
    </head>
    <body>
        
<noscript>
    <style type="text/css">
        .pagecontent {display:none;}
    </style>
    <div class="noscriptmsg">
        <%@include file="../noscript.jspf" %>
    </div>
</noscript>        
<div class="pagecontent"> 
    
        <%@ include file="../examheader.jspf" %>
            
        <table class="mainpanel">
        <tr>
            <td class="td-content box-shadow paper-list">
                <a style="margin-bottom: 10px;" href='<c:url value="/"/>'><strong>На главную</strong></a>

                <h1 class="content-title">ЗАПУСК АРМ УЧАСТНИКОВ И ОРГАНИЗАТОРА В АУДИТОРИИ</h1>
                <div class="info-box">
                    <strong>ИНФОРМАЦИЯ</strong><br/>
                    <hr class="light-grey">
                    Перед началом экзамена в аудитории на рабочих местах участников должно быть запущено
                    необходимое количество АРМ Участника и АРМ Организатора в аудитории на рабочей 
                    станции организатора.
                    <br/><br/>
                    На рабочих станциях участника необходимо запустить браузер и выполнить вход в систему:
                    должна отобразиться страница «АРМ «УЧАСТНИК ЕГЭ» Вход в систему».
                    <br/><br/>
                    На рабочей станции организатора необходимо запустить браузер и выполнить вход в систему:
                    должна отобразиться страница «АРМ «ОРГАНИЗАТОР В АУДИТОРИИ» Вход в систему».
                </div>
                
                <c:set var="participants_action_name" value="запущены"/>
                <c:set var="organizators_action_name" value="запущена"/>
                <%@ include file="../onlineworkstations.jspf" %>
            </td>
        </tr>
        </table>
</div>           
    </body>
</html>
