<%-- Author: Andrey Posmitniy --%>

<%@page import="ru.tssoft.kege.model.examstep.ExamStepAction"%>
<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>АРМ «АДМИНИСТРАТОР ПК КЕГЭ»</title>
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/jquery-ui-1.8.16.custom.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/main.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/exam.css' />" />
        <!--[if lt IE 9]>
            <%@ include file="/css/iebuttons.css.jspf" %>
            <%@ include file="/css/ie-examheader.css.jspf" %>
            <%@ include file="/css/exam.css.jspf" %>
        <![endif]-->
        <script type="text/javascript" src="<c:url value='/script/jquery-1.7.1.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery-ui-1.8.16.custom.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/common.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery.form.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/modernizr-1.7.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery.shortcuts.min.js' />"></script>
        <script type="text/javascript">

            $(function() {
                $(window).resize();
                activateExportDb();
                checkExportResultStatus();
                
                <c:if test="${!empty audProtocolReady}">
                        downloadPrintProtocol();
                </c:if>
            });

            function activateExportDb() {
                $.Shortcuts.add({
                    type: 'down',
                    mask: 'Ctrl+Alt+E',
                    handler: function() {
                        exportDb();
                    }
                });
                $.Shortcuts.start();
            }

            var exportDb = function(){
                $.ajax({
                    async: false,
                    url: '<c:url value="exportdbwithkey.action"/>',
                    type: 'POST',
                    success: function(data){
                        showExportDbResult('Архив базы данных успешного сформирован и сохранён в папке <br/>' + data);
                    },
                    error: function(){
                        showExportDbResult('При выгрузке базы данных произошла ошибка');
                    }
                });
            }
            
            var showExportDbResult = function(message) {
                showInfoMessage(message);
            }

            function preDeleteSeating(act){
                $.ajax({
                    url: 'predeleteseating.json',
                    type: 'POST',
                    success: function(response) {
                        if (response) 
                        {
                            preDeleteSeatingPopupWindow(response, act);
                        }
                        else {
                            act();
                        }
                    },
                    error: function () {
                        throw 'Потеря связи с сервером! Повторите попытку.';
                    }
                });
                
                
            }
            
            function preDeleteSeatingPopupWindow(message, act){
                $('<p>' + message + '</p>').dialog({ 
                    title: 'Предупреждение',
                    width: 430,
                    height: 215,
                    modal: true,
                    buttons: [
                        {
                            text: "Да",
                            'class': 'button button-green',
                            click: function() {
                                $(this).dialog("close"); 
                                act();
                            }
                        },
                        {
                            text: "Отмена",
                            'class': 'button button-grey',
                            click: function() {
                                $(this).dialog("close"); 
                                return false;
                            }
                        }
                    ]
                });
            }
            
            function deleteSeating() {
                $("#deleteseatingform").submit();
            }
            
            $(window).resize(function() {
               var elem = $('.mainpanel');
               var offset = elem.offset().top;
               var tmp = $(window).height() - offset - 25;
               var h =  tmp < 500 ? 500 : tmp;
               elem.height(h);  
            });
            
            function executePrepareExamStep() {
                window.location.replace("<c:url value='/prepare/tech.html' />");
            }
            function executePrepareExamNotAvailableStep(){}
            
            function executePrintProtocolStep() {
                var form = $('#printProtocolForm');
                $("[name='additionalData']", form).val(new Date().getTime());
                form.submit();
            }

            <c:if test="${!empty audProtocolReady}">
            function downloadPrintProtocol() {
                var form = $('#downloadProtocolForm');
                $("[name='additionalData']", form).val(new Date().getTime());
                form.submit();
            }
            </c:if>
            
            function executePrintProtocolNotAvailableStep(){}
            
            function executeCheckExamStep() {
                window.location.replace("<c:url value='/aud/index.html' />");
            }
            function executeCheckExamNotAvailableStep(){}
            
            function executeKimStep() {
                <c:choose>
                    <c:when test="${kimAlreadyImported}">
                        $('#kim-already-imported-container').dialog({ 
                            title: 'Администратор ПК КЕГЭ', 
                            width: 500,
                            height: 190,
                            modal: true,
                            resizable: false,
                            buttons: [
                                {
                                    text: "Да",
                                    click: function() { 
                                        $(this).dialog("close");
                                        $.ajax({
                                            url: "<c:url value='/kim/clearkims.action' />",
                                            type: "POST"
                                        });
                                        window.location.replace("<c:url value='/kim/choosekim.html' />");
                                        return false; 
                                    }
                                },
                                {
                                    text: "Нет",
                                    click: function() { 
                                        $(this).dialog("close"); return false; 
                                    }
                                }
                            ]
                        });                         
                    </c:when>
                    <c:otherwise>
                        window.location.replace("<c:url value='/kimmaster/choosekim.html' />");
                    </c:otherwise>
                </c:choose>            
                
            }
            function executeKimNotAvailableStep(){}
            
            function executeExportResultsStep() {
                 window.location.replace("<c:url value='/export/index.html' />");
            }
            function executeExportResultsNotAvailableStep() {
                 window.location.replace("<c:url value='/export/index.html' />");
            }

            $(document).ready(function () {
                <c:if test="${kimImportComplete}">
                    $('#kim-import-complete-container').dialog({ 
                        title: 'Администратор ПК КЕГЭ', 
                        width: 500,
                        height: 160,
                        modal: true,
                        resizable: false,
                        buttons: [
                            {
                                text: "Закрыть",
                                click: function() { 
                                    $(this).dialog("close"); 
                                    window.location = '<c:url value="/"/>';
                                    return false; 
                                }
                            }
                        ]
                    });                         
                </c:if>                
            });
            
            var checkExportResultStatus = function() {
                $.ajax({
                    type: 'post',
                    url: '<c:url value="getExportStatus.action"/>',
                    success: function (data) {
                        var exportState = $('#examstate-' + data.stepType);
                        if (exportState) {
                            exportState.removeClass();
                            exportState.addClass('state');
                            exportState.addClass(data.stateClass);
                            exportState.addClass(data.actionClass);
                            exportState.html(data.stateString);
                        }
                        var exportButton = $('#examstep-' + data.stepType);
                        if(exportButton) {
                            exportButton.removeClass();
                            exportButton.addClass('button');
                            exportButton.addClass('btn-action');
                            exportButton.unbind('click');
                            if(data.action !== '<%= ExamStepAction.NotAvailable%>') {
                                exportButton.addClass('button-green');
                                exportButton.bind('click', data.clientActionName);
                            } else {
                                exportButton.addClass('button-grey');
                                exportButton.bind('click', data.clientActionNotAvailableName);
                            }
                            exportButton.html(data.actionString);
                        }
                        setTimeout(checkExportResultStatus, 3000);
                    },
                    error: function () {
                        setTimeout(checkExportResultStatus, 3000);
                    }
                });
            }
            
        </script>
        <%@ include file="../checkinternet-api.jspf" %>
    </head>
    <body>

<noscript>
    <style type="text/css">
        .pagecontent {display:none;}
    </style>
    <div class="noscriptmsg">
        <%@include file="../noscript.jspf" %>
    </div>
</noscript>        
<div class="pagecontent"> 
    
        <%@ include file="../examheader.jspf" %>

        <table class="mainpanel">
        <tr>
            <td class="td-content box-shadow paper-list">
                <table id="steps-table"  cellpadding="0" cellspacing="0">
                <tr class="steps-header">
                    <td colspan="2">ДЕЙСТВИЯ</td>
                    <td class="steps-header-state">СТАТУС</td>
                    <td class="steps-header-buttons"></td>
                </tr>
                
                <c:set var="i" value="1" />
                <c:forEach items="${examSteps}" var="step">
                    <tr class="steps-row">
                        <td colspan="2">
                            <c:out value="${i}" />.&nbsp;
                            <c:out value="${step.name}" />
                        </td>
                        <td id="examstate-<c:out value='${step.stepType}' />" class="state <c:out value="${step.stateClass}" /> <c:out value="${step.actionClass}" />">
                            <c:out value="${step.stateString}" />
                        </td>
                        <td>
                            <div id="examstep-<c:out value='${step.stepType}' />" class="button btn-action <c:choose><c:when test="${step.action ne 'NotAvailable'}">button-green</c:when><c:otherwise>button-grey</c:otherwise></c:choose>"
                                <c:choose>
                                    <c:when test="${step.action eq 'NotAvailable'}">onclick="<c:out value="${step.clientActionNotAvailableName}" />"</c:when>
                                    <c:otherwise>onclick="<c:out value="${step.clientActionName}" />"</c:otherwise>
                                </c:choose>
                            >
                                <c:out value="${step.actionString}" />
                            </div>
                        </td>
                    </tr>
                    <c:set var="i" value="${i + 1}" />
                </c:forEach>
                    <tr>
                        <td colspan="4">
                            <a id="delete-seating" href="#" onclick="preDeleteSeating(deleteSeating); return false;">Удалить данные рассадки</a>
                        </td>
                    </tr>
                <tr class="steps-header">
                    <td colspan="4">ОРГАНИЗАТОРЫ В АУДИТОРИИ</td>
                </tr>
                <tr class="steps-subheader">
                    <td>ФИО организатора</td>
                    <td style="width: 100px;">Пароль</td>
                    <td>Код активации экзамена</td>
                    <td>Действия</td>
                </tr>
                <c:forEach var="worker" items="${workers}">
                    <tr class="steps-worker">
                        <td>
                            <c:choose>
                                <c:when test="${!empty worker.fullName}">${worker.fullName}</c:when>
                                <c:otherwise>&nbsp;&mdash;</c:otherwise>
                            </c:choose>
                        </td>
                        <td>
                            <c:choose>
                                <c:when test="${!empty worker.password}">${worker.password}</c:when>
                                <c:otherwise>&mdash;</c:otherwise>
                            </c:choose>
                        </td>
                        <td>
                            <c:choose>
                                <c:when test="${!empty worker.activationKey}">${worker.activationKey}</c:when>
                                <c:otherwise>&mdash;</c:otherwise>
                            </c:choose>
                        </td>
                        <td>
                            <form action="changepassword.action" method="POST">
                                <a href="#" onclick="$(this).parent().submit(); return false;"><c:choose><c:when test="${!empty worker.password && !empty worker.activationKey}">Изменить пароль и код</c:when><c:otherwise>Задать пароль и код</c:otherwise></c:choose></a>
                                <input type="hidden" name="workerId" value="${worker.workerId}">
                            </form>
                        </td>
                    </tr>
                </c:forEach>

                </table>
            </td>
        </tr>
	</table>        
         
        <form style="display:none;" id="deleteseatingform" action="deleteseating.action" method="POST">
        </form>
        <form style="display:none;" id="printProtocolForm" 
              action='<c:url value="/aud/protocol.action"/>' method="GET">
            <%--Поле additionalData служит только для того, изменять URL запроса 
                для предотвращение того, что браузер возьмёт документ из кеша.
                Поэтому в него при каждом запросе надо писать новое значение--%>
            <input name="additionalData" type ="hidden" />
        </form>
        <form style="display:none;" id="downloadProtocolForm" 
              action='<c:url value="/aud/downloadProtocol.action"/>' method="POST">
            <%--Поле additionalData служит только для того, изменять URL запроса 
                для предотвращение того, что браузер возьмёт документ из кеша.
                Поэтому в него при каждом запросе надо писать новое значение--%>
            <input name="additionalData" type ="hidden" />
        </form>
                
        <div id="kim-already-imported-container" style="display: none">
            ВНИМАНИЕ!!!<br/>
            В систему уже загружены электронные КИМ по экзамену, проходящему <c:out value="${examHeader.examDate}" />.<br/> 
            В случае продолжения существующие данные будет удалены.<br/>
            <br/>
            Продолжить?
        </div>                
                
        <div id="kim-import-complete-container" style="display: none">
            Импорт и расшифровка электронных КИМ в аудитории "<c:out value="${examHeader.auditorium}" />" для проведения экзамена по Информатике и ИКТ
            в компьютерной форме <c:out value="${examHeader.examDate}" /> успешно завершены.
        </div>                
</div>
        
    </body>
</html>
