<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<!DOCTYPE html>
<c:set var="filenamePattern" scope="page">
<c:out value="${currentRegion}" />00_PUBLICKEY_Results_KEGE_SubjectCode_<c:out value="${currentSubjectCode}" />_KeyDate_<дата выпуска ключа>.pfx
</c:set>   
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Экспорт результатов экзамена</title>
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/jquery-ui-1.8.16.custom.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/main.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/header.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/export.css' />" />

       <!--[if lt IE 9]>
            <%@ include file="/css/iebuttons.css.jspf" %>
            <%@ include file="/css/ie-examheader.css.jspf" %>
            <%@ include file="/css/exam.css.jspf" %>
       <![endif]-->
        <script src="<c:url value='/script/jquery-1.7.1.min.js' />" type="text/javascript"></script>
        <script src="<c:url value='/script/jquery-ui-1.8.16.custom.min.js' />" type="text/javascript"></script>
        <script src="<c:url value='/script/common.js' />" type="text/javascript"></script>
        <script type="text/javascript">

            $(document).ready(function () {
                init();
                pluralizeUncompletedExams();
                bindExportEvents();
            });
            
            function init()
            {
                jQuery.ajaxSetup( {async: false, cache: false} );
            }
            
            function bindExportEvents() {
                $('#btn_export').bind('click', validateKeyFileField);
                $('#keyfile').bind('change', validateKeyFileField);
            }
            
            function validateKeyFileField() {
                if(keyFileIsEmpty())
                      showFileNotFoundError();
                  else
                      hideFileNotFoundError();
            }
            
            function keyFileIsEmpty() {
                return $('#keyfile').val() == '' && $('#key-file-name').val() == '';
            }
            
            function showFileNotFoundError() {
                 $('#file-not-found-error').show();
            }
            
            function hideFileNotFoundError() {
                $('#file-not-found-error').hide();
            }

            function startExport() {
                $("#btn_export").removeClass("button-green");
                $("#btn_export").addClass("button-grey");
                $("#export_file_name").html('');
            }
            
            function stopExport() {
                $("#btn_export").removeClass("button-grey");
                $("#btn_export").addClass("button-green");
            }
            
            function doExport() {
                if(!keyFileIsEmpty()) {
                    startExport();
                    $("#progress_info").show();
                    var exportAll = false;
                    var allowExportAll = $('#allowInvalidExport');
                    if(allowExportAll) {
                        exportAll = allowExportAll.is(':checked');
                    }
                    <c:if test="${!empty keyFileName}">
                        $.ajax({
                            url: "<c:url value='/export/export.action' />",
                            data: {exportAll: exportAll},
                            success:  function(data) {
                                $("#progress_info").hide();
                                stopExport();
                                $("#export_file_name").html(data);
                                $('#export-success-container').dialog({ 
                                    title: 'Экспорт', 
                                    width: 500,
                                    height: 160,
                                    modal: true,
                                    resizable: false,
                                    buttons: [
                                        {
                                            text: "Закрыть",
                                            'class': 'button button-grey',
                                            click: function() { $(this).dialog("close"); return false; }
                                        }
                                    ]
                                }); 
                                //showInfoMessage('Экспорт успешно завершен');
                            },
                            error: function(jqXHR, textStatus, errorThrown) {
                                $("#progress_info").hide();
                                stopExport();

                                $('#export-error-message').html(jqXHR.responseText);
                                //var errorMsg = 'Не удалось сформировать файл экспорта. ' + jqXHR.responseText;
                                //showErrorMessage(errorMsg);
                                $('#export-error-container').dialog({ 
                                    title: 'Экспорт', 
                                    width: 500,
                                    height: 260,
                                    modal: true,
                                    resizable: false,
                                    buttons: [
                                        {
                                            text: "Закрыть",
                                            click: function() { $(this).dialog("close"); return false; }
                                        }
                                    ]
                                });
                            }
                        });
                    </c:if>
                }
            }
            
            function pluralizeUncompletedExams(){
                var examsAmount = <c:out value="${uncompletedExams}"/>;
                var lastDigit = examsAmount % 10;
                var last2Digits = examsAmount % 100;
                if (lastDigit == 1) {
                    if (last2Digits != 11) {
                        $("#exams_amount").html('<c:out value="${uncompletedExams}"/> незаконченный экзамен');
                        return;
                    }
                } else if (2 <= lastDigit && lastDigit <= 4) {
                    if (last2Digits < 10 || last2Digits > 20) {
                        $("#exams_amount").html('<c:out value="${uncompletedExams}"/> незаконченных экзамена');
                        return;
                    }
                }            
                $("#exams_amount").html('<c:out value="${uncompletedExams}"/> незаконченных экзаменов');
            }
            
            function checkAllowInvalidExport(){
                var checked = $('#allowInvalidExport').is(':checked');
                if (checked && <c:out value="${!empty keyFileName}" />) {
                    $('#btn_export').removeClass('button-grey');
                    $('#btn_export').addClass('button-green');
                    $('#btn_export').bind('click', doExport);
                }  else {
                    $('#btn_export').addClass('button-grey');
                    $('#btn_export').removeClass('button-green');  
                    $('#btn_export').unbind('click');
                }
                
            }
            
            function validateSelectedFile(){
                var filename = $('#keyfile').val();
                var regex = new RegExp("<c:out value="${currentRegion}" default="0"/>00_PUBLICKEY_Results_KEGE_SubjectCode_<c:out value="${currentSubjectCode}" default="0"/>_KeyDate_[0-9|\.]+\.pfx", "i");
                var matches = regex.exec(filename);
                if (matches == null){
                    $('#keyfile').val('');
                    $('#invalid_filename_format_container').dialog({ 
                        title: 'Импорт КИМ', 
                        width: 600,
                        height: 200,
                        modal: true,
                        resizable: false,
                        buttons: [
                            {
                                'class': 'button button-light-grey dialog-button',
                                text: "Закрыть",
                                click: function() { $(this).dialog("close"); return false; }
                            }
                        ]
                    });                   
                } else {
                    $('#choosekeyform').submit();
                }
            }
</script>
        <%@ include file="../checkinternet-api.jspf" %>
    </head>
    <body>

<noscript>
    <style type="text/css">
        .pagecontent {display:none;}
    </style>
    <div class="noscriptmsg">
        <%@include file="../noscript.jspf" %>
    </div>
</noscript>        
<div class="pagecontent">         
        
        <%@ include file="../examheader.jspf" %>
        <input id="key-file-name" type="hidden" value="${keyFileName}">
        <table class="mainpanel">
        <tr>
            <td class="td-content box-shadow paper-list">
                <a style="margin-bottom: 10px;" href='<c:url value="/"/>'><strong>На главную</strong></a>
                <h1 class="content-title">ЭКСПОРТ РЕЗУЛЬТАТОВ ЕГЭ</h1>
                <div class="info-box">
                    <strong>ИНФОРМАЦИЯ</strong><br/>
                    <hr class="light-grey">
                    <p>Экспорт выполняется после того, как все участники завершат сдачу экзамена: все экзамены должны находиться в статусах «неявка» и «бланки сданы».</p>
                    <p>Перед экспортом результатов необходимо выбрать файл-ключ шифрования результатов КЕГЭ, полученный от РЦОИ или Уполномоченного ГЭК.</p>
                    <p>Название файла-ключа шифрования результатов КЕГЭ имеет формат:</p>
                    <p><c:out value="${filenamePattern}" /></p>
                    <p>После нажатия на кнопку «Выполнить экспорт» будет сформирован файл с результатами проведения экзамена в аудитории.</p>
                    <p>Файл необходимо записать на внешний носитель и передать Уполномоченному ГЭК.</p>
                </div>

                <table class="choosefile">
                    <tr>
                        <td class="sub-header">
                            <strong>Выберите файл-ключ шифрования результатов КЕГЭ:&nbsp;</strong>
                        </td>
                        <td>
                            <form id="choosekeyform" action="index.html" method="POST" accept-charset="UTF-8" enctype="multipart/form-data">
                                <input id="keyfile" name="attachment1" type="file" onchange="validateSelectedFile();">
                            </form>
                        </td>
                    </tr>
                    <c:if test="${!empty keyFileName}">
                    <tr>
                        <td>&nbsp;</td>
                        <td>
                            <div><c:out value="${keyFileName}" /></div>
                        </td>
                    </tr>
                    </c:if>
                </table>
                <div id="file-not-found-error" style="color: red; padding-bottom: 7px; display: none;">Файл-ключ шифрования не загружен! Загрузите файл и повторите попытку.</div>
                <c:if test="${uncompletedExams gt 0}">
                    <div style="color: red; margin-bottom: 5px">ВНИМАНИЕ!!! Экспорт результатов невозможен, в аудитории <strong id="exams_amount" style="text-decoration: underline;"><c:out value="${uncompletedExams}"/> незаконченных экзаменов</strong>. Обратитесь к организатору в аудитории.</div>
                    
                    <table>
                        <tr>
                            <td style="width: 55%">
                                Если экзамены в аудитории не могут быть закончены по техническим причинам,<br/>
                                отметьте признак справа и выполните экспорт имеющихся результатов
                            </td>
                            <td style="width: 1px"><input type="checkbox" id="allowInvalidExport" name="allowInvalidExport" onclick="checkAllowInvalidExport()"/></td>
                            <td>&nbsp;</td>
                            <td style="width: 45%">
                                <label for="allowInvalidExport" style="font-size: 11px">
                                    Не все экзамены могут быть<br/>
                                    завершены из-за технических сбоев
                                </label>
                            </td>
                        </tr>
                    </table>
                </c:if>
                <table cellspacing="12" style="width: 100%;">
                    <tr>
                        <td style="width: 10%; text-align: right;">Папка экспорта:</td>
                        <td><span  style="width: 800px;"><c:out value="${exportFolder}"/></span></td>
                    </tr>
                    <tr>
                        <td style="width: 10%; text-align: right;">Файл экспорта:</td>
                        <td>
                            <div id="progress_info" style="display: none; color: #636363;">идет формирование файла экспорта…&nbsp;<img src="<c:url value="/images/progress.gif"/>"/></div>
                            <span id="export_file_name" style="width: 800px;"><c:out value="${exportFile}"/></span>
                        </td>
                    </tr>
                </table>
                <div style="float: right;right: 70px; font-size: 1.2em;" id="btn_export" class="button btn-action <c:choose><c:when test="${exportAvailable}">button-green</c:when><c:otherwise>button-grey</c:otherwise></c:choose>" <c:if test="${exportAvailable}">onclick="doExport()"</c:if>>
                    Выполнить экспорт
                </div>
            </td>
        </tr>
        </table>

        <div id="export-error-container" style="display: none">
            <div>
                Не удалось сформировать файл экспорта.
                <br/>
                <br/>
                <div id="export-error-message"></div>
            </div>
        </div>
        <div id="export-success-container" style="display: none">
            <div>
                Экспорт успешно завершен
            </div>
        </div>
        <div id="invalid_filename_format_container" style="display: none">
            ВНИМАНИЕ!!!<br/>
            Выбран некорректный файл-ключ шифрования результатов КЕГЭ.<br/>
            Название файла-ключа должно иметь формат:<br/>
            <c:out value="${filenamePattern}" /><br/>
            <br/>
            Выберите другой файл.
        </div>
    </div>                    
    </body>
</html>
