<%-- Author: Андрей Посмитный --%>
<%-- Author: Дмитрий Угримов --%>

<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<c:set var="filenamePattern" scope="page">
<c:out value="${currentRegion}" />00_PRIVATKEY_KIM_KEGE_SubjectCode_<c:out value="${currentSubjectCode}" />_KeyDate_<дата выпуска ключа>.pfx
</c:set>   
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Выбор файла с ключем расшифровки КИМ</title>
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/jquery-ui-1.8.16.custom.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/main.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/header.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/kimmaster.css' />" />
        <!--[if lt IE 9]>
            <%@ include file="/css/iebuttons.css.jspf" %>
            <%@ include file="/css/iestyles/master.css.jspf" %>
        <![endif]-->
        <script type="text/javascript" src="<c:url value='/script/jquery-1.7.1.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery-ui-1.8.16.custom.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/common.js' />"></script>
        <script type="text/javascript">

            function previousStep() {
                $("#choosekimform").submit();
            }


            function nextStep() {
                if (validateNextStep()) {
                    $("#choosekeyform").submit();
                }
            }
            
            function validateNextStep() {
                <c:choose>
                    <c:when test="${empty fileName}">                
                        if ($('#keyfile').val()){
                            $('#fileNotChosen').hide();
                            return true;
                        } else {
                            $('#fileNotChosen').show();
                            return false;
                        }
                    </c:when>
                    <c:otherwise>
                        return true;
                    </c:otherwise>
                </c:choose>                        
            }
            
            function validateSelectedFile(){
                var filename = $('#keyfile').val();
                var regex = new RegExp("<c:out value="${currentRegion}" default="0"/>00_PRIVATKEY_KIM_KEGE_SubjectCode_<c:out value="${currentSubjectCode}" default="0"/>_KeyDate_[0-9|\.]+\.pfx", "i");
                var matches = regex.exec(filename);
                if (matches == null){
                    $('#keyfile').val('');
                    showMessage(
                        'ВНИМАНИЕ!!!', 
                        'Выбран некорректный файл-ключ расшифровки КИМ.<br/>'
                        + 'Название файла-ключа должно иметь формат:<br/>'
                        + '<c:out value="${filenamePattern}" /><br/><br/>'
                        + 'Выберите другой файл.', 
                        550);            
                }
            }
            
            $(document).ready(function () {
                <c:if test="${!empty errorMessage}">                        
                    showMessage('ОШИБКА!!!', '<c:out value="${errorMessage}" escapeXml="false"/>', 500);
                </c:if>
            });
            
        </script>
        <%@ include file="../checkinternet-api.jspf" %>
    </head>
    <body>
        
<noscript>
    <style type="text/css">
        .pagecontent {display:none;}
    </style>
    <div class="noscriptmsg">
        <%@include file="../noscript.jspf" %>
    </div>
</noscript>        
<div class="pagecontent"> 
    
        <%@ include file="../examheader.jspf" %>

	<table class="mainpanel">
        <tr>
            <td class="td-content box-shadow paper-list">
                <a style="margin-bottom: 10px;" href='<c:url value="/"/>'><strong>На главную</strong></a>
                
                <table class="td-content-table">
                <tr>
                    <td class="td-main-content">
                        <h1 class="content-title">ИМПОРТ ЭЛЕКТРОННЫХ КИМ. ШАГ 2 из 3. Выбор файла-ключа расшифровки КИМ</h1>
                        <div class="info-box">
                            <p>Выберите файл-ключ расшифровки электронных КИМ, полученный от Уполномоченного ГЭК и нажмите <strong>«Далее»</strong>.</p>
                            <p>Название файла-ключа расшифровки КИМ имеет формат:</p>
                            <p><c:out value="${filenamePattern}" /></p>
                        </div>

                        <table class="choosefile">
                            <tr>
                                <td class="sub-header">
                                    Выберите файл-ключ расшифровки КИМ:&nbsp;
                                </td>
                                <td>
                                    <form id="choosekeyform" action="choosekey.html" method="POST" accept-charset="UTF-8" enctype="multipart/form-data">
                                        <input id="keyfile" name="attachment1" type="file" onchange="validateSelectedFile();">
                                        <input type="hidden" name="sessionId" value="<c:out value="${sessionId}"/>"/>
                                    </form>
                                    <div><c:out value="${fileName}" /></div>
                                </td>
                            </tr>
                        </table>
                        <div id="fileNotChosen" style="color: red; display: none;">
                            Не выбран файл ключа! Выберите файл и повторите попытку.
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>
                        <div class="button button-green" id="btn-previous" onclick="previousStep();">Назад</div>
                        <div class="button button-green" id="btn-next" onclick="nextStep();">Далее</div>
                    </td>
                </tr>
                </table>

            </td>
        </tr>
	</table>        
        
        <form style="display:none;" id="choosekimform" action="choosekim.html" method="GET">
            <input type="hidden" name="sessionId" value="<c:out value="${sessionId}"/>"/>
        </form>
        
</div>        
    </body>
</html>
