<%-- Author: Андрей Посмитный --%>
<%-- Author: Дмитрий Угримов --%>

<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>

<c:set var="filenamePattern" scope="page">
<c:out value="${currentRegion}" />00_KIM_KEGE_SubjectCode_<c:out value="${currentSubjectCode}" />_ExamID_<c:out value="${currentExamId}" />_ExamDate_<fmt:formatDate pattern="dd.MM.yyyy" value="${currentExamDate}" />.dat
</c:set>    
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Выбор файла с электронными КИМ</title>
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/jquery-ui-1.8.16.custom.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/main.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/header.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/kimmaster.css' />" />
        <!--[if lt IE 9]>
            <%@ include file="/css/iebuttons.css.jspf" %>
            <%@ include file="/css/iestyles/master.css.jspf" %>
        <![endif]-->
        <script type="text/javascript" src="<c:url value='/script/jquery-1.7.1.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery-ui-1.8.16.custom.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/common.js' />"></script>
        <script type="text/javascript">

            function nextStep() {
                if (validateNextStep()) {
                    $("#choosekimform").submit();
                }
            }
            
            function validateSelectedFile(){
                var filename = $('#kimfile').val();
                var regex = new RegExp("<c:out value="${filenamePattern}" />", "i");
                var matches = regex.exec(filename);
                if (matches == null){
                    $('#kimfile').val('');
                    showMessage(
                        'ВНИМАНИЕ!!!', 
                        'Выбран некорректный файл с электронными КИМ.<br/>'
                        + 'Название файла с электронными КИМ должно иметь формат:<br/>'
                        + '<c:out value="${filenamePattern}" /><br/><br/>'
                        + 'Выберите другой файл.', 
                        550);                 
                }
            }
            
            function validateNextStep() {
                <c:choose>
                    <c:when test="${empty fileName}">
                        if ($('#kimfile').val()){
                            $('#fileNotChosen').hide();
                            return true;
                        } else {
                            $('#fileNotChosen').show();
                            return false;
                        }
                    </c:when>
                    <c:otherwise>
                        return true;
                    </c:otherwise>
                </c:choose>
            }

            $(document).ready(function () {
                <c:if test="${!empty errorMessage}">
                    showMessage('ОШИБКА!!!', '<c:out value="${errorMessage}" escapeXml="false"/>', 500);                        
                </c:if>
            });

        </script>
        <%@ include file="../checkinternet-api.jspf" %>
    </head>
    <body>
        
<noscript>
    <style type="text/css">
        .pagecontent {display:none;}
    </style>
    <div class="noscriptmsg">
        <%@include file="../noscript.jspf" %>
    </div>
</noscript>        
<div class="pagecontent"> 
    
        <%@ include file="../examheader.jspf" %>

	<table class="mainpanel">
        <tr>
            <td class="td-content box-shadow paper-list">
                <a style="margin-bottom: 10px;" href='<c:url value="/"/>'><strong>На главную</strong></a>
                
                <table class="td-content-table">
                <tr>
                    <td class="td-main-content">
                        <h1 class="content-title">ИМПОРТ ЭЛЕКТРОННЫХ КИМ. ШАГ 1 из 3. Выбор файла с электронными КИМ</h1>
                        <div class="info-box">
                            <p>Выберите файл с электронными КИМ, полученный из РЦОИ или от Уполномоченного ГЭК и нажмите <strong>«Далее»</strong>.</p>
                            <p>Название файла с электронными КИМ имеет формат:</p>
                            <p><c:out value="${filenamePattern}" /></p>
                        </div>

                        <table class="choosefile">
                            <tr>
                                <td class="sub-header">
                                    Выберите файл с электронными КИМ:&nbsp;
                                </td>
                                <td>
                                    <form id="choosekimform" action="choosekim.html" method="POST" accept-charset="UTF-8" enctype="multipart/form-data">
                                        <input id="kimfile" name="attachment1" type="file" onchange="validateSelectedFile();" />
                                        <input type="hidden" name="sessionId" value="<c:out value="${sessionId}"/>" />
                                    </form>
                                    <div><c:out value="${fileName}" /></div>
                                </td>
                            </tr>
                        </table>
                        <div id="fileNotChosen" style="color: red; display: none;">
                            Не выбран файл импорта! Выберите файл и повторите попытку.
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>
                        <div class="button button-green" id="btn-next" onclick="nextStep();">Далее</div>
                    </td>
                </tr>
                </table>

            </td>
        </tr>
	</table>
                               
</div>
                                
    </body>
</html>
