<%-- Author: Andrey Posmitniy --%>

<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Выбор пароля</title>
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/jquery-ui-1.8.16.custom.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/main.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/header.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/kimmaster.css' />" />
        <!--[if lt IE 9]>
            <%@ include file="/css/iebuttons.css.jspf" %>
            <%@ include file="/css/iestyles/master.css.jspf" %>
        <![endif]-->
        <script type="text/javascript" src="<c:url value='/script/jquery-1.7.1.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery-ui-1.8.16.custom.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/common.js' />"></script>
        <script type="text/javascript">

            function previousStep() {
                $("#choosekeyform").submit();
            }
            
            function nextStep() {
                if (validateNextStep()) {
                    $("#passwordform").submit();
                }
            }
            
            function validateNextStep() {
                if ($('#password').val()){
                    $('#password_empty').hide();
                    return true;
                } else {
                    $('#password_empty').show();
                    return false;
                }
            }
            
            $(document).ready(function () {
                <c:if test="${!empty errorMessage}">                        
                    showMessage('ОШИБКА!!!', '<c:out value="${errorMessage}" escapeXml="false"/>', 500);
                </c:if>
                
                <c:if test="${keyMismatch}">
                    $('#key-mismatch-container').dialog({ 
                        title: 'Импорт КИМ', 
                        width: 500,
                        height: 160,
                        modal: true,
                        resizable: false,
                        buttons: [
                            {
                                'class': 'button button-light-grey dialog-button',
                                text: "Закрыть",
                                click: function() { 
                                    $(this).dialog("close"); return false; 
                                }
                            }
                        ]
                    });                         
                </c:if>
            });
            
        </script>
        <%@ include file="../checkinternet-api.jspf" %>
    </head>
    <body>
        
<noscript>
    <style type="text/css">
        .pagecontent {display:none;}
    </style>
    <div class="noscriptmsg">
        <%@include file="../noscript.jspf" %>
    </div>
</noscript>        
<div class="pagecontent"> 
    
        <%@ include file="../examheader.jspf" %>

	<table class="mainpanel">
        <tr>
            <td class="td-content box-shadow paper-list">
                <a style="margin-bottom: 10px;" href='<c:url value="/"/>'><strong>На главную</strong></a>

                <table class="td-content-table">
                <tr>
                    <td class="td-main-content">
                        <h1 class="content-title">ИМПОРТ ЭЛЕКТРОННЫХ КИМ. ШАГ 3 из 3. Ввод пароля доступа к электронным КИМ</h1>
                        <div class="info-box">
                            <p>Введите пароль доступа к электронным КИМ, полученный от Уполномоченного ГЭК, и нажмите <strong>«Готово»</strong>.</p>
                        </div>

                        <table class="choosefile">
                            <tr>
                                <td class="sub-header">
                                    Введите пароль доступа к электронным КИМ:&nbsp;
                                </td>
                                <td>
                                    <form id="passwordform" action="decrypt.html" method="POST" accept-charset="UTF-8" enctype="multipart/form-data">
                                        <input id="password" name="password" type="text" />
                                        <input type="hidden" name="sessionId" value="<c:out value="${sessionId}"/>"/>
                                    </form>
                                </td>
                            </tr>
                        </table>
                        <div id="password_empty" style="color: red; display: none;">
                            Введите пароль.
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>
                        <div class="button button-green" id="btn-previous" onclick="previousStep();">Назад</div>
                        <div class="button button-green" id="btn-next" onclick="nextStep();">Готово</div>
                    </td>
                </tr>
                </table>

            </td>
        </tr>
	</table>        

        <form style="display:none;" id="choosekeyform" action="choosekey.html" method="GET">
            <input type="hidden" name="sessionId" value="<c:out value="${sessionId}"/>"/>
        </form>        
        
        <%--div id="key-mismatch-container" style="display: none">
            ВНИМАНИЕ!!!<br/>
            Выбранный ключ и введённый пароль относятся к другому комплекту КИМ, расшифровка КИМ невозможна.<br/>
            Выберите другой ключ и введите соответствующий пароль.
        </div--%>
</div>        
    </body>
</html>
