<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Пробная печать КИМ и бланков</title>
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/jquery-ui-1.8.16.custom.css' />" />	
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/main.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/preparemaster.css' />" />
        <!--[if lt IE 9]>
            <%@ include file="/css/iebuttons.css.jspf" %>
            <%@ include file="/css/ie-examheader.css.jspf" %>
            <%@ include file="/css/iestyles/master.css.jspf" %>
        <![endif]-->
        <script type="text/javascript" src="<c:url value='/script/jquery-1.7.1.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery-ui-1.8.16.custom.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery.dataTables.min.js' />"></script>
        <script type="text/javascript">
  
            var intervalId = 0;
            
            $(function() {
                $('#button-finish').bind('click', function() {
                    $('#testKimPrintFormForward').submit();    
                });
                
                $('#button-back').bind('click', function() {
                    location.href = '<c:url value="/prepare/software.html"></c:url>';
                });
                
                intervalId = setInterval(getTestPrintResult, 3000);
            });

            function setPrintSuccess(element) {
                element.removeClass('failed-message').addClass('success-message').text('успешно выполнено');
            }
            
            function setPrintNotFinished(element) {
                element.removeClass('success-message').addClass('failed-message').text('не выполнена ');
            }
            
            function getTestPrintResult() {
                $.ajax({
                    type: 'POST',
                    async: false,
                    url: '<c:url value="gettestprintresult.action"/>',
                    success: function(response) {
                        
                        var kimPrintResultBlock = $('#test-print-kim-result');
                        var blankPrintResultBlock = $('#test-print-blank-result');
                        
                        
                        
                        if(response.testKimPrintResult)
                            setPrintSuccess(kimPrintResultBlock);
                        else
                            setPrintNotFinished(kimPrintResultBlock);

                        if(response.testBlankPrintResult)
                            setPrintSuccess(blankPrintResultBlock);
                        else 
                            setPrintNotFinished(blankPrintResultBlock);
                        
                        if(response.testBlankPrintResult && response.testKimPrintResult) {
                            clearInterval(intervalId);
                        }
                    }
                });
            }
            
        </script>
        <%@ include file="../checkinternet-api.jspf" %>
    </head>
    <body>
        
<noscript>
    <style type="text/css">
        .pagecontent {display:none;}
    </style>
    <div class="noscriptmsg">
        <%@include file="../noscript.jspf" %>
    </div>
</noscript>        
<div class="pagecontent"> 
    
        <%@ include file="../examheader.jspf" %>
        <input type="hidden" name="is-saved" id="is-saved" value="true">
        <table class="mainpanel">
                <tr>
                    <td class="td-content box-shadow paper-list">
                        <table class="content-table" cellpadding="0" cellspacing="0">
                            <tbody>
                                <tr>
                                    <td class="top-content" style="padding: 4px 0;">
                                        <a style=" display: inline-block; margin-bottom: 10px;" class="skyblue" href='<c:url value="/"/>'><strong>На главную</strong></a>
                                        <h1 class="content-header">ПОДГОТОВКА К ПРОВЕДЕНИЮ ЭКЗАМЕНА. ШАГ 3 из 3.</h1>
                                        <h2 class="content-header">Пробная печать КИМ и бланков</h2>
                                        <div class="info-box">
                                            <h5 class="block-title">Информация</h5>
                                            <hr class="light-grey">
                                            <p>На рабочей станции организатора 
                                                <strong class="important">необходимо запустить АРМ Организатора</strong>
                                                и на стартовой странице выполнить пробную печать КИМ и бланков.
                                            </p>
                                            <ul style="list-style: none; padding: 0;">
                                                <li>
                                                    <strong>Пробная печать КИМ:&nbsp;</strong>
                                                    <span class=
                                                            "<c:choose>
                                                                <c:when test="${testKimPrintResult}">
                                                                    success-message
                                                                </c:when>
                                                                <c:otherwise>failed-message</c:otherwise>
                                                            </c:choose>"
                                                        id="test-print-kim-result">
                                                            <c:choose>
                                                                <c:when test="${testKimPrintResult}">
                                                                    успешно выполнено
                                                                </c:when>
                                                                <c:otherwise>не выполнена</c:otherwise>
                                                            </c:choose>
                                                    </span>
                                                </li>
                                                <li>
                                                    <strong>Пробная печать бланков:&nbsp;</strong>
                                                    <span class=
                                                        "<c:choose>
                                                            <c:when test="${testPrintResult}">
                                                                success-message
                                                            </c:when>
                                                            <c:otherwise>failed-message</c:otherwise>
                                                        </c:choose>"
                                                     id="test-print-blank-result">
                                                        <c:choose>
                                                            <c:when test="${testPrintResult}">
                                                                успешно выполнено
                                                            </c:when>
                                                            <c:otherwise>не выполнена</c:otherwise>
                                                        </c:choose>
                                                    </span>
                                                </li>
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="vertical-align: bottom;">
                                            <div id="button-back" class="button button-green">Назад</div>
                                        <form id="testKimPrintFormForward" name="testKimPrintFormForward" method="POST">
                                            <div id="button-finish" class="button button-green">Готово</div>
                                        </form>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
        </table>  
</div>                                        
    </body>
</html>
