<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Установка программного обеспечения</title>
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/jquery-ui-1.8.16.custom.css' />" />	
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/main.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/preparemaster.css' />" />
        <!--[if lt IE 9]>
            <%@ include file="/css/iebuttons.css.jspf" %>
            <%@ include file="/css/ie-examheader.css.jspf" %>
            <%@ include file="/css/iestyles/master.css.jspf" %>
        <![endif]-->
        <script type="text/javascript" src="<c:url value='/script/jquery-1.7.1.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery-ui-1.8.16.custom.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery.dataTables.min.js' />"></script>
        <script type="text/javascript">
            
            $(function() {
                
                $('#button-back').bind('click', function() {
                   location.href = '<c:url value="/prepare/tech.html"></c:url>'; 
                });
                
                $('#button-save').bind('click', function() {
                   $.ajax({
                        type: 'POST',
                        url: '<c:url value="/prepare/setconfirmsoftware.action" />',
                        data: { confirmed: $('#confirm-sowtware-setup').attr('checked') == 'checked' },
                        success: function(checked) {
                                $('#dialog-message').text('Сохранено');
                                $('#response-message-box').dialog({ 
                                title: 'Сообщение', 
                                width: 350,
                                height: 150,
                                modal: true,
                                resizable: false
                            });
                            $('#is-saved').val('true');
                            var $checkbox = $('#confirm-sowtware-setup');
                            if(checked) 
                                $checkbox.attr('checked', 'checked');
                            else
                                $checkbox.removeAttr('checked');
                            
                        },
                        error: function() {
                            $('#dialog-message').text('Не удалось сохранить');
                                $('#response-message-box').dialog({ 
                                title: 'Сообщение', 
                                width: 350,
                                height: 150,
                                modal: true,
                                resizable: false
                            });
                        }
                   });
                });
                
                $().bind('click', function() {

                })
                
                function nextStep() {
                    $('#softwareConfirmForm').submit();
                    //window.location = '<c:url value="/prepare/print.html" />';
                }
                
                $('#confirm-sowtware-setup').bind('change', function() {
                    $('#is-saved').val('false');
                });
                
                $('#button-next').bind('click', function() {
                    if($('#confirm-sowtware-setup').attr("checked") != "checked" ||  $('#is-saved').val() == 'false') {
                        $('#dialog-confirm-step').dialog({ 
                            title: 'Предупреждение', 
                            width: 500,
                            height: 130,
                            modal: true,
                            resizable: false
                        });
                    }
                    else {
                        nextStep();
                    }
                });
                
                $('#dialog-button-next').bind('click', nextStep);
                
                $('.button-cancel').bind('click', function() {
                    $(this).parents('.dialog-container').dialog('close');    
                }); 
            }) 
            
            function bindDatatables(element) {
                element.dataTable({
                    "bFilter": false,
                    "bInfo": false,
                    "bPaginate": false,
                    "bStateSave": false,
                    "sScrollY": "200px",
                    "bPaginate": false
                });
            }
        </script>
        <%@ include file="../checkinternet-api.jspf" %>
    </head>
    <body>
        
<noscript>
    <style type="text/css">
        .pagecontent {display:none;}
    </style>
    <div class="noscriptmsg">
        <%@include file="../noscript.jspf" %>
    </div>
</noscript>        
<div class="pagecontent"> 
    
        <%@ include file="../examheader.jspf" %>
        <input type="hidden" name="is-saved" id="is-saved" value="true">
        <table class="mainpanel">
                <tr>
                    <td class="td-content box-shadow paper-list">
                        <table cellpadding="0" cellspacing="0" style="width: 100%;">
                            <tbody>
                                <tr>
                                    <td class="top-content" style="padding: 4px 0;">
                                        <a style=" display: inline-block; margin-bottom: 10px;" class="skyblue" href='<c:url value="/"/>'><strong>На главную</strong></a>
                                        <h1 class="content-header">ПОДГОТОВКА К ПРОВЕДЕНИЮ ЭКЗАМЕНА. ШАГ 2 из 3.</h1>
                                        <h2 class="content-header">Установка программного обеспечения</h2>
 
                                        <div class="info-box">
                                            <h5 class="block-title">Информация</h5>
                                            <hr class="light-grey">
                                            <p>На каждой рабочей станции участника для сдачи экзамена
                                                <strong class="important">должно быть установлено</strong>
                                                следующее программное обеспечение:
                                            </p>
                                        </div>

                                        <table id="software-table" cellpadding="0" cellspacing="0">
                                            <thead class="content-table-header">
                                                <tr>
                                                    <th class="software-type-name">
                                                        Тип программного обеспечения
                                                    </th>
                                                    <th class="software-name">
                                                        Наименование программного обеспечения
                                                    </th>
                                                    <th class="software-website last-col-header">
                                                        Адрес для скачивания дистрибутива
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td colspan="3">
                                                        <div class="scrollable-content-box">
                                                            <table class="inner-table" style="width: 100%;">
                                                                <tbody>
                                                                   <c:forEach items="${softwareList}" var="swItem">
                                                                        <tr>
                                                                            <td class="software-type-name">
                                                                                <c:out value="${swItem.softwareTypeName}"/>
                                                                            </td>
                                                                            <td class="software-name">
                                                                                <c:out value="${swItem.softwareName}"/>
                                                                            </td>
                                                                            <td class="software-website">
                                                                                <a class="skyblue" target="_blank" href="<c:out value="${swItem.softwareWebsite}"/>"><c:out value="${swItem.softwareWebsite}"/></a>
                                                                            </td>
                                                                        </tr>
                                                                    </c:forEach> 
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    <div class="confirm-software-setup-col">
                                        <form id="softwareConfirmForm" name="softwareConfirmForm" method="POST">
                                            <input type="checkbox" name="confirm-sowtware-setup" id="confirm-sowtware-setup" <c:if test="${softwareConfirmed}">checked="checked"</c:if> >
                                            <label for="confirm-sowtware-setup">Подтверждаю, что на всех рабочих станциях участников установлены необходимые среды программирования</label>
                                        </form>
                                    </div>
                                <tr>
                                    <td>
                                        <div id="button-back" class="button button-green">Назад</div>
                                        <div id="button-next" class="button button-green button-next">Далее</div>
                                        <div id="button-save" class="button button-green">Сохранить</div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
        </table>
        <div id="dialog-confirm-step" class="dialog-container">
            <p>Необходимо подтвердить, что необходимые среды программирования установлены</p>
            <hr class="light-grey">
            <div id="dialog-button-next" class="button button-green button-next">Далее</div>
            <div id="dialog-button-cancel" class="button button-grey button-cancel">Отмена</div>
        </div>
        
        <div id="response-message-box" class="dialog-container" style="text-align: center; display: none;">
            <p id="dialog-message" style="text-align: center; padding: 15px;">Сохранено</p>
            <hr class="light-grey">
            <div id="button-ok" class="button button-green button-cancel" style="float: right;">ОК</div>
        </div>
</div>
                                            
    </body>
</html>
