<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@page contentType="text/html" pageEncoding="UTF-8"%>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Техническое оснащение аудитории</title>
        
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/jquery-ui-1.8.16.custom.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/main.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/preparemaster.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/header.css' />" />
       <!--[if lt IE 9]>
            <%@ include file="/css/iebuttons.css.jspf" %>
            <%@ include file="/css/ie-examheader.css.jspf" %>
            <%@ include file="/css/exam.css.jspf" %>
       <![endif]-->
        <script src="<c:url value='/script/jquery-1.7.1.min.js' />" type="text/javascript"></script>
        <script src="<c:url value='/script/jquery-ui-1.8.16.custom.min.js' />" type="text/javascript"></script>
        <script src="<c:url value='/script/common.js' />" type="text/javascript"></script>
        
        <script type="text/javascript">

            var confirmed = <c:out value="${confirmed}"/>;
            
            function save(){
                var confirmedNew = $('#confirm-tech').is(':checked');
                if (confirmedNew == confirmed) {
                    return;
                }
                $.ajax({
                    type: "POST",
                    async: false,
                    url: '<c:url value="/prepare/setconfirmtech.action"/>',
                    data: {confirm: confirmedNew},
                    success: function(checked) {
                        confirmed = confirmedNew;
                        $('input[name=confirm-tech]').attr('checked', confirmed);
                        $('#dialog-message').text('Сохранено');
                            $('#response-message-box').dialog({ 
                            title: 'Сообщение', 
                            width: 350,
                            height: 150,
                            modal: true,
                            resizable: false
                        });
                    },
                    error: function() {
                        $('input[name=confirm-tech]').attr('checked', confirmed);
                        $('#dialog-message').text('Не удалось сохранить');
                        $('#response-message-box').dialog({ 
                            title: 'Сообщение', 
                            width: 350,
                            height: 150,
                            modal: true,
                            resizable: false
                        });
                    }                    
                });
            }
        
            function nextStep(){
                if(!confirmed){
                    $('#dialog-confirm-step').dialog({ 
                        title: 'Предупреждение', 
                        width: 500,
                        height: 130,
                        modal: true,
                        resizable: false
                    });
                } else {
                    toSoftware();
                }
            }
            
            function toSoftware(){
                window.location = '<c:url value="/prepare/software.html" />';
            }
            
            $(function() {
                $('#dialog-button-next').bind('click', toSoftware);
                
                $('.button-cancel').bind('click', function() {
                    $(this).parents('.dialog-container').dialog('close');    
                });
            })
            
        </script>
        <%@ include file="../checkinternet-api.jspf" %>
    </head>
    <body>

<noscript>
    <style type="text/css">
        .pagecontent {display:none;}
    </style>
    <div class="noscriptmsg">
        <%@include file="../noscript.jspf" %>
    </div>
</noscript>        
<div class="pagecontent"> 
    
    <%@ include file="../examheader.jspf" %>
    <table class="mainpanel">
        <tr><td>
            <table>
                <tr>
                    <td class="td-content box-shadow paper-list">
                        <a style=" display: inline-block; margin-bottom: 10px;" class="skyblue" href='<c:url value="/"/>'><strong>На главную</strong></a>

                        <h1 class="content-header">ПОДГОТОВКА К ПРОВЕДЕНИЮ ЭКЗАМЕНА. ШАГ 1 ИЗ 3.</h1>
                        <h2 class="content-header">Техническое оснащение аудитории</h2>

                        <div class="info-box">
                            <strong>ИНФОРМАЦИЯ</strong><br/>
                            <hr class="light-grey">
                            В аудитории должна быть настроена одноранговая сеть 
                            типа «звезда», построенная с использованием одного 
                            концентратора и объединяющая все рабочие станции. 
                            Подробнее о требованиях к оборудованию и 
                            конфигурации рабочих станция см.  
                            <a class="skyblue" href="<c:url value="/files/Teh_Pogotovka.pdf" />#" target="_blank">инструкцию по технической подготовке аудитории</a>.
                            <br/>
                            <hr class="light-grey">
                            В данной аудитории должно быть установлено:
                            <br/><br/>
                            <span style="font-weight: bold;">Рабочих станций участников: <c:out value="${expectedParticipants}"/></span><br/>
                            <span style="font-weight: bold;">Рабочих станций организаторов: <c:out value="${expectedOrganizators}"/></span><br/>
                            <span style="font-weight: bold;">Лазерный принтер: 1</span>
                        </div>
                        <div>
                            Для проверки наличия подключения к серверу всех рабочих станций в аудитории включите компьютеры рабочих станций,
                            которые будут использоваться на экзамене, и <span style="font-weight: bold; text-decoration: underline">выполните вход в систему</span> для соответствующего АРМ: достаточно, чтобы открылась
                            страница авторизации (подробнее см.  
                            <a class="skyblue" href="<c:url value="/files/Teh_Pogotovka.pdf" />#" target="_blank">инструкцию по технической подготовке аудитории</a>).
                        </div>

                        <c:set var="participants_action_name" value="проверены"/>
                        <c:set var="organizators_action_name" value="проверена"/>                            
                        <%@ include file="../onlineworkstations.jspf" %>
                        
                        <form action="tech.html" method="POST">
                            <div class="confirm-software-setup-col">
                                <input type="checkbox" name="confirm-tech" id="confirm-tech" <c:if test="${confirmed}">checked="checked"</c:if> />
                                <label for="confirm-tech">Подтверждаю, что техническое оснащение и конфигурация локальной сети соответствуют
                                    минимальным требованиям.</label>
                            </div>
                        </form>
                        <div>
                            <div id="button-next" class="button button-green button-next" onclick="nextStep();">Далее</div>
                            <div id="button-save" class="button button-green" onclick="save();">Сохранить</div>
                        </div>
                    </td>
                </tr>
            </table>               
        </td></tr>
    </table>
                                
    <div id="dialog-confirm-step" class="dialog-container">
        <p>Необходимо подтвердить, что техническое оснащение и конфигурация локальной сети соответствуют
           минимальным требованиям.</p>
        <hr class="light-grey">
        <div id="dialog-button-next" class="button button-green button-next">Далее</div>
        <div id="dialog-button-cancel" class="button button-grey button-cancel">Отмена</div>
    </div>

    <div id="response-message-box" class="dialog-container" style="text-align: center; display: none;">
        <p id="dialog-message" style="text-align: center; padding: 15px;">Сохранено</p>
        <hr class="light-grey">
        <div id="button-ok" class="button button-green button-cancel" style="float: right;">ОК</div>
    </div>                                
    </div>
    </body>
</html>
