<%-- Author: Andrey Posmitniy --%>

<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Выбор аудитории</title>
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/main.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/header.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/seatingmaster.css' />" />
        <!--[if lt IE 9]>
            <%@ include file="/css/iebuttons.css.jspf" %>
            <%@ include file="/css/ie-examheader.css.jspf" %>
            <%@ include file="/css/iestyles/master.css.jspf" %>
        <![endif]-->
        <script type="text/javascript" src="<c:url value='/script/jquery-1.7.1.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery-ui-1.8.16.custom.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/common.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery.form.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/modernizr-1.7.min.js' />"></script>
        <script type="text/javascript">
            function previousStep() {
                $("#previewseatingform").submit();
            }
            
            function nextStep() {
                if (validateAud()) {
                    $("#savepackageform").submit();
                }
            }

            function validateAud() {
                var val = $("[name='auditoriumId']:checked").val();
                if (val) {
                    $("#auditorium-error").hide();
                    return true;
                } else {
                    $("#auditorium-error").show();
                    return false;
                }
            }
        </script>
        <%@ include file="../checkinternet-api.jspf" %>
    </head>
    <body>
        
<noscript>
    <style type="text/css">
        .pagecontent {display:none;}
    </style>
    <div class="noscriptmsg">
        <%@include file="../noscript.jspf" %>
    </div>
</noscript>        
<div class="pagecontent"> 
    
        <%@ include file="../examheader.jspf" %>

	<table class="mainpanel setup-panel">
        <tr>
            <td class="td-content box-shadow paper-list">

                <table class="td-content-table">
                <tr>
                    <td class="td-main-content">
                        <h1>ПОДГОТОВКА К ЭКЗАМЕНУ. ЗАГРУЗКА ИСХОДНЫХ ДАННЫХ. ШАГ 3 из 4.</h1>
                        <h2>Выбор аудитории</h2>
                        <div class="info-box">
                            Выберите аудиторию, в которой выполняется установка системы, и нажмите <strong>«Далее»</strong>.
                        </div>

                        <c:choose>
                            <c:when test="${empty error}">
                                <form id="savepackageform" action="saveaud.action" method="POST">
                                    <c:forEach items="${auditoriums}" var="item">
                                        <div class="radio">
                                            <input id="aud_<c:out value="${item.auditoriumId}" />" name="auditoriumId" type="radio" value="<c:out value="${item.auditoriumId}" />" />
                                            <label class="auditorium-name-label" for="aud_<c:out value="${item.auditoriumId}" />"><c:out value="${item.auditoriumFullName}" /></label>
                                        </div>
                                    </c:forEach>
                                    <div id="auditorium-error" class="validation-error">
                                        Необходимо выбрать аудиторию из списка
                                    </div>
                                </form>
                            </c:when>
                            <c:otherwise>
                                <div style="color:red;">
                                    <c:out value="${error}" />
                                </div>
                            </c:otherwise>
                        </c:choose>

                    </td>
                </tr>
                <tr>
                    <td>
                        <div class="button button-green" id="btn-previous" onclick="previousStep();">Назад</div>
                        <c:if test="${empty error}">
                            <div class="button button-green" id="btn-next" onclick="nextStep();">Далее</div>
                        </c:if>
                    </td>
                </tr>
                </table>

            </td>
        </tr>
	</table>        

        <form style="display:none;" id="previewseatingform" action="previewseating.html" method="GET">
        </form>
</div>
    </body>
</html>
