<%-- Author: Andrey Posmitniy --%>

<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Выбор режима работы</title>
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/jquery-ui-1.8.16.custom.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/main.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/header.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/seatingmaster.css' />" />
        <!--[if lt IE 9]>
            <%@ include file="/css/iebuttons.css.jspf" %>
            <%@ include file="/css/ie-examheader.css.jspf" %>
            <%@ include file="/css/iestyles/master.css.jspf" %>
        <![endif]-->
        <script type="text/javascript" src="<c:url value='/script/jquery-1.7.1.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery-ui-1.8.16.custom.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/common.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery.form.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/modernizr-1.7.min.js' />"></script>
        <script type="text/javascript">

            function nextStep(isTestMode) {
                if (isTestMode) {
                    $("input[name='isTestMode']").val(true);
                }
                $("#mode").val(isTestMode);
                $("#choosemodeform").submit();
            }
        </script>
        <%@ include file="../checkinternet-api.jspf" %>
        <%@ include file="../checkjs-api.jspf" %>
    </head>
    <body>

<noscript>
    <style type="text/css">
        .pagecontent {display:none;}
    </style>
    <div class="noscriptmsg">
        <%@include file="../noscript.jspf" %>
    </div>
</noscript>        
<div class="pagecontent">         
        
	<div class="toppanel-small">
            <div class="toppanel-left-block">
                <div class="scopename">
                    <strong>ПРОВЕДЕНИЕ ЕГЭ ПО ИНФОРМАТИКЕ И ИКТ В КОМПЬЮТЕРНОЙ ФОРМЕ</strong>
                </div>
            </div>
            <div class="toppanel-right-block">
                <a title="Краткая инструкция" class="instruction" href="<c:url value='/manual_index.htm' />#step_1" target="_blank"></a>
            </div>
	</div>

	<div class="choosemodepanel box-shadow">
            <h1>АРМ «АДМИНИСТРАТОР ПК КГЭ»</h1>
            <div class="sub-header">Выберите режим работы в системе:</div>
		
            <p style="font-size: 1.1em;">
                <div class="button button-green" onclick="nextStep(false);">Проведение ЕГЭ по Информатике и ИКТ в компьютерной форме</div>
                <br />
                Данный режим используется для проведения единого государственного экзамена по Информатике и ИКТ в компьютерной форме. Для работы системы на этапе подготовки к экзамену из РЦОИ должны быть получены данные рассадки (автоматизированного распределения). Для проведения экзамена, из РЦОИ (или от Уполномоченного ГЭК) должны быть получены электронные КИМ и ключ их расшифровки. В день экзамена на специализированном портале размещается пароль доступа к электронным КИМ.
                <br />
                Перед началом подготовки к экзамену рекомендуется ознакомиться с работой системы в демонстрационном режиме.
            </p>
            
            <p style="font-size: 1.1em; margin-top: 10px;">
                <div class="button button-green" onclick="nextStep(true);">Работа в демонстрационном режиме</div>
                <br />
                В данном режиме для работы системы используются специально подготовленные демонстрационные данные (поставляются вместе с дистрибутивом системы).
                <br />
                В системе доступны все функции, используемые для проведения реального экзамена, можно провести полную имитацию всего экзамена с вводом ответов, печатью КИМ, бланков и т.п.
                <br />
                Для перехода к рабочему режиму в АРМ Администратора необходимо удалить данные рассадки: функция «Удалить данные рассадки» вверху главной страницы.
            </p>
		
	</div>
        
        <form style="display:none;" id="choosemodeform" action="setmode.action" method="POST">
            <input id="mode" name="isTestMode" type="hidden" />
        </form>

</div>
            
    </body>
</html>
