<%-- Author: Andrey Posmitniy --%>

<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Импорт рассадки</title>
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/main.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/header.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/seatingmaster.css' />" />
        <!--[if lt IE 9]>
            <%@ include file="/css/iebuttons.css.jspf" %>
            <%@ include file="/css/iestyles/master.css.jspf" %>
        <![endif]-->
        <script type="text/javascript" src="<c:url value='/script/jquery-1.7.1.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery-ui-1.8.16.custom.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/common.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/modernizr-1.7.min.js' />"></script>
        <script type="text/javascript">

            function previousStep() {
                $("#choosemodeform").submit();
            }
            
            function nextStep() {
                if (validateNextStep()) {
                    $("#seatingform").submit();
                }
            }
            
            function validateNextStep() {
                if ($('#seatingfile').val()){
                    $('#fileNotChosen').hide();
                    return true;
                } else {
                    $('#fileNotChosen').show();
                    return false;
                }
            }
        </script>
        <%@ include file="../checkinternet-api.jspf" %>
    </head>
    <body>
        
<noscript>
    <style type="text/css">
        .pagecontent {display:none;}
    </style>
    <div class="noscriptmsg">
        <%@include file="../noscript.jspf" %>
    </div>
</noscript>        
<div class="pagecontent"> 
    
        <%@ include file="../examheader.jspf" %>

	<table class="mainpanel setup-panel">
        <tr>
            <td class="td-content box-shadow paper-list">

                <table class="td-content-table">
                <tr>
                    <td class="td-main-content">
                        <h1>ПОДГОТОВКА К ЭКЗАМЕНУ. ЗАГРУЗКА ИСХОДНЫХ ДАННЫХ. ШАГ 1 из 4.</h1>
                        <h2>Выбор файла с данными автоматизированного распределения</h2>
                        <div class="info-box">
                            <p>Выберите файл с данными автоматизированного распределения, полученный из РЦОИ и нажмите <strong>«Далее»</strong>.</p>
                            <p>Название файла с данными автоматизированного распределения имеет формат:</p>
                            <p>KEGE_ExamDate_<дата экзамена>Информатика_и_ИКТ_в_комп._форме_<код региона>_PPE_<код ППЭ>_<дата экспорта в РЦОИ>.dat</p>
                        </div>

                        <table class="choosefile">
                            <tr>
                                <td class="sub-header">
                                    Выберите файл с рассадкой:&nbsp;
                                </td>
                                <td>
                                    <form id="seatingform" action="chooseseating.html" method="POST" accept-charset="UTF-8" enctype="multipart/form-data">
                                        <input id="seatingfile" name="attachment1" type="file">
                                    </form>
                                </td>
                                <td>
                                    <span id="filename"></span>
                                </td>
                            </tr>
                        </table>
                        <div id="fileNotChosen" style="color: red; display: none;">
                            Не выбран файл импорта! Выберите файл и повторите попытку.
                        </div>
                        <c:if test="${!empty errors}">
                            <c:forEach items="${errors}" var="error">
                                <div style="color: red;">
                                    <c:out value="${error}" />
                                </div>
                            </c:forEach>
                        </c:if>
                    </td>
                </tr>
                <tr>
                    <td>
                        <div class="button button-green" id="btn-previous" onclick="previousStep();">Назад</div>
                        <div class="button button-green" id="btn-next"  onclick="nextStep();">Далее</div>
                    </td>
                </tr>
                </table>

            </td>
        </tr>
	</table>        
        
        <form style="display:none;" id="choosemodeform" action="choosemode.html" method="GET">
        </form>

</div>        
        
    </body>
</html>
