<%-- Author: Andrey Posmitniy --%>

<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Проверка рассадки</title>
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/main.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/header.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/seatingmaster.css' />" />
        
        <!--[if lt IE 9]>
            <%@ include file="/css/iebuttons.css.jspf" %>
            <%@ include file="/css/ie-examheader.css.jspf" %>
            <%@ include file="/css/iestyles/master.css.jspf" %>
        <![endif]-->
        
        <script type="text/javascript" src="<c:url value='/script/jquery-1.7.1.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery-ui-1.8.16.custom.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/common.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery.form.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/modernizr-1.7.min.js' />"></script>
        <script type="text/javascript">

            function previousStep() {
                $("#chooseseatingform").submit();
            }
            
            function nextStep() {
                $("#chooseaudform").submit();
            }
        </script>
        <%@ include file="../checkinternet-api.jspf" %>
    </head>
    <body>

<noscript>
    <style type="text/css">
        .pagecontent {display:none;}
    </style>
    <div class="noscriptmsg">
        <%@include file="../noscript.jspf" %>
    </div>
</noscript>        
<div class="pagecontent">         
        
        <%@ include file="../examheader.jspf" %>

	<table class="mainpanel setup-panel" >
        <tr>
            <td class="td-content box-shadow paper-list">

                <table class="td-content-table">
                <tr>
                    <td class="td-main-content">
                        <h1>ПОДГОТОВКА К ЭКЗАМЕНУ. ЗАГРУЗКА ИСХОДНЫХ ДАННЫХ. ШАГ 2 из 4.</h1>
                        <h2>Проверка данных автоматизированного распределения</h2>
                        <div class="info-box">
                            Проверьте правильность ППЭ, для которого предназначены данные.
                            <br />
                            Если данные предназначены не для вашего ППЭ, то не загружайте данные и обратитесь в РЦОИ.
                            <br />
                            Если данные предназначены для вашего ППЭ, то нажмите <strong>«Далее»</strong>.
                        </div>

                        <table cellspacing="9">
                        <tr>
                            <td class="td-leftheader"><p class="normal">Наименование ППЭ:</p></td>
                            <td>
                                <p class="normal"><c:out value="${stationName}" /></p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td-leftheader"><p class="normal">Адрес ППЭ:</p></td>
                            <td>
                                <p class="normal"><c:out value="${stationAddress}" /></p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td-leftheader"><p class="normal">Экзамен:</p></td>
                            <td>
                                <p class="normal"><c:out value="${examName}" /></p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td-leftheader"><p class="normal">Дата экзамена:</p></td>
                            <td>
                                <p class="normal"><c:out value="${examDate}" /></p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td-leftheader"><p class="normal">Количество участников:</p></td>
                            <td>
                                <p class="normal"><c:out value="${participantsCount}" /></p>
                            </td>
                        </tr>
                        <tr>
                            <td class="td-leftheader"><p class="normal">Количество аудиторий:</p></td>
                            <td>
                                <p class="normal"><c:out value="${auditoriumsCount}" /></p>
                            </td>
                        </tr>
                        </table>

                    </td>
                </tr>
                <tr>
                    <td>
                        <div class="button button-green"  id="btn-previous" onclick="previousStep();">Назад</div>
                        <div class="button button-green" id="btn-next" onclick="nextStep();">Далее</div>
                    </td>
                </tr>
                </table>

            </td>
        </tr>
	</table>        
        
        <form style="display:none;" id="chooseseatingform" action="chooseseating.html" method="GET">
        </form>
        <form style="display:none;" id="chooseaudform" action="previewseatingdone.action" method="POST">
        </form>

</div>                            
                            
    </body>
</html>
