<%-- Author: Andrey Posmitniy --%>

<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Задание пароля администратора ПК КЕГЭ</title>
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/main.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/header.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/seatingmaster.css' />" />
        <!--[if lt IE 9]>
            <%@ include file="/css/iebuttons.css.jspf" %>
            <%@ include file="/css/iestyles/master.css.jspf" %>
        <![endif]-->
        <script type="text/javascript" src="<c:url value='/script/jquery-1.7.1.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery-ui-1.8.16.custom.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/common.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery.form.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/modernizr-1.7.min.js' />"></script>
        <script type="text/javascript">

            function previousStep() {
                $("#chooseaudform").submit();
            }
            
            function nextStep() {
                if (validate()) {
                    $("#setAdminPasswordForm").submit();
                }
            }

            function validate() {
                var isValid = true;
                
                var memberId = $("[name='workerId'] :selected").val();
                if (memberId) {
                    $("#worker-error").hide();
                } else {
                    $("#worker-error").show();
                    isValid = false;
                }
                
                var password = $("[name='password']").val();
                if (password) {
                    $("#password-error").hide();
                } else {
                    $("#password-error").show();
                    isValid = false;
                }
                
                var passwordConfirm = $("[name='passwordConfirm']").val();
                if (passwordConfirm) {
                    $("#passwordConfirm-error").hide();
                } else {
                    $("#passwordConfirm-error").show();
                    isValid = false;
                }
                
                if (password && passwordConfirm && password != passwordConfirm) {
                    $("#passwordsEquals-error").show();
                    isValid = false;
                } else {
                    $("#passwordsEquals-error").hide();
                }
                
                return isValid;
            }
        </script>
        <%@ include file="../checkinternet-api.jspf" %>
    </head>
    <body>

<noscript>
    <style type="text/css">
        .pagecontent {display:none;}
    </style>
    <div class="noscriptmsg">
        <%@include file="../noscript.jspf" %>
    </div>
</noscript>        
<div class="pagecontent">         
        
        <%@ include file="../examheader.jspf" %>

	<table class="mainpanel setup-panel">
        <tr>
            <td class="td-content box-shadow paper-list">

                <table class="td-content-table">
                <tr>
                    <td class="td-main-content">
                        <h1>ПОДГОТОВКА К ЭКЗАМЕНУ. ЗАГРУЗКА ИСХОДНЫХ ДАННЫХ. ШАГ 4 из 4.</h1>
                        <h2>Задание пароля Администратора ПК КЕГЭ</h2>
                        <div class="info-box">
                            Выберите ФИО технического специалиста, который устанавливает систему.
                            <br />
                            Задайте пароль Администратора ПК ЕГЭ, введите его подтверждение и нажмите <strong>«Готово»</strong>.
                        </div>

                        <c:choose>
                            <c:when test="${empty errors}">

                                <form id="setAdminPasswordForm" action="setadminpassword.action" method="POST">
                                <table id="set-admin-password">
                                    <tr>
                                        <td class="caption">Выберите технического специалиста:</td>
                                        <td>
                                            <select name="workerId">
                                                <option></option>
                                                <c:forEach items="${workers}" var="item">
                                                    <option value="<c:out value="${item.workerId}" />">
                                                        <c:out value="${item.workerFullName}" />
                                                    </option>
                                                </c:forEach>
                                            </select>
                                        </td>
                                        <td><p class="validation-error" id="worker-error">Не выбран технический специалист</p></td>
                                    </tr>
                                    <tr>
                                        <td class="caption">Пароль:</td>
                                        <td><input type='password' name='password' /></td>
                                        <td><p class="validation-error" id="password-error">Пароль не задан</p></td>
                                    </tr>
                                    <tr>
                                        <td class="caption">Подтверждение пароля:</td>
                                        <td><input type='password' name='passwordConfirm' /></td>
                                        <td>
                                            <p class="validation-error" id="passwordConfirm-error">Подтверждение не задано</p>
                                            <p class="validation-error" id="passwordsEquals-error">Пароль и подтверждение не совпадают</p>
                                        </td>
                                    </tr>
                                </table>
                                </form>

                            </c:when>
                            <c:otherwise>
                                <c:forEach items="${errors}" var="error">
                                    <div style="color:red;">
                                        <c:out value="${error}" />
                                    </div>
                                </c:forEach>
                            </c:otherwise>
                        </c:choose>

                    </td>
                </tr>
                <tr>
                    <td>
                        <div class="button button-green" id="btn-previous" onclick="previousStep();">Назад</div>
                        <c:if test="${empty error}">
                            <div class="button button-green" id="btn-next" onclick="nextStep();">Готово</div>
                        </c:if>
                    </td>
                </tr>
                </table>

            </td>
        </tr>
	</table>        

        <form style="display:none;" id="chooseaudform" action="chooseaud.html" method="GET">
        </form>
</div>
    </body>
</html>
