function showMessage(title, message, width)
{
	if (width == undefined) {
		width = 400;
	}
	
	var content = 
		'<div id="dialog-confirm" class="ui-dialog-content ui-widget-content"> ' +
		'<table><tr><td style="vertical-align: top;">' +
		'<span class="ui-icon ui-icon-alert" style="float:left; margin:0 7px 0 0;"></span>' +
		'</td><td>' +
		message +
		'</td></tr></table>' +
		'</div>';

	$(content).dialog({ 
   		title: title,
		width: width,
		modal: true,
                position: ['center', 'center'],
                resizable: false,
   		buttons: [{
   			text: "Закрыть",
                        'class': 'button button-light-grey',
     		click: function() { $(this).dialog("close"); return false; }
   		}]
	});
}

function showErrorMessage(message) {
    if (message.length != 0) {
        showMessage('Предупреждение', message);
        return true;
    }
    else {
        return false;
    }
}

function showInfoMessage(message) {
    if (message.length != 0) {
        showMessage('Сообщение', message);
        return true;
    }
    else {
        return false;
    }
}


function declination(a, b, c, s) {
	var words = [a, b, c];
	var index = s % 100;

	if (index >=11 && index <= 14) { index = 0; }
	else { index = (index %= 10) < 5 ? (index > 2 ? 2 : index): 0; }

	return(words[index]);
}

function setMaxHeight(element, offset) {
    if(offset == undefined || offset == null) {
        offset = 15;
    }
    if(typeof element == 'string') {
        element = $(element);
    }
    $(window).bind('resize', function() {
        var topOffset = element.offset().top;
        element.height($(window).height() - topOffset - offset);  
    });
    
    $(window).resize();
}