<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<!DOCTYPE html>
<html>
    <head>
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/jquery-ui-1.8.16.custom.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/main.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/login.css' />" />
        <title>АРМ &laquo;Организатор в аудитории&raquo;</title>
        <!--[if lt IE 9]>
            <%@ include file="/css//iestyles/iebuttons.css.jspf" %>
            <%@ include file="/css/iestyles/master.css.jspf" %>
        <![endif]-->
        <script type="text/javascript" src="<c:url value='/script/jquery-1.7.1.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery-ui-1.8.16.custom.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery.cookie.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/plugindetect.js' />"></script>
        <script type="text/javascript">

            $(document).ready(function() {
                pingServer();
                bindDialogEvents()
                
                <c:choose>
                    <c:when test="${printAudProtocolAvailable}">
                        $("#aud-protocol-print-button").show();
                    </c:when>
                    <c:otherwise>
                        $("#aud-protocol-print-button").hide();
                    </c:otherwise>
                </c:choose>                    
                    
                <c:if test="${!empty audProtocolReady}">
                    downloadPrintProtocol();
                </c:if>
                
                var lastLogin = $.cookie("kege_org_lastlogin");
                $("[name='j_username']").val(lastLogin);
                if (lastLogin) {
                    $("[name='j_password']").focus();
                } else {
                    $("[name='j_username']").focus();
                }
                
                $("[name='f']").submit(function() {
                    $.cookie("kege_org_lastlogin", $("select[name='j_username']").val());
                    if (validate()) {
                        return true;
                    }

                    return false;
                });
            });          
            
            function pingServer() {
                $.post('<c:url value="/pingOrganizator.action"/>');
                setTimeout(pingServer, 3000);
            }
            
            function validate() {
                var isValid = true;
                
                if (!$("input[name='j_password']").val()) {
                    isValid = false;
                    $("#inputPasswordCaption").css("color", "red");
                    $("[name='j_password']").focus();
                } else {
                    $("#inputPasswordCaption").css("color", "black");
                }
                
                if (!$("select[name='j_username']").val()) {
                    isValid = false;
                    $("#chooseOrgCaption").css("color", "red");
                    $("[name='j_username']").focus();
                } else {
                    $("#chooseOrgCaption").css("color", "black");
                }
                
                return isValid;
            }
            
            function applyDialog(element, dlgTitle, dlgHeight) {
                element.dialog({ 
                            title: dlgTitle, 
                            width: 850,
                            height: dlgHeight,
                            modal: true,
                            resizable: false
                        });
            }
            
            function bindDialogEvents() {
                $('#enter-button').bind('click', function() {
                    $("[name='f']").submit();
                });

                $('#test-kim-print-button').bind('click', function() {
                    $('#kim-confirm-box').hide();
                    $('#kim-print-progress').show();
                    $("#pdf-kim-preview").removeAttr("src");
                    $("#pdf-kim-preview").empty();
                    applyDialog($('#kim-print-dialog'), 'Пробная печать КИМ', 520);
                    var pdfUrl = "<c:url value="/testprint/downloadTestKim.action" />";
                    var f = '<iframe src="' + pdfUrl + '" id="pdf-kim-preview" style="width: 100%; height: 220px; border: 1px solid #cecece;" frameBorder="0"></iframe>';
                    $("#kim-preview-container").html(f);

                    $('#kim-print-progress').hide();
                    $('#kim-confirm-box').show();
                });
                
                $('#test-blank-print-button').bind('click', function() {
                    $('#blank-confirm-box').hide();
                    $('#blank-print-progress').show();
                    $("#html-blank-preview").removeAttr("src");
                    $("#html-blank-preview").empty();
                    $("#pdf-blank-preview").removeAttr("src");
                    $("#pdf-blank-preview").empty();
                    applyDialog($('#blank-print-dialog'), 'Пробная печать бланков', 520);

                    $.ajax({
                        type: 'POST',
                        url: '<c:url value="/testprint/renderTestBlank.json" />',
                        success: function(data) {
                            
                            var htmlUrl = "<c:url value="/testprint/getTestBlankHtml.action" />?fileid=" + data;
                            $("#html-blank-preview").attr("src", htmlUrl);

                            var pdfUrl = "<c:url value="/testprint/getTestBlankPdf.action" />?fileid=" + data;
                            var f = '<iframe src="' + pdfUrl + '" id="pdf-blank-preview" style="visibility:hidden; width: 1px; height: 1px;"></iframe>';
                            $("body").append(f);
                            
                            $('#blank-print-progress').hide();
                            $('#blank-confirm-box').show();
                        },
                        error: function() {
                            alert("Ошибка при формировании тестового бланка");
                        }
                    });
                });
                
                $('.button-cancel').bind('click', function() {
                    $(this).parents('.dialog').dialog('close');
                    $('#kim-print-success-confirm').removeAttr('checked');
                    $('#blank-print-success-confirm').removeAttr('checked');
                });
                
                $('.button-ok').bind('click', function() {
                    $(this).parents('.dialog').dialog('close');
                });
                
                $('#button-kim-confirm').bind('click', function() {
                    if($('#kim-print-success-confirm').attr('checked') == 'checked') {
                        $.ajax({
                           type: 'POST',
                           url: '<c:url value="/testprint/printKimConfirm.action" />',
                           success: function(data) {
                                $('#response-message-box').dialog({
                                    title: 'Сообщение', 
                                    modal: true,
                                    resizable: false
                                });
                                $('#test-kim-print-button').hide();
                                $('#kim-print-success-confirm').attr('checked', 'checked');
                                
                                // в data флаг возможности печатипротокола готовности аудитории
                                if(data === 'true') {
                                    $("#aud-protocol-print-button").show();
                                }
                           },
                           error: function() {
                               $('#kim-success-confirm').removeAttr('checked');
                           }
                        });
                    }
                });
                
                $('#button-blank-confirm').bind('click', function() {
                    if($('#blank-print-success-confirm').attr('checked') == 'checked') {
                        $.ajax({
                           type: 'POST',
                           url: '<c:url value="/testprint/printBlankConfirm.action" />',
                           success: function(data) {
                                $('#response-message-box').dialog({
                                    title: 'Сообщение', 
                                    modal: true,
                                    resizable: false
                                });
                                $('#test-blank-print-button').hide();
                                $('#blank-success-confirm').attr('checked', 'checked');
                                
                                // в data флаг возможности печатипротокола готовности аудитории
                                if(data === 'true') {
                                    $("#aud-protocol-print-button").show();
                                }
                           },
                           error: function() {
                               $('#blank-success-confirm').removeAttr('checked');
                           }
                        });
                    }
                });
            }
            
            function printProtocol() {
                var form = $('#printProtocolForm');
                $("[name='additionalData']", form).val(new Date().getTime());
                form.submit();
            }

            <c:if test="${!empty audProtocolReady}">
            function downloadPrintProtocol() {
                var form = $('#downloadProtocolForm');
                $("[name='additionalData']", form).val(new Date().getTime());
                form.submit();
            }
            </c:if>
                
        </script>
        <style type="text/css">
            .progress-indicator {
                background-image: url('<c:url value="/images/progress.gif"/>');
                background-repeat: no-repeat;
                height: 11px;
                width: 16px;
            }            
        </style>
        <%@ include file="../checkpdfplugin-api.jspf" %>
        <%@ include file="../checkinternet-api.jspf" %> 
        <%@ include file="../checkjs-api.jspf" %> 
    </head>
    <body>
        
<noscript>
    <style type="text/css">
        .pagecontent {display:none;}
    </style>
    <div class="noscriptmsg">
        <%@include file="../noscript.jspf" %>
    </div>
</noscript>        
<div class="pagecontent"> 
    
        <form name='f' action="<c:url value='/j_spring_security_check' />" method='POST'>
            
            <div id="wrapper">
                <div class="form-wrapper box-shadow">
                    <table class="start" cellpadding="0" cellspacing="0" border="0">
                    <tr>
                        <td id="header-caption" class="header outer">
                            <h1 class="status-left-side">АРМ «Организатор в аудитории»</h1>
                                <br />
                                <span class="tip-grey">Выберите организатора и введите пароль</span>
                        </td>
                    </tr>
                    <tr>
                        <td class="first-row outer">
                            <table class="exam">
                            <tr><td colspan="2"><hr class="delim"></td></tr>
                            <tr>
                                <td class="field"><p class="normal"><strong class="label">Предмет:</strong></p></td>
                                <td><p class="normal"><c:out value="${examHeader.subjectName}"/></p></td>
                            </tr>
                            <tr>
                                <td class="field"><p class="normal"><strong class="label">Дата экзамена:</strong></p></td>
                                <td><p class="normal"><c:out value="${examHeader.examDate}"/></p></td>
                            </tr>
                            <tr>
                                <td class="field"><p class="normal"><strong class="label">Аудитория:</strong></p></td>
                                <td><p class="normal"><c:out value="${examHeader.auditorium}"/></p></td>
                            </tr>

                            <tr>
                                <td class="field fullname"><p class="normal"><strong class="label" id="chooseOrgCaption">ФИО организатора:</strong></p></td>
                                <td class="fullname">
                                    <p class="normal">
                                        <select name="j_username">
                                            <option></option>
                                            <c:forEach items="${workers}" var="worker">
                                                <option value="${worker.workerId}"><c:out value="${worker.fullName}"/></option>
                                            </c:forEach>
                                        </select>
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <td class="field pass"><p class="normal"><strong class="label" id="inputPasswordCaption">Пароль:</strong></p></td>
                                <td class="pass">
                                    <p class="normal">
                                        <input type='password' name='j_password' />
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <td class="field error">&nbsp;</td>
                                <td class="error"><p class="normal small">${errorMessage}</p></td>
                            </tr>
                            
                            <tr><td colspan="2"><hr class="delim"></td></tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td class="auth-buttons outer">
                            <c:if test="${testPrintAvailable}">
                                <c:if test="${!testKimPrintComplete}">
                                    <div id="test-kim-print-button" class="button button-green">Пробная печать КИМ</div> 
                                </c:if>
                                <c:if test="${!testBlankPrintComplete}">
                                    <div id="test-blank-print-button" class="button button-green">Пробная печать бланков</div>
                                </c:if>
                            </c:if>
                            <div id="aud-protocol-print-button" class="button button-green" style="width: 215px; display: none;" onclick="printProtocol();">Печать протокола готовности</div>
                            <div class="button button-green" id="enter-button">Войти</div>
                        </td>
                    </tr>
                    </table>
                </div>
             </div>                

        </form>

    <c:if test="${testPrintAvailable}">

    <c:if test="${!testKimPrintComplete}">
        <div id="kim-print-dialog" class="print-dialog dialog">
            <div class="dialog-content">
                <p>На принтер отправлены тестовые данные для проверки корректности печати электронных КИМ.</p>
                <p>Сверьте содержание напечатанного КИМ с отображенным ниже.</p>
                <p>Если не удается напечатать тестовый КИМ, проверьте правильность настройки принтера и выполните повторную печать.</p>
                <p>Если напечатано неккоректное содержание КИМ, повторите пробную печать,
                если ошибка воспроизводится, обратитесь в РЦОИ.</p>
                <p>Если КИМ напечатан корректно, отметьте соответствующий признак и нажмите &laquo;Сохранить&raquo;</p>
                <div style="width:100%;">
                    <table cellpadding="0" cellspacing="0" style="width:100%">
                        <tr>
                            <td style="width:50%">
                                <p id="kim-confirm-box" class="confirm-box">
                                    <input type="checkbox" name="kim-print-success-confirm" id="kim-print-success-confirm" <c:if test="${testKimPrintComplete}">checked="checked"</c:if>>
                                    <label for="kim-print-success-confirm">Пробная печать выполнена успешно</label>
                                </p>
                                <table id="kim-print-progress"><tr>
                                    <td style="vertical-align: center">Формирование КИМ…&nbsp;</td>
                                    <td><div class="progress-indicator"></div></td>
                                </tr></table>
                            </td>
                            <td>
                                <div id="button-kim-confirm" class="button button-green">Сохранить</div>
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="print-preview" style="width:100%;">
                    <div id="kim-preview-container" style="width: 100%; border: 1pz solid #cecece;">
                    </div>
                </div>
                <div id="button-kim-dialog-close" class="button button-grey button-cancel">Отмена</div>
            </div>
        </div>
    </c:if>
        
    <c:if test="${!testBlankPrintComplete}">
        <div id="blank-print-dialog" class="print-dialog dialog">
            <div class="dialog-content">
                <p>Сформирован PDF файл с тестовыми данными для проверки корректности печати бланков КЕГЭ.</p>
                <p>Распечатайте сформированный файл и сверьте содержание напечатанного бланка с отображаемым ниже.</p>
                <p>Если не удается напечатать тестовый бланк, проверьте правильность настройки принтера и выполните повторную печать.</p>
                <p>Если напечатано неккоректное содержание бланка, повторите пробную печать,
                если ошибка воспроизводится, обратитесь в РЦОИ.</p>
                <p>Если бланк напечатан корректно, отметьте соответствующий признак и нажмите &laquo;Сохранить&raquo;</p>
                <div style="width:100%;">
                    <table cellpadding="0" cellspacing="0" style="width:100%">
                        <tr>
                            <td style="width:50%">
                                <p id="blank-confirm-box" class="confirm-box">
                                    <input type="checkbox" name="blank-print-success-confirm" id="blank-print-success-confirm" <c:if test="${testBlankPrintComplete}">checked="checked"</c:if>>
                                    <label for="blank-print-success-confirm">Пробная печать выполнена успешно</label>
                                </p>
                                <table id="blank-print-progress"><tr>
                                    <td style="vertical-align: center">Формирование бланка…&nbsp;</td>
                                    <td><div class="progress-indicator"></div></td>
                                </tr></table>
                            </td>
                            <td>
                                <div id="button-blank-confirm" class="button button-green">Сохранить</div>
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="print-preview" style="width:100%;">
                    <iframe id="html-blank-preview" style="width: 100%; height: 200px; border: 1px solid #cecece;" frameBorder="0"></iframe>
                </div>
                <div id="button-blank-dialog-close" class="button button-grey button-cancel">Отмена</div>
            </div>
        </div>
         <div id="response-message-box" class="dialog-container dialog" style="text-align: center; display: none;">
            <p id="dialog-message" style="text-align: center; padding: 15px;">Сохранено</p>
            <hr class="light-grey">
            <div id="button-ok" class="button button-green button-ok" style="float: right;">ОК</div>
        </div>
    </c:if>

    </c:if>

        <form style="display:none;" id="printProtocolForm" 
              action='<c:url value="protocol.action"/>' method="GET">
            <%--Поле additionalData служит только для того, изменять URL запроса 
                для предотвращение того, что браузер возьмёт документ из кеша.
                Поэтому в него при каждом запросе надо писать новое значение--%>
            <input name="additionalData" type ="hidden" />
        </form>
        <form style="display:none;" id="downloadProtocolForm" 
              action='<c:url value="downloadProtocol.action"/>' method="POST">
            <%--Поле additionalData служит только для того, изменять URL запроса 
                для предотвращение того, что браузер возьмёт документ из кеша.
                Поэтому в него при каждом запросе надо писать новое значение--%>
            <input name="additionalData" type ="hidden" />
        </form>                            
    </body>
</div>
                            
<div id="pdfresult"></div>                            

</html>