<%@page import="ru.tssoft.kege.model.ParticipantExamStatus"%>
<%@page import="ru.tssoft.kege.org.model.examactions.ExamActionType"%>
<%@page contentType="text/html" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<!DOCTYPE html>
<html>

    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>АРМ &laquo;Организатор в аудитории&raquo;</title>

        <link rel="stylesheet" type="text/css" href="<c:url value='/css/jquery-ui-1.8.16.custom.css' />" />	
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/header.css' />" />
        <link rel="stylesheet" type="text/css" href="<c:url value='/css/main.css' />" />
        <!--[if lt IE 9]>
            <%@ include file="/css/iestyles/iebuttons.css.jspf" %>
            <%@ include file="/css/iestyles/master.css.jspf" %>
        <![endif]-->
        <script type="text/javascript" src="<c:url value='/script/jquery-1.7.1.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery-ui-1.8.16.custom.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/common.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery.dataTables.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/jquery.shortcuts.min.js' />"></script>
        <script type="text/javascript" src="<c:url value='/script/plugindetect.js' />"></script>
        <script type="text/javascript">
            
            var updateIntervalId = -1;
            var orgDataTable;

            $(document).ready(function() {
                pingServer();
                init();
                activateShortcuts();
            });
            
            function activateShortcuts() {
                $.Shortcuts.add({
                    type: 'down',
                    mask: 'Ctrl+Alt+K',
                    handler: function() {
                        assignKimDialog();
                    }
                });
                $.Shortcuts.add({
                    type: 'down',
                    mask: 'Ctrl+Alt+R',
                    handler: function() {
                        showRegnums();
                    }
                });
                
                $.Shortcuts.start();
            }

            function assignKimDialog() {
                $("#assignKimPassword").val('');
                $("#assignKimValidationMessage").html('');
                $('#assignKimContainer').dialog({ 
                    title: 'Начало экзамена', 
                    width: 550,
                    height: 140,
                    modal: true,
                    resizable: false
                });
            }
            
            var showRegnums = function() {
                $.ajax({
                    async: false,
                    url: '<c:url value="getparticipantregnums.json"/>',
                    type: 'POST',
                    success: function(data) {
                        if(data && data.length > 0){
                            var content = '<tr style="text-align: center; font-weight: bold;"><td>Место</td><td>ФИО</td><td>Рег. номер</td></tr>';
                            for(i=0; i < data.length; i++){
                                content += '<tr>';
                                content += '<td style="width: 1px">' + data[i].placeNumber + '</td>';
                                content += '<td style="width: 100%">' + data[i].fio + '</td>';
                                content += '<td style="width: 1px">' + data[i].regnum + '</td>';
                                content += '</tr>';
                            }
                            $("#participant-regnums-table").html(content);
                            $("#participant-regnums-container").dialog({
                                title: 'Регистрационные номера участников', 
                                width: 640,
                                height: 480,
                                modal: true,
                                resizable: true
                            });                            
                        }

                    }
                });
            }
            
            function assignKimDialogClose() {
                $("#assignKimContainer").dialog("close");
            }
            
            function assignKimStart(){
                var password = $("#assignKimPassword").val();
                $.ajax({
                    type: 'post',
                    async: false,
                    url: '<c:url value="assignkimwithoutprint.action" />',
                    data: {'password': password},
                    success: function() {
                        assignKimDialogClose();
                    },
                    error: function(data) {
                        $("#assignKimPassword").val('');
                        $("#assignKimValidationMessage").html(data.responseText);
                    }
                });                
            }

            function pingServer() {
                $.post('<c:url value="/pingOrganizator.action"/>');
                setTimeout(pingServer, 3000);
            }
            
            function init() {
                $.ajaxSetup({ cache: false });
                
                $("#isIe").val($.browser.msie == true);
                updatePage();
                
                updateIntervalId = startUpdateByTimer();
                
                var participantTable = $('#examStatuses');
                bindDatatables(participantTable);
                bindTableEvents(participantTable);
                
                $('body').click(function() {
                    $('.extra-action:visible').hide(0, function() {
                        startUpdateByTimer();  
                    });
                });
                
            }
            
            function startUpdateByTimer(miliseconds) {
                
                if(miliseconds == undefined)
                    miliseconds = 3000;
                
                updateIntervalId = setInterval(
                function() {
                    updatePage();
                },
                miliseconds);
                
                return updateIntervalId;
            }
            
            function bindTableEvents(element) {
                element.live('click', function(e) {
                    var $target = $(e.target);
                    if($target.hasClass('partFio')) {
                        <%-- Отображаем информацию об участнике --%>
                        var participantId = $target.parent().parent().parent().attr('participantId');
                        $.ajax({
                            type: 'POST',
                            url: '<c:url value="/getParticipantInfo.json" />',
                            dataType: 'json',
                            data: { participantId: participantId },
                            async:false,
                            success: function(participant) {
                                var participantInfoContainer = $('#participantInfo');
                                
                                <c:if test="${isTestMode}">
                                    $("#regNumber", participantInfoContainer).html(participant.regNum);
                                </c:if>
                                    
                                $("#p_surname", participantInfoContainer).html(participant.surname);
                                $("#p_name", participantInfoContainer).html(participant.name);
                                $("#p_secondname", participantInfoContainer).html(participant.secondName);
                                $("#document-type", participantInfoContainer).html(participant.documentType);
                                $("#document-series", participantInfoContainer).html(participant.documentSeries);
                                $("#document-number", participantInfoContainer).html(participant.documentNumber);
                                $("#code", participantInfoContainer).html(participant.schoolRegistrationCode);
                                $("#class", participantInfoContainer).html(participant.studyClass);
                                $("#placeNum", participantInfoContainer).html(participant.placeNumber);
                                $("#kimNum", participantInfoContainer).html(participant.kimId);
                                
                                setChangedClass("#p_surname", participant.isSurnameChanged);
                                setChangedClass("#p_name", participant.isNameChanged);
                                setChangedClass("#p_secondname", participant.isSecondNameChanged);
                                setChangedClass("#document-type", participant.isDocumentTypeChanged);
                                setChangedClass("#document-series", participant.isDocumentSeriesChanged);
                                setChangedClass("#document-number", participant.isDocumentNumberChanged);
                                
                                showMessage("Информация об участнике", participantInfoContainer.html(), 490, false);
                            }
                        });
                        return false;
                    }
                    
                    if($target.hasClass('execute-extra-action')) {
                        
                        $target.next().show();
                        clearInterval(updateIntervalId);
                        $target.parents('tr').siblings().find('.extra-action:visible')
                            .hide(0, function() {
                                startUpdateByTimer();
                            }); 
                        return false;
                    }
                    
                    if($target.hasClass('action-description') || $target.hasClass('action-link')) {
                         execAction($target);
                         return false;
                    };                
                });
            }
            
            function setChangedClass(element, isChanged) {
                if (isChanged) {
                    $(element).addClass('personal-data-changed');
                } else {
                    $(element).removeClass('personal-data-changed');
                }
            }
            
            function bindDatatables(element) {
                orgDataTable = element.dataTable({
                    "aaSorting": [[ 1, "asc" ]],
                    "bFilter": false,
                    "bInfo": false,
                    "bPaginate": false,
                    "bStateSave": false,
                    "aoColumns": [
                        { "aDataSort": [ 0, 1 ] },
                        null,
                        { "aDataSort": [ 2, 1 ] },
                        { "aDataSort": [ 3, 1 ] },
                        { "bSortable": false },
                        { "bSortable": false },
                        { "bSortable": false }
                    ]
                });
            }
            
            function updatePage()
            {
                if (printInProgress) {
                    return;
                }
                
                $.ajax({
                    type: 'POST',
                    url: '<c:url value="/examStatus.json" />',
                    dataType: 'json',
                    async:false,
                    success: function(examStatus)
                    {
                        <%--обновляем текущие действия (подсказки)--%>
                        $("#exam-actions-title").hide();
                        $("#exam-actions-table").hide();
                        $("#exam-actions-table tr").hide();
                        if (examStatus.examActions && examStatus.examActions.length) {
                            for (var i = 0; i < examStatus.examActions.length; i++) {
                                var tr = $("#action_" + examStatus.examActions[i] + "", "#exam-actions-table");
                                tr.show();
                                tr.removeClass("last-exam-action");
                            }
                            $("#exam-actions-title").show();
                            $("#exam-actions-table").show();
                        }
                        var lastTr = $('#exam-actions-table tr:visible:last')
                        if (lastTr) {
                            lastTr.addClass("last-exam-action");
                        }
                        
                        <%--запоминаем выбранный радиобаттон--%>
                        selectedParticipantId = getSelectedParticipantId();
                        <%-- запоминаем параметры сортировки и очищаем таблицу --%>
                        var currentSorting = null;
                        if (orgDataTable) {
                            currentSorting = orgDataTable.fnSettings().aaSorting;
                            orgDataTable.fnDestroy();
                        }
                        <%--перерисовываем таблицу--%>
                        $("#examStatuses").find("tr:gt(0)").remove();
                        participantExamStatuses = examStatus.participantExamStatuses;
                        rows = '';
                        for (i = 0; i < participantExamStatuses.length; i++) {
                            rows += createRow(participantExamStatuses[i], i+1, examStatus.exportIsDone);
                        }
                        $("#examStatuses").find("tbody:last").append(rows);
                        <%-- сортируем таблицу --%>
                        if (orgDataTable) {
                            bindDatatables($('#examStatuses'));
                            if (currentSorting) {
                                orgDataTable.fnSort(currentSorting);
                            }
                        }
                        
                        <%--чекаем запомненный выше радиобаттон--%>
                        if(selectedParticipantId!= null && selectedParticipantId != '') {
                            var radioBtn = $("input[id=" + selectedParticipantId + "]");
                            radioBtn.attr("checked", "checked");
                        }
                        <%--обновляем статус экзамена--%>
                        $("#examState").empty();
                        $("#examState").append(getExamStatus(examStatus.examStatus));
                        <%--Устанавливаем видимость сообщения о том, что кимы не импортированы--%>
                        if(examStatus.kimImported) {
                            $("#kimNotLoadedContainer").hide();
                        } else {
                            $("#kimNotLoadedContainer").show();
                        }
                        <%--Устанавливаем видимость сообщения о том, что кимы не расшифрованы--%>
                        if(examStatus.kimDecoded) {
                            $("#kimNotDecodedContainer").hide();
                        } else {
                            $("#kimNotDecodedContainer").show();
                        }

                        <%--Обновляем статус распечатанных КИМ--%>
                        $("#kimVariantsPrintCount").html(examStatus.printKimModel.kimVariantsPrintCount);
                        $("#kimVariantsTotalCount").html(examStatus.printKimModel.kimVariantsTotalCount);
                        $("#approximatePagesCount").html(examStatus.printKimModel.approximatePagesCount);

                        //$("#printAllKimStatusTotal").html(examStatus.printKimModel.kimVariantsPrintCount);
                        $("#printParticipantKimStatusTotal").html(examStatus.printKimModel.kimVariantsPrintCount);
                        totalPrintKim = examStatus.printKimModel.kimVariantsPrintCount;
                    },
                    error: function (jqXHR){
                        if (jqXHR.status == 403){
                            window.location.reload(true);
                        }
                    }
                });
            }
            
            function getFileOnce(fileId) {
                var iframe = '<iframe src="' + '<c:url value="/file/getonce/"></c:url>'  + fileId + '" style="visibility:hidden;" width="1" height="1" id="blankPrintFrame"/>';
                $('body').append(iframe);
            }
            
            function preventAction() {
                return false;
            }
            
            
            function disableTable(element) {
                element.die();
                element.on('click', 'a', preventAction);  
            }
            
            function enableTable(element) {
                element.off('click', 'a', preventAction);
                bindTableEvents(element);
            }
            
            function execPrintBlankAction(senderRowId, reprint) {
                
                var $row = $('tr[participantid='  + senderRowId +  ']');
                var progressBar = '<table class="progress"><tr>'
                                    + '<td class="ajax-progress-bar-label">Формирование бланка&nbsp;</td>'
                                    + '<td><div class="ajax-progress-bar"></div></td>'
                                + '</tr></table>';
                            
                var $extraInfoCell = $row.find('.extra-info');
                var $rowContent = $extraInfoCell.html();
                
                
                $.ajax({
                    type: "POST",
                    async: false,
                    url:  '<c:url value="/downloadReport.action"></c:url>',
                    data: { participantId: senderRowId, reprint: (reprint == true) },
                    beforeSend: function() {
                        disableTable($('#examStatuses'));
                        $extraInfoCell.html(progressBar);
                    },
                    complete: function() {
                         enableTable($('#examStatuses'));
                         $extraInfoCell.html($rowContent);
                         $('#reprint-blank-dialog').dialog('close');
                    },
                    success: function(response) {
                        updatePage();
                        if(response)
                            getFileOnce(response);
                    }
                });
            }
            
            function execAction(sender){
                if(sender && sender.attr('href') != undefined) {
                    $.ajax({
                        type: 'POST',
                        async: false,
                        url:  sender.attr('href'),
                        data: {participantId: sender.parents('tr').attr('participantId')},
                        success: function(response) {
                            updatePage();
                        }
                    });
                }
                
            }
            
            function createRow(examData, rowNumber, exportIsDone)
            {
                
                rowClass = rowNumber % 2 == 0 ? 'even' : 'odd';
                var fioClass = examData.changed ? " personal-data-changed" : "";
                
                rowContent = '<tr participantId="' + examData.participantId + '" class="' + rowClass + '">';
                rowContent += '   <td class="exam"><p class="normal"> ' + examData.placeNumber + '</p></td>';
                rowContent += '   <td class="exam left-align">';
                <%--Радиобаттон выбора пользователя удалять не стал, думаю, он может пригодится в дальнейшем.--%>
                <%--rowContent += '      <input type="radio" name="participantSelector" id= "' + examData.participantId + '" />'--%>
                rowContent += '      <p style="display: inline"><a class="partFio ' + fioClass + '" href="#">' + examData.fio + '</a></p>';
                rowContent += '   </td>';
                //rowContent += '   <td class="exam"><p class="normal">' + examData.processConditionText + '</p></td>';
                rowContent += '   <td class="exam"><p class="normal examstatus-' + (examData.examStatusExtra ? examData.examStatusExtra : examData.examStatus) + '">' + (examData.examStatusExtra ? examData.examStatusExtraTitle : examData.examStatusTitle) + '</p></td>';
                rowContent += '   <td class="exam"><p class="normal">' + examData.timeLeft + '</p></td>';
                rowContent += '   <td class="exam extra-info">' + examData.additionalInfo + '</td>';
                rowContent += '   <td class="exam " style="text-align: center;"><a href="#"/>' + getParticipantAction(examData.participantId, examData.examStatus, exportIsDone, examData.examStatusExtra) + '</a></td>';

                var extraMenu = getParticipantExtraActionMenu(examData.participantId, examData.examStatus, exportIsDone, examData.examStatusExtra);
                if (extraMenu) {
                    extraMenu = '<a class="execute-extra-action" href="#">Выбрать</a>' + extraMenu;
                } else {
                    extraMenu = '<span class="extra_actions_empty">Нет доступных действий</span>';
                }
                rowContent += '   <td class="exam left-align">' + extraMenu + '</td>';
                
                rowContent += '</tr>';
                return rowContent;
            }
            
            function setStatus(status)
            {
                participantId = getSelectedParticipantId();
                if(participantId == null || participantId == '')
                {
                    alert("Выберите участника экзамена!")
                }
                else
                {
                    $.ajax({
                        type: 'POST',
                        data: {status: status, participantId: participantId},
                        url: '<c:url value="/setParticipantStatus.action" />',
                        dataType: 'text',
                        async : false,
                        success: function(data)
                        {
                            if(data != null && data != "")
                            {
                                alert(data);
                            }
                            else
                            {
                                updatePage();
                            }
                        }
                    });
                }
            }
            
            function getSelectedParticipantId()
            {
                selected = $("input:checked");
                return selected.attr("id");
            }
            
            function reprintBlankDialog(participantId) {
                var participantFullName = $("tr[participantid='" + participantId + "']", "#examStatuses")
                        .find(".partFio").html();
                $("#reprint-participant-fullname").html(participantFullName);
                $('#reprint-blank-dialog').dialog({ 
                    title: 'Повторная печать бланка', 
                    width: 500,
                    height: 135,
                    modal: true,
                    resizable: false
                });
            
                $('#button-accept-print').unbind('click').bind('click', function() {
                    execPrintBlankAction(participantId, true);
                });
                
                $('.button-close').unbind('click').bind('click', function() {
                    $(this).parents('.dialog-container').dialog('close');
                });
                
                
            }
            
            function printBlank(participantId)
            {
                $.ajax({
                    type: 'POST',
                    data: {status: 3, participantId: participantId},
                    url: '<c:url value="/setParticipantStatus.action" />',
                    async : false,
                    success: function() {
                        updatePage();
                    }
                });
                $("#printBlankHidden").val(participantId);
                $("#additionalData").val(new Date().getTime());
                $("#printBlankForm").submit();
            }
            
            function getExamStatus(examStatusShort)
            {
                var status = "не удалось определить";
                switch(examStatusShort)
                {
                    case 0:
                        status = "Подготовка";
                        break;
                    case 1:
                        status = "Сдача экзамена";
                        break;
                    case 2:
                        status = "Завершён";
                        break;
                    default:
                        break;
                }
                return status;
            }
            
            
            function getParticipantAction(participantId, processCondition, exportIsDone, examStatusExtra) {
                var actions = [
                        { url: '<c:url value="/setAbsence.action" />', description: 'Отметить неявку' },
                        { onclick: "javascript:execPrintBlankAction($(this).attr('data-participantId'), false);", description: 'Напечатать бланк' },
                        { onclick: "javascript:blankAccepted(this);", description: 'Бланки сданы' }
                ];
                
                var statusActionMap = {};
                if(examStatusExtra) {
                    if (examStatusExtra === '<%= ParticipantExamStatus.CheckBlank %>') {
                        statusActionMap = {
                            '<%= ParticipantExamStatus.NotCompleteByValidReason %>': actions[2],
                            '<%= ParticipantExamStatus.Banned %>': actions[2]
                        }                
                    }   
                } else {
                    statusActionMap = {
                        '<%= ParticipantExamStatus.NotEntered %>': actions[0],
                        '<%= ParticipantExamStatus.PrintBlank %>': actions[1],
                        '<%= ParticipantExamStatus.CheckBlank %>': actions[2],
                        '<%= ParticipantExamStatus.NotCompleteByValidReason %>': actions[1],
                        '<%= ParticipantExamStatus.Banned %>': actions[1]
                    }
                }
                if(!exportIsDone && statusActionMap[processCondition] != undefined) {
                    var href = statusActionMap[processCondition].url
                        ? 'href="' + statusActionMap[processCondition].url + '"'
                        : 'href="#"';
                    var onclick = statusActionMap[processCondition].onclick
                        ? 'onclick="' + statusActionMap[processCondition].onclick + '"'
                        : '';
                    return '<a class="action-link" data-action-type="' + processCondition + '"'
                        + ' ' + href + ' '
                        + ' ' + onclick + ' '
                        +' data-participantId="'
                        + participantId 
                        +'">'
                        + statusActionMap[processCondition].description
                        + '</a>';
                } else {
                    return '<span style="color: grey;">&mdash;</span>';
                }
            } 
           
            function getParticipantExtraActionMenu(participantId, examStatus, exportIsDone, examStatusExtra) {
                // Доступные действия
                var actions = {
                  0: {
                      onclick: "javascript:reprintKimDialog('" + participantId + "');",
                      description: 'Повторная печать КИМ'
                  },
                  1: {
                      url: '<c:url value="/setIsLate.action" />',
                      description: 'Участник опоздал на экзамен'
                  },
                  2: {
                      url: '<c:url value="/deleteAbsence.action" />',
                      description:  'Снять отметку о неявке'
                  },
                  3: {
                      url: '<c:url value="/setNotCompleteByValidReason.action" />',
                      description: 'Участник не закончил экзамен по уважительной причине'
                  },
                  4: {
                      url: '<c:url value="/setBanned.action" />',
                      description: 'Участник удалён за нарушение порядка ЕГЭ'
                  },
                  5: {
                      url: '<c:url value="/changeAnswersC.action" />',
                      description: 'Изменить ответы части С после печати бланков'
                  },
                  6: {
                      description: 'Повторная печать бланков',
                      onclick: "javascript:reprintBlankDialog('" + participantId + "');"
                  }
                };
                
                // Debug test
                //examStatus = '<%= ParticipantExamStatus.Started %>';

                // Статус экзамена : список действий
                var statusActionMap = {};
                if(exportIsDone) {
                    statusActionMap = {
                        '<%= ParticipantExamStatus.PrintKim %>':        [], // Печать КИМ
                        '<%= ParticipantExamStatus.NotStarted %>':      [], // Не начат
                        '<%= ParticipantExamStatus.Absence %>':         [], // Неявка
                        '<%= ParticipantExamStatus.Started %>':         [], // Начат
                        '<%= ParticipantExamStatus.PrintBlank %>':      [], // Печать бланка
                        '<%= ParticipantExamStatus.CheckBlank %>':      [actions[6]], // Проверка 
                        '<%= ParticipantExamStatus.BlankAccepted %>':   [actions[6]] // Бланки сданы
                    };
                } else {
                    if(examStatusExtra) {
                        statusActionMap = {
                            '<%= ParticipantExamStatus.Banned %>':                      [actions[6]], // Проверка 
                            '<%= ParticipantExamStatus.NotCompleteByValidReason %>':    [actions[6]] // Бланки сданы
                        };                        
                    } else {
                        statusActionMap = {
                            '<%= ParticipantExamStatus.PrintKim %>':        [], // Печать КИМ
                            '<%= ParticipantExamStatus.NotStarted %>':      [actions[0]], // Не начат
                            '<%= ParticipantExamStatus.Absence %>':         [actions[2], actions[1]], // Неявка
                            '<%= ParticipantExamStatus.Started %>':         [actions[0], actions[3], actions[4]], // Начат
                            '<%= ParticipantExamStatus.PrintBlank %>':      [actions[0], actions[3], actions[4], actions[5]], // Печать бланка
                            '<%= ParticipantExamStatus.CheckBlank %>':      [actions[0], actions[3], actions[4], actions[5], actions[6]], // Проверка 
                            '<%= ParticipantExamStatus.BlankAccepted %>':   [actions[6]] // Бланки сданы
                        };
                    }
                }
                //if(examStatus == '<%= ParticipantExamStatus.PrintKim %>' || examStatus == undefined) {
                if (!statusActionMap[examStatus] || !statusActionMap[examStatus].length) {
                    //return '<span class="extra_actions_empty">Нет доступных действий</span>'
                    return null;
                }
                
                var extraActionMenu = '<ul class="extra-action" name="extraAction" data-participantId="' + participantId + '">';
                    for(var i = 0; i <  statusActionMap[examStatus].length; i++) {
                        var action = statusActionMap[examStatus][i];
                        var href = action.url ? ("href=\"" + action.url + "\"") : "";
                        var onclick = action.onclick ? ("onclick=\"" + action.onclick + "\"") : "";
                        extraActionMenu += '<li><a class="action-description" ' + ' ' + href + ' ' + onclick + ' >' + action.description +'</a></li>'
                    }
                return extraActionMenu += '</ul>';
            }
            
            function printKim() {
                $('#printKimDialogContainer').dialog({ 
                    title: 'Выбор порядка печати КИМ', 
                    width: 700,
                    height: 450,
                    modal: true,
                    resizable: false,
                    buttons: [
                        {
                            'class': 'button button-green dialog-button',
                            text: "Печатать все КИМ подряд",
                            click: function() { printAllKim(); $(this).dialog("close"); return false; }
                        },
                        {
                            'class': 'button button-green dialog-button',
                            text: "Печатать КИМ отдельно по участнику",
                            click: function() { printKimByParticipants(); $(this).dialog("close"); return false; }
                        }
                    ]
                });
                
            }

            var printInProgress;
            var statusCurrent;
            var dialogShowAction;
            var dialogUpdateAction;
            var dialogHideAction;
            var totalPrintKim;

            function printAllKim() {
                dialogShowAction = printAllKimStatusShow;
                dialogUpdateAction = printAllKimStatusUpdate;
                dialogHideAction = printAllKimStatusHide;
                
                //startPrintKims();
                printAllKimConcat();
            }

            function printKimByParticipants() {
                dialogShowAction = printParticipantKimStatusShow;
                dialogUpdateAction = printParticipantKimStatusUpdate;
                dialogHideAction = printParticipantKimStatusHide;
                
                startPrintKims();
            }

            function startPrintKims(concreteParticipantId) {
                printInProgress = true;
                statusCurrent = 0;
                updatePage();
                
                if (dialogShowAction) {
                    dialogShowAction();
                }
                
                printNextKimDecorator(concreteParticipantId);
            }
            function endPrintKims() {
                if (dialogHideAction) {
                    dialogHideAction();
                }

                dialogShowAction = null;
                dialogHideAction = null;

                printInProgress = false;
                updatePage();
                setTimeout(
                    function() {
                        $(".kim-pdf-content").remove();
                    }, 60000);
            }
            function printNextKim(concreteParticipantId) {
                var orderByFullname = $("#print-orderby-fullname").is(':checked');
                var participant = getNextParticipantForPrint(orderByFullname, concreteParticipantId);
                if (participant) {
                    printParticipantKim(participant.participantId, concreteParticipantId);
                } else {
                    endPrintKims();
                }
            }

            function getNextParticipantForPrint(orderByFullname, concreteParticipantId) {
                var participant;
                var data = { orderByFullname: orderByFullname };
                if (concreteParticipantId) {
                    data.participantId = concreteParticipantId;
                }
                
                $.ajax({
                    type: 'POST',
                    data: data,
                    url: '<c:url value="/getNextParticipantForPrintKim.json" />',
                    async : false,
                    success: function(data)
                    {
                        participant = data;
                    }
                });
                if (!participant.participantId) {
                    participant = null;
                }
                return participant;
            }

            var afterPrintKimAction = null;
            function onPdfLoadIE(){
                if(afterPrintKimAction) {
                    afterPrintKimAction();
                }
                printNextKimDecorator(null);            
            }
            function printNextKimIE(participantId, concreteParticipantId) {
                if (!concreteParticipantId) {
                    var iframeObj = document.getElementById("kim-pdf-content-" + participantId);
                    if (iframeObj.readyState == "complete"){
                        onPdfLoadIE();
                    }
                    if (iframeObj.readyState == "loaded"){
                        setTimeout(onPdfLoadIE, 0);
                        iframeObj.onreadystatechange = null; 
                    }
                } else {
                    endPrintKims();
                }
            }
            
            function printNextKimDefault(concreteParticipantId) {
                // Переходим к печати следующего КИМ, только если печать НЕ повторная (т.е. не задан concreteParticipantId)
                if (!concreteParticipantId) {
                    if(afterPrintKimAction) {
                        afterPrintKimAction();
                    }
                    printNextKimDecorator(null);
                } else {
                    endPrintKims();
                }
            }

            function printParticipantKim(participantId, concreteParticipantId) {
                concreteParticipantId = concreteParticipantId ? concreteParticipantId : '';
                
                var eventName = $.browser.msie ? "onreadystatechange='printNextKimIE(\"" + participantId + "\", \"" + concreteParticipantId + "\");'" 
                                    : "onload='printNextKimDefault(\"" + concreteParticipantId + "\");'";

                var reprint = concreteParticipantId ? true : false;
                var src = "<c:url value="/printkim.action"/>?participantId=" + participantId + "&reprint=" + reprint + "&additionalData=" + new Date().getTime();
                $("body").append("<iframe " + eventName + " id='kim-pdf-content-" + participantId + "' class='kim-pdf-content' style='visibility:hidden;' width='1' height='1' src='" + src + "'></iframe>");

                // TODO: в IE не работает событие iframe.onload
            }
            
            function printNextKimDecorator(concreteParticipantId) {
                var orderByFullname = $("#print-orderby-fullname").is(':checked');
                var participant = getNextParticipantForPrint(orderByFullname, concreteParticipantId);
                if (!participant) {
                    participant = {};
                }
                if(statusCurrent < totalPrintKim) {
                    $("#button-accept-kim-print").html('На печать');
                } else {
                    $("#button-accept-kim-print").html('Закрыть');
                }
                dialogUpdateAction(statusCurrent, participant.fullName, participant.place, concreteParticipantId);
                statusCurrent++;
            }
            
            function printAllKimStatusShow() {
                $('#printAllKimStatusContainer').dialog({ 
                    title: 'Печать КИМ', 
                    width: 250,
                    height: 100,
                    modal: true,
                    resizable: false,
                    closeOnEscape: false,
                    dialogClass: 'no-close'
                });
            }
            function printAllKimStatusUpdate(current, nextFio, nextPlace) {
                $("#printAllKimStatusCurrent").html(current);
                printNextKim(null);
            }            
            function printAllKimStatusHide() {
                dialogHideAction = null;
                
                $('#printAllKimStatusContainer').dialog("close");

                $("#printAllKimStatusCurrent").html(null);
                $("#printAllKimStatusTotal").html(null);
            }
            
            function printParticipantKimStatusShow() {
                $("input", "#printParticipantKimStatusContainer").show();
                $('#printParticipantKimStatusContainer').dialog({ 
                    title: 'Печать КИМ', 
                    width: 600,
                    modal: true,
                    resizable: false,
                    close: function(event, ui) {
                        endPrintKims();
                    }
                });
                
                $('#button-accept-kim-print').bind('click', printNextKimByParticipants);
                $('#button-cancel-kim-print').bind('click', function() {
                    $('#printParticipantKimStatusContainer').dialog('close');
                });
                
            }
            function printNextKimByParticipants() {
                $('#print-by-participant-progress').show();
                afterPrintKimAction = function() {
                    $('#print-by-participant-progress').hide();
                    afterPrintKimAction = null;
                };
                $("button", $("#printParticipantKimStatusContainer").next()).hide();
                printNextKim(null);
            }
            function printParticipantKimStatusUpdate(current, nextFio, nextPlace) {
                var lastFio = $("#printParticipantKimStatusNextFio").html();
                var lastPlace = $("#printParticipantKimStatusNextPlace").html();
                        
                $("#printParticipantKimStatusCurrent").html(current);
                $("#printParticipantKimStatusLastFio").html(lastFio);
                $("#printParticipantKimStatusLastPlace").html(lastPlace);
                $("#printParticipantKimStatusNextFio").html(nextFio);
                $("#printParticipantKimStatusNextPlace").html(nextPlace);
                
                $("button", $("#printParticipantKimStatusContainer").next()).show();
            }
            function printParticipantKimStatusHide() {
                dialogHideAction = null;
                
                $('#printParticipantKimStatusContainer').dialog("close");

                $("#printParticipantKimStatusCurrent").html(null);
                $("#printParticipantKimStatusTotal").html(null);
                $("#printParticipantKimStatusLastFio").html(null);
                $("#printParticipantKimStatusLastPlace").html(null);
                $("#printParticipantKimStatusNextFio").html(null);
                $("#printParticipantKimStatusNextPlace").html(null);
            }
            
            function reprintKimDialog(participantId) {

                var participant = getNextParticipantForPrint(true, participantId);
                if (!participant) {
                    participant = {};
                }
                $('#reprintKimParticipantFullName', '#reprintKimContainer').html(participant.fullName);
                $("#reprintKimPassword").val('');
                $("#reprintKeyValidationMessage").css("visibility", "hidden");
                $('#reprintKimContainer').attr("participantId", participantId);

                $('#reprintKimContainer').dialog({ 
                    title: 'Повторная печать КИМ', 
                    width: 600,
                    height: 180,
                    modal: true,
                    resizable: false
                });
            }
            
            function reprintDialogClose() {
                $("#reprintKimContainer").dialog("close");
            }
            
            function reprintValidate() {
                var isValid = false;
                var val = $("#reprintKimPassword").val();
                $.ajax({
                    type: 'POST',
                    data: { password: val },
                    url: '<c:url value="/validatekimpassword.json" />',
                    async : false,
                    success: function(data) {
                        isValid = data == 'true';
                    }
                });

                return isValid;
            }
            
            function reprintStart() {
                $("#reprintKeyValidationMessage").css("visibility", "hidden");
                if (!reprintValidate()) {
                    $("#reprintKeyValidationMessage").css("visibility", "visible");
                    return false;
                }

                var participantId = $('#reprintKimContainer').attr("participantId");
                reprintKim(participantId); 
            }
            
            function reprintKim(concreteParticipantId) {
                dialogShowAction = reprintKimStatusShow;
                dialogUpdateAction = reprintKimStatusUpdate;
                dialogHideAction = reprintKimStatusHide;
                
                startPrintKims(concreteParticipantId);
            }
            function reprintKimStatusShow() {
                $('.reprint-button', '#reprintKimContainer').hide();
                $('input', '#reprintKimContainer').attr("disabled", "disabled");
                $(".ui-dialog-titlebar-close", $('#reprintKimContainer').parent()).hide();
            }
            function reprintKimStatusUpdate(current, nextFio, nextPlace, concreteParticipantId) {
                printNextKim(concreteParticipantId);
            }            
            function reprintKimStatusHide() {
                dialogHideAction = null;
                $('#reprintKimContainer').dialog("close");
                $('input', '#reprintKimContainer').removeAttr("disabled");
                $('.reprint-button', '#reprintKimContainer').show();
            }
            
            
            function printProtocol() {
                var form = $('#printProtocolForm');
                $("[name='additionalData']", form).val(new Date().getTime());
                form.submit();
            }
        
            function blankAccepted(sender) {
                var participantId = $(sender).attr('data-participantId');
                $('#blankaccepted-container').attr('participant-id', participantId);
                
                var participantFullnameTd = $(':first-child', $(sender).parent().parent()).next();
                var participantFullnameContainer = $(':first-child', $(':first-child', participantFullnameTd));
                var participantFullname = participantFullnameContainer.html();
                $("#blankaccepted-participantfullname").html(participantFullname);
                
                $('#blankaccepted-container').dialog({ 
                    title: 'Подтверждение сдачи бланков', 
                    width: 600,
                    height: 220,
                    modal: true,
                    resizable: false,
                    close: function() { 
                        $('#blankaccepted-container').removeAttr('participant-id');
                    }
                });

            }
            
            function blankAcceptedYes() {
                var participantId = $('#blankaccepted-container').attr('participant-id');

                blankAcceptedAction(participantId); 
                $('#blankaccepted-container').dialog("close");
            }

            function blankAcceptedNo() {
                $('#blankaccepted-container').dialog("close");
            }

            function blankAcceptedAction(participantId) {
                $.ajax({
                    type: 'POST',
                    url: '<c:url value="/blankAccepted.action" />',
                    dataType: 'json',
                    data: { participantId: participantId },
                    async: true,
                    success: function()
                    {
                        updatePage();
                    }
                });
            }
            
            function printCorrectionProtocol() {
                var form = $('#printCorrectionForm');
                $("[name='additionalData']", form).val(new Date().getTime());
                form.submit();
            }
            
            function printAllKimConcat() {
                var orderByFullname = $("#print-orderby-fullname").is(':checked');
                var printingId = generatePrintingId();
                printAllKimStatusShow();
                var src = "<c:url value="/printallkim.action"/>?printingId=" + printingId + "&orderByFullname=" + orderByFullname + "&additionalData=" + new Date().getTime();
                $("body").append("<iframe id='kim-pdf-content' class='kim-pdf-content' style='visibility:hidden;' width='1' height='1' src='" + src + "'></iframe>");
                updatePrintingProgress(printingId);    
            }
            
            function updatePrintingProgress(printingId) {
                $.get(
                    '<c:url value="getprintingprogress.json"/>',
                    {printingId: printingId},
                    function(data) {
                        var total = '0';
                        var step = '0';
                        var complete = false;
                        if (data) {
                            total = data.total ? data.total : '0';
                            step = data.step ? data.step : '0';
                            complete = data.complete ? data.complete : false;
                        }
                        $("#printAllKimStatusCurrent").html(step);
                        $("#printAllKimStatusTotal").html(total);
                        if(complete) {
                            printAllKimStatusHide();
                        } else {
                            setTimeout('updatePrintingProgress("' + printingId + '")', 1000);
                        }
                    }
                );
            }
            
            function generatePrintingId() {
                // http://stackoverflow.com/questions/105034/how-to-create-a-guid-uuid-in-javascript
                var S4 = function() {
                   return (((1+Math.random())*0x10000)|0).toString(16).substring(1);
                };
                return (S4()+S4()+"-"+S4()+"-"+S4()+"-"+S4()+"-"+S4()+S4()+S4());
            }
            
        </script>
        <%@ include file="checkpdfplugin-api.jspf" %>
        <%@ include file="checkinternet-api.jspf" %>
    </head>
<body>

<noscript>
    <style type="text/css">
        .pagecontent {display:none;}
    </style>
    <div class="noscriptmsg">
        <%@include file="noscript.jspf" %>
    </div>
</noscript>        
<div class="pagecontent">         
        
        <div class="wrapper">
        <%@ include file="header.jspf" %>
        <%@ include file="stationinfo.jspf" %>
        <%-- Текущие действия --%>

            <div class="container box-shadow paper-list">

                <h1 id="exam-actions-title" class="page-title" style="display:none;">ТЕКУЩИЕ ДЕЙСТВИЯ</h1>
                <table id="exam-actions-table" class="exam-action info-box" style="display:none;">
                <c:forEach items="${examActions}" var="action">
                    <tr id="action_<c:out value="${action.examActionType}"/>" style="display:none;">
                        <td <c:if test="${!action.executableAction}">colspan="2"</c:if>> 
                            <div style="font-weight: bold;"><c:out value="${action.title}"/></div>
                            <div><c:out value="${action.text}" escapeXml="false"/></div>
                        </td>
                    <c:if test="${action.executableAction}">
                        <td>
                            <div class="button button-green"
                                onclick="<c:out value="${action.clientAction}"/>">
                                <c:out value="${action.clientActionButtonCaption}"/>
                            </div>
                        </td>
                    </c:if>
                    </tr>
                </c:forEach>
                </table>
                <br /><br /><br />

                <table id="examStatuses" class="participants" cellpadding="0" cellspacing="0" border="0">
                    <thead>
                        <tr>
                            <th title="Сортировать по номеру места" class="header sortable"><a class="normal sort-header"  href="javascript:void(0)">№ места</a></th>
                            <th title="Сортировать по ФИО участника" class="header left-align sortable"><a class="normal sort-header" href="javascript:void(0)">ФИО участника</a></th>
                            <th title="Сортировать по статусу экзамена" class="header sortable"><a class="normal sort-header"   href="javascript:void(0)">Статус экзамена </a></th>
                            <th title="Сортировать по времени" class="header sortable"><p class="normal">До конца экзамена осталось</p></th>
                            <th class="header"><p class="normal">Дополнительные сведения</p></th>
                            <th class="header"><p class="normal">Действия</p></th>
                            <th class="header"><p class="normal">Дополнительные функции</p></th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
                <table style="display: none;"  cellpadding="0" cellspacing="0" border="0">
                    <tr>
                        <td>
                            <input type="button" onclick="setStatus(6)" value="Сделать отметку, что участник не закончил экзамен по уважительной причине"/>
                        </td>
                        <td>
                            <input type="button" onclick="setStatus(7)" value="Сделать отметку об удалении участника за нарушение порядка проведения ЕГЭ"/>
                        </td>
                        <td>
                            <input type="button" onclick="setStatus(8)" value="Отметить неявку" />
                        </td>
                        <td>
                            <input type="button" onclick="setStatus(0)" value='Установить статус "Не начат"' />
                        </td>
                    </tr>
                </table>

                <form id="printBlankForm" action='<c:url value="/downloadReport.action"/>'>
                    <input name="isIe" type ="hidden" id="isIe" />
                    <%--Поле additionalData служит только для того, изменять URL запроса 
                        для предотвращение того, что браузер возьмёт документ из кеша.
                        Поэтому в него при каждом запросе надо писать новое значение--%>
                    <input name="additionalData" type ="hidden" id="additionalData"/>
                    <input name="participantId" type="hidden" id="printBlankHidden"/>
                </form>

                <div style="display:none;">
                    <form id="printProtocolForm" action='<c:url value="/downloadProtocol.action"/>' method="POST">
                        <%--Поле additionalData служит только для того, изменять URL запроса 
                            для предотвращение того, что браузер возьмёт документ из кеша.
                            Поэтому в него при каждом запросе надо писать новое значение--%>
                        <input name="additionalData" type ="hidden" />
                    </form>

                    <form id="printCorrectionForm" action='<c:url value="/downloadCorrectionProtocol.action"/>' method="POST">
                        <%--Поле additionalData служит только для того, изменять URL запроса 
                            для предотвращение того, что браузер возьмёт документ из кеша.
                            Поэтому в него при каждом запросе надо писать новое значение--%>
                        <input name="additionalData" type ="hidden" />
                    </form>
                        
                    <c:if test="${!empty printKimModel}">
                        <div id="printKimDialogContainer">
                            <p>КИМ должны быть распечатаны и розданы участникам после запуска участников в аудиторию и до начала экзамена.</p>
                            <p>Рекомендуется передавать участнику распечатанный КИМ после проверки его персональных данных и активации экзамена на рабочем месте участника.</p>
                            <p>На каждом варианте распечатанных КИМ будет указана фамилия участника, которому его необходимо передать.</p>
                            <p>Повторная печать КИМ (в случа порчи КИМ или обнаружения брака) доступна только после ввода пароля Уполномоченным ГЭК.</p>

                            <p>
                                Всего вариантов КИМ к печати: <span id="kimVariantsPrintCount"><c:out value="${printKimModel.kimVariantsPrintCount}"/></span>
                                &nbsp;из&nbsp;
                                <span id="kimVariantsTotalCount"><c:out value="${printKimModel.kimVariantsTotalCount}"/></span>.
                                <br />
                                Оценочное количество страниц: <span id="approximatePagesCount"><c:out value="${printKimModel.approximatePagesCount}"/></span>.
                            </p>

                            <div class="printkim-ordermode">
                                Выберите порядок печати КИМ:
                                <br />
                                <div>
                                    <input checked="checked" id="print-orderby-number" name="printKimOrderMode" type="radio" />
                                    <label for="print-orderby-number">Печатать КИМ в порядке возрастания номеров мест в аудитории</label>
                                </div>
                                <div>
                                    <input id="print-orderby-fullname" name="printKimOrderMode" type="radio" />
                                    <label for="print-orderby-fullname">Печатать КИМ в алфавитном порядке по ФИО Участников</label>
                                </div>
                            </div>
                        </div>

                        <div id="printAllKimStatusContainer">
                            Формирование КИМ&nbsp;&nbsp;<img src='<c:url value="/images/progress.gif"/>'/>&nbsp;&nbsp;
                            <span id="printAllKimStatusCurrent"></span>
                            &nbsp;из&nbsp;
                            <span id="printAllKimStatusTotal"></span>
                        </div>

                            <div id="printParticipantKimStatusContainer" class="dialog-container">
                            Напечатано КИМ:&nbsp;
                            <span id="printParticipantKimStatusCurrent"></span>
                            &nbsp;из&nbsp;
                            <span id="printParticipantKimStatusTotal"></span>
                            <div class="info-box">
                                <p>
                                    Последний КИМ напечатан для участника:
                                </p>
                                <p>
                                    <span id="printParticipantKimStatusLastFio"></span>&nbsp;место в аудитории:&nbsp;<span id="printParticipantKimStatusLastPlace"></span>
                                </p>
                            </div>
                            <div class="print-dialog-content" style="height: 60px;">
                                <p>
                                    КИМ будет напечатан для участника:
                                </p>
                                <p>
                                    <span id="printParticipantKimStatusNextFio"></span>&nbsp;место в аудитории: <span id="printParticipantKimStatusNextPlace"></span>
                                </p>
                                <div id="print-by-participant-progress" style="display: none; float: left;">Формирование КИМ…&nbsp;<img src='<c:url value="/images/progress.gif"/>'/></div>
                                <div id="button-accept-kim-print" class="button button-green dialog-button">На печать</div>
                                <div id="button-cancel-kim-print" class="button button-grey dialog-button">Отмена</div>
                            </div>
                        </div>
                    </c:if>

                    <div id="reprintKimContainer">
                        <div>
                            Повторная печать КИМ возможна только после ввода пароля Уполномоченным ГЭК.
                        </div>
                        <div>
                            <table>
                            <tr>
                                <td>
                                  Введите пароль доступа к электронным КИМ (тот же самый, который использовался при расшифровке КИМ):
                                </td>
                                <td>
                                    <input id="reprintKimPassword" type="text" />
                                </td>
                            </tr>
                            </table>
                        </div>
                        <div class="reprint-last">
                            КИМ будет повторно распечатан для участника:
                            <br />
                            <span id="reprintKimParticipantFullName"></span>
                        </div>
                        <hr class="light-grey">
                        <div id="reprintKeyValidationMessage" style="float:left; color:red; visibility: hidden;">Введен неверный<br />пароль активации</div>
                        <div onclick="reprintDialogClose();" class="button button-grey reprint-button">Отмена</div>
                        <div onclick="reprintStart();" class="button button-green reprint-button">Печать</div>
                    </div>
                        
                    <div id="assignKimContainer">
                        <div style="margin-bottom: 10px">Все экзамены в статусе «Печать КИМ» будут переведены в статус «Не начат».</div>
                        <div>
                            <table>
                            <tr>
                                <td>
                                  Введите пароль для начала экзамена без печати КИМ:
                                </td>
                                <td>
                                    <input id="assignKimPassword" type="password" />
                                </td>
                            </tr>
                            </table>    
                        </div>
                        <hr class="light-grey">
                        <div id="assignKimValidationMessage" style="float:left; color:red;"></div>
                        <div onclick="assignKimDialogClose();" class="button button-grey assign-kim-button">Отмена</div>
                        <div onclick="assignKimStart();" class="button button-green assign-kim-button" style="width: 130px">Начать экзамен</div>
                    </div>
                        
                </div>

                <div id="participantInfo" style="display: none;" >
                    <table style="width: 100%; font-weight: normal; font-size: 1em;" cellspacing="0">
                        <tbody>
                            <c:if test="${isTestMode}">
                                <tr>
                                    <td>
                                        <label>Регистрационный номер:</label>
                                    </td>
                                    <td>
                                        <span id="regNumber"></span>
                                    </td>
                                </tr>
                           </c:if>
                            <tr>
                                <td>
                                    <label>ФИО:</label>
                                </td>
                                <td>
                                    <span id="p_surname">Афанасьев</span>&nbsp;<span id="p_name">Глеб</span>&nbsp;<span id="p_secondname">Андреевич</span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <label>Документ:</label>
                                </td>
                                <td>
                                    <div id="document-type"></div>
                                    <div>
                                        <span id="document-series">1236</span>-<span id="document-number">463747</span>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <label>Код образовательного учреждения:</label>
                                </td>
                                <td>
                                    <span id="code">023917</span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <label>Класс:</label>
                                </td>
                                <td>
                                    <span id="class">11Д</span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <label>Номер места в аудитории:</label>
                                </td>
                                <td>
                                    <span id="placeNum">2:Д</span>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <label>Номер КИМ:</label>
                                </td>
                                <td>
                                    <span id="kimNum">11Д</span>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                        
            </div>
        </div>
                        
        <div id="reprint-blank-dialog" class="dialog-container" style="display: none;"> 
            <p>Вы уверены, что хотите повторно напечатать бланк для участника <span id="reprint-participant-fullname"></span>?</p>
            <hr class="light-grey">
            <div class="button button-grey button-close dialog-button dialog-button-right">Нет</div>
            <div id="button-accept-print" class="button button-green dialog-button dialog-button-right">Да</div>
        </div>
                        
        <div id="blankaccepted-container" style="display: none;">
            <div>
                Выполняя это действие, Вы подтверждаете, что участник завершил сдачу экзамена и сдал организатору подписанные бланки.
            </div>
            <div>
                Все дальнейшие действия по экзамену участника будут запрещены. В случае форс-мажорных обстоятельств можно повторно распечатать бланки участника.
            </div>
            <div>
                Подтверждаете, что участник <span id="blankaccepted-participantfullname"></span> сдал подписанные бланки?
            </div>
            <hr class="light-grey">
            <div onclick="blankAcceptedNo();" class="button button-green blankaccepted-button">Нет</div>
            <div onclick="blankAcceptedYes();" class="button button-green blankaccepted-button">Да</div>
        </div>
                        
        <div id="participant-regnums-container" style="display: none;">
            <table id="participant-regnums-table" cellspacing="10" style="width: 100%">
                
            </table>
        </div>
    </div>                        
                        
    </body>
</html>
